/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.MoreObjects;
import io.airlift.stats.DistributionStat;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class OrcWriterFlushStats {
    private final String name;
    private final DistributionStat stripeBytes = new DistributionStat();
    private final DistributionStat stripeRows = new DistributionStat();
    private final DistributionStat dictionaryBytes = new DistributionStat();

    public OrcWriterFlushStats(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    @Managed
    @Nested
    public DistributionStat getStripeBytes() {
        return this.stripeBytes;
    }

    @Managed
    @Nested
    public DistributionStat getStripeRows() {
        return this.stripeRows;
    }

    @Managed
    @Nested
    public DistributionStat getDictionaryBytes() {
        return this.dictionaryBytes;
    }

    public void recordStripeWritten(long stripeBytes, long stripeRows, int dictionaryBytes) {
        this.stripeBytes.add(stripeBytes);
        this.stripeRows.add(stripeRows);
        this.dictionaryBytes.add((long)dictionaryBytes);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("stripeBytes", (Object)this.stripeBytes).add("stripeRows", (Object)this.stripeRows).add("dictionaryBytes", (Object)this.dictionaryBytes).toString();
    }
}

