/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.airlift.slice.Slice;
import io.trino.parquet.RichColumnDescriptor;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Type;
import java.math.BigInteger;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class LongDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;

    LongDecimalColumnReader(RichColumnDescriptor descriptor, DecimalType parquetDecimalType) {
        super(descriptor);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        if (!(trinoType instanceof DecimalType)) {
            throw new ParquetDecodingException(String.format("Unsupported Trino column type (%s) for Parquet column (%s)", new Object[]{trinoType, this.columnDescriptor}));
        }
        DecimalType trinoDecimalType = (DecimalType)trinoType;
        Binary binary = this.valuesReader.readBytes();
        Slice value = Decimals.encodeUnscaledValue((BigInteger)new BigInteger(binary.getBytes()));
        if (trinoDecimalType.isShort()) {
            trinoType.writeLong(blockBuilder, DecimalConversions.longToShortCast((Slice)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
        } else {
            trinoType.writeSlice(blockBuilder, DecimalConversions.longToLongCast((Slice)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
        }
    }
}

