/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.dictionary.Dictionary;
import java.io.IOException;
import org.apache.parquet.column.values.plain.PlainValuesReader;

public class IntegerDictionary
extends Dictionary {
    private final int[] content;

    public IntegerDictionary(DictionaryPage dictionaryPage) throws IOException {
        super(dictionaryPage.getEncoding());
        this.content = new int[dictionaryPage.getDictionarySize()];
        PlainValuesReader.IntegerPlainValuesReader intReader = new PlainValuesReader.IntegerPlainValuesReader();
        intReader.initFromPage(dictionaryPage.getDictionarySize(), ParquetReaderUtils.toInputStream(dictionaryPage));
        for (int i = 0; i < this.content.length; ++i) {
            this.content[i] = intReader.readInteger();
        }
    }

    @Override
    public int decodeToInt(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

