/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import io.airlift.compress.Compressor;
import io.airlift.compress.snappy.SnappyCompressor;
import io.airlift.compress.zstd.ZstdCompressor;
import io.airlift.slice.Slices;
import io.trino.parquet.writer.ParquetDataOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Objects;
import java.util.zip.GZIPOutputStream;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

interface ParquetCompressor {
    public ParquetDataOutput compress(BytesInput var1) throws IOException;

    public static ParquetCompressor getCompressor(CompressionCodecName codec) {
        switch (codec.getParquetCompressionCodec()) {
            case GZIP: {
                return new GzipCompressor();
            }
            case SNAPPY: {
                return new AirLiftCompressor((Compressor)new SnappyCompressor());
            }
            case ZSTD: {
                return new AirLiftCompressor((Compressor)new ZstdCompressor());
            }
            case UNCOMPRESSED: {
                return null;
            }
            case LZO: 
            case LZ4: 
            case LZ4_RAW: {
                break;
            }
        }
        throw new RuntimeException("Unsupported codec: " + codec);
    }

    public static class AirLiftCompressor
    implements ParquetCompressor {
        private final Compressor compressor;

        AirLiftCompressor(Compressor compressor) {
            this.compressor = Objects.requireNonNull(compressor, "compressor is null");
        }

        @Override
        public ParquetDataOutput compress(BytesInput bytesInput) throws IOException {
            int minCompressionBufferSize = this.compressor.maxCompressedLength(Math.toIntExact(bytesInput.size()));
            byte[] compressionBuffer = new byte[minCompressionBufferSize];
            byte[] bytes = bytesInput.toByteArray();
            int compressedDataSize = this.compressor.compress(bytes, 0, bytes.length, compressionBuffer, 0, compressionBuffer.length);
            return ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])compressionBuffer, (int)0, (int)compressedDataSize));
        }
    }

    public static class GzipCompressor
    implements ParquetCompressor {
        @Override
        public ParquetDataOutput compress(BytesInput bytesInput) throws IOException {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try (GZIPOutputStream outputStream = new GZIPOutputStream(byteArrayOutputStream);){
                outputStream.write(bytesInput.toByteArray(), 0, Math.toIntExact(bytesInput.size()));
            }
            byte[] bytes = byteArrayOutputStream.toByteArray();
            return ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])bytes, (int)0, (int)bytes.length));
        }
    }
}

