/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.airlift.slice.Slice;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.reader.SimpleSliceInputStream;
import java.nio.ByteBuffer;
import java.util.Set;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;

public final class ParquetReaderUtils {
    private ParquetReaderUtils() {
    }

    public static ByteBufferInputStream toInputStream(Slice slice) {
        return ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{slice.toByteBuffer()});
    }

    public static ByteBufferInputStream toInputStream(DictionaryPage page) {
        return ParquetReaderUtils.toInputStream(page.getSlice());
    }

    public static int readUleb128Int(SimpleSliceInputStream input) {
        byte[] inputBytes = input.getByteArray();
        int offset = input.getByteArrayOffset();
        byte inputByte = inputBytes[offset];
        int value = inputByte & 0x7F;
        if ((inputByte & 0x80) == 0) {
            input.skip(1);
            return value;
        }
        inputByte = inputBytes[offset + 1];
        value |= (inputByte & 0x7F) << 7;
        if ((inputByte & 0x80) == 0) {
            input.skip(2);
            return value;
        }
        inputByte = inputBytes[offset + 2];
        value |= (inputByte & 0x7F) << 14;
        if ((inputByte & 0x80) == 0) {
            input.skip(3);
            return value;
        }
        inputByte = inputBytes[offset + 3];
        value |= (inputByte & 0x7F) << 21;
        if ((inputByte & 0x80) == 0) {
            input.skip(4);
            return value;
        }
        inputByte = inputBytes[offset + 4];
        Verify.verify(((inputByte & 0x80) == 0 ? 1 : 0) != 0, (String)"ULEB128 variable-width integer should not be longer than 5 bytes", (Object[])new Object[0]);
        input.skip(5);
        return value | inputByte << 28;
    }

    public static int readFixedWidthInt(SimpleSliceInputStream input, int bytesWidth) {
        return switch (bytesWidth) {
            case 0 -> 0;
            case 1 -> input.readByte() & 0xFF;
            case 2 -> input.readShort() & 0xFFFF;
            case 3 -> {
                int value = input.readShort() & 0xFFFF;
                yield (input.readByte() & 0xFF) << 16 | value;
            }
            case 4 -> input.readInt();
            default -> throw new IllegalArgumentException(String.format("Encountered bytesWidth (%d) that requires more than 4 bytes", bytesWidth));
        };
    }

    public static long propagateSignBit(long value, int bitsToPad) {
        return value << bitsToPad >> bitsToPad;
    }

    public static byte castToByte(boolean value) {
        return (byte)(value ? 1 : 0);
    }

    public static byte castToByteNegate(boolean value) {
        return (byte)(!value ? 1 : 0);
    }

    public static short toShortExact(int value) {
        if ((short)value != value) {
            throw new ArithmeticException(String.format("Value %d exceeds short range", value));
        }
        return (short)value;
    }

    public static byte toByteExact(int value) {
        if ((byte)value != value) {
            throw new ArithmeticException(String.format("Value %d exceeds byte range", value));
        }
        return (byte)value;
    }

    public static boolean isOnlyDictionaryEncodingPages(ColumnChunkMetaData columnMetaData) {
        EncodingStats stats = columnMetaData.getEncodingStats();
        if (stats != null) {
            return stats.hasDictionaryPages() && !stats.hasNonDictionaryEncodedPages();
        }
        Set encodings = columnMetaData.getEncodings();
        if (encodings.contains(Encoding.PLAIN_DICTIONARY)) {
            return Sets.difference((Set)encodings, (Set)ImmutableSet.of((Object)Encoding.PLAIN_DICTIONARY, (Object)Encoding.RLE, (Object)Encoding.BIT_PACKED)).isEmpty();
        }
        return false;
    }
}

