/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.BinaryColumnReader;
import io.trino.parquet.reader.BooleanColumnReader;
import io.trino.parquet.reader.ColumnReader;
import io.trino.parquet.reader.DecimalColumnReaderFactory;
import io.trino.parquet.reader.DoubleColumnReader;
import io.trino.parquet.reader.FloatColumnReader;
import io.trino.parquet.reader.Int64TimestampMillisColumnReader;
import io.trino.parquet.reader.Int64TimestampNanosColumnReader;
import io.trino.parquet.reader.IntColumnReader;
import io.trino.parquet.reader.LongColumnReader;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.parquet.reader.TimeMicrosColumnReader;
import io.trino.parquet.reader.TimestampColumnReader;
import io.trino.parquet.reader.TimestampMicrosColumnReader;
import io.trino.parquet.reader.UuidColumnReader;
import io.trino.parquet.reader.decoders.TransformingValueDecoders;
import io.trino.parquet.reader.decoders.ValueDecoders;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.BinaryColumnAdapter;
import io.trino.parquet.reader.flat.BooleanColumnAdapter;
import io.trino.parquet.reader.flat.ByteColumnAdapter;
import io.trino.parquet.reader.flat.FlatColumnReader;
import io.trino.parquet.reader.flat.Int128ColumnAdapter;
import io.trino.parquet.reader.flat.Int96ColumnAdapter;
import io.trino.parquet.reader.flat.IntColumnAdapter;
import io.trino.parquet.reader.flat.LongColumnAdapter;
import io.trino.parquet.reader.flat.ShortColumnAdapter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarcharType;
import java.util.Optional;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public final class ColumnReaderFactory {
    private ColumnReaderFactory() {
    }

    public static ColumnReader create(PrimitiveField field, DateTimeZone timeZone, AggregatedMemoryContext aggregatedMemoryContext, boolean useBatchedColumnReaders) {
        Type type = field.getType();
        PrimitiveType.PrimitiveTypeName primitiveType = field.getDescriptor().getPrimitiveType().getPrimitiveTypeName();
        LogicalTypeAnnotation annotation = field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        LocalMemoryContext memoryContext = aggregatedMemoryContext.newLocalMemoryContext(ColumnReader.class.getSimpleName());
        if (useBatchedColumnReaders && field.getDescriptor().getPath().length == 1) {
            VarcharType varcharType;
            LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
            DecimalType decimalType;
            TimestampWithTimeZoneType timestampWithTimeZoneType;
            TimestampType timestampType;
            if (BooleanType.BOOLEAN.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                return new FlatColumnReader<byte[]>(field, ValueDecoders::getBooleanDecoder, BooleanColumnAdapter.BOOLEAN_ADAPTER, memoryContext);
            }
            if (TinyintType.TINYINT.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                if (ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                    return new FlatColumnReader<byte[]>(field, ValueDecoders::getByteDecoder, ByteColumnAdapter.BYTE_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (SmallintType.SMALLINT.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                if (ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                    return new FlatColumnReader<short[]>(field, ValueDecoders::getShortDecoder, ShortColumnAdapter.SHORT_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (DateType.DATE.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                if (annotation == null || annotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation) {
                    return new FlatColumnReader<int[]>(field, ValueDecoders::getIntDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (type instanceof AbstractIntType && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                if (ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                    return new FlatColumnReader<int[]>(field, ValueDecoders::getIntDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (type instanceof AbstractLongType && primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                if (ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                    return new FlatColumnReader<long[]>(field, ValueDecoders::getIntToLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (type instanceof TimeType && primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeAnnotation;
                if (annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation && (timeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)annotation).getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                    return new FlatColumnReader<long[]>(field, TransformingValueDecoders::getTimeMicrosDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (type instanceof AbstractLongType && primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                if (BigintType.BIGINT.equals((Object)type) && annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                    return new FlatColumnReader<long[]>(field, ValueDecoders::getLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                if (ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                    return new FlatColumnReader<long[]>(field, ValueDecoders::getLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
            if (RealType.REAL.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.FLOAT) {
                return new FlatColumnReader<int[]>(field, ValueDecoders::getRealDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
            }
            if (DoubleType.DOUBLE.equals((Object)type)) {
                if (primitiveType == PrimitiveType.PrimitiveTypeName.DOUBLE) {
                    return new FlatColumnReader<long[]>(field, ValueDecoders::getDoubleDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                if (primitiveType == PrimitiveType.PrimitiveTypeName.FLOAT) {
                    return new FlatColumnReader<long[]>(field, TransformingValueDecoders::getFloatToDoubleDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
            }
            if (type instanceof TimestampType) {
                timestampType = (TimestampType)type;
                if (primitiveType == PrimitiveType.PrimitiveTypeName.INT96) {
                    if (timestampType.isShort()) {
                        return new FlatColumnReader<long[]>(field, (encoding, primitiveField) -> TransformingValueDecoders.getInt96ToShortTimestampDecoder(encoding, primitiveField, timeZone), LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    return new FlatColumnReader<Int96ColumnAdapter.Int96Buffer>(field, (encoding, primitiveField) -> TransformingValueDecoders.getInt96ToLongTimestampDecoder(encoding, primitiveField, timeZone), Int96ColumnAdapter.INT96_ADAPTER, memoryContext);
                }
            }
            if (type instanceof TimestampWithTimeZoneType) {
                timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
                if (primitiveType == PrimitiveType.PrimitiveTypeName.INT96) {
                    if (timestampWithTimeZoneType.isShort()) {
                        return new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt96ToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    throw ColumnReaderFactory.unsupportedException(type, field);
                }
            }
            if (type instanceof TimestampType) {
                timestampType = (TimestampType)type;
                if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                    if (!(annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
                    if (timestampType.isShort()) {
                        return switch (timestampAnnotation.getUnit()) {
                            default -> throw new IncompatibleClassChangeError();
                            case LogicalTypeAnnotation.TimeUnit.MILLIS -> new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt64TimestampMillsToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.MICROS -> new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt64TimestampMicrosToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.NANOS -> new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt64TimestampNanosToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                        };
                    }
                    return switch (timestampAnnotation.getUnit()) {
                        default -> throw new IncompatibleClassChangeError();
                        case LogicalTypeAnnotation.TimeUnit.MILLIS -> new FlatColumnReader<Int96ColumnAdapter.Int96Buffer>(field, TransformingValueDecoders::getInt64TimestampMillisToLongTimestampDecoder, Int96ColumnAdapter.INT96_ADAPTER, memoryContext);
                        case LogicalTypeAnnotation.TimeUnit.MICROS -> new FlatColumnReader<Int96ColumnAdapter.Int96Buffer>(field, TransformingValueDecoders::getInt64TimestampMicrosToLongTimestampDecoder, Int96ColumnAdapter.INT96_ADAPTER, memoryContext);
                        case LogicalTypeAnnotation.TimeUnit.NANOS -> new FlatColumnReader<Int96ColumnAdapter.Int96Buffer>(field, TransformingValueDecoders::getInt64TimestampNanosToLongTimestampDecoder, Int96ColumnAdapter.INT96_ADAPTER, memoryContext);
                    };
                }
            }
            if (type instanceof TimestampWithTimeZoneType) {
                timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
                if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                    if (!(annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
                    if (timestampWithTimeZoneType.isShort()) {
                        return switch (timestampAnnotation.getUnit()) {
                            default -> throw new IncompatibleClassChangeError();
                            case LogicalTypeAnnotation.TimeUnit.MILLIS -> new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt64TimestampMillsToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.MICROS -> new FlatColumnReader<long[]>(field, TransformingValueDecoders::getInt64TimestampMicrosToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.NANOS -> throw ColumnReaderFactory.unsupportedException(type, field);
                        };
                    }
                    switch (timestampAnnotation.getUnit()) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case MILLIS: 
                        case NANOS: {
                            throw ColumnReaderFactory.unsupportedException(type, field);
                        }
                        case MICROS: 
                    }
                    return new FlatColumnReader<Int96ColumnAdapter.Int96Buffer>(field, TransformingValueDecoders::getInt64TimestampMicrosToLongTimestampWithTimeZoneDecoder, Int96ColumnAdapter.INT96_ADAPTER, memoryContext);
                }
            }
            if (type instanceof DecimalType && (decimalType = (DecimalType)type).isShort() && (primitiveType == PrimitiveType.PrimitiveTypeName.INT32 || primitiveType == PrimitiveType.PrimitiveTypeName.INT64 || primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) && annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && !ColumnReaderFactory.isDecimalRescaled(decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation, decimalType)) {
                return new FlatColumnReader<long[]>(field, ValueDecoders::getShortDecimalDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
            }
            if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort() && (primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) && annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && !ColumnReaderFactory.isDecimalRescaled(decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation, decimalType)) {
                return new FlatColumnReader<long[]>(field, ValueDecoders::getLongDecimalDecoder, Int128ColumnAdapter.INT128_ADAPTER, memoryContext);
            }
            if (type instanceof VarcharType && !(varcharType = (VarcharType)type).isUnbounded() && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                return new FlatColumnReader<BinaryBuffer>(field, ValueDecoders::getBoundedVarcharBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
            }
            if (type instanceof CharType && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                return new FlatColumnReader<BinaryBuffer>(field, ValueDecoders::getCharBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
            }
            if (type instanceof AbstractVariableWidthType && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                return new FlatColumnReader<BinaryBuffer>(field, ValueDecoders::getBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
            }
            if (UuidType.UUID.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                if (annotation == null || ColumnReaderFactory.isLogicalUuid(annotation)) {
                    return new FlatColumnReader<long[]>(field, ValueDecoders::getUuidDecoder, Int128ColumnAdapter.INT128_ADAPTER, memoryContext);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
        }
        return switch (primitiveType) {
            default -> throw new IncompatibleClassChangeError();
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new BooleanColumnReader(field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> ColumnReaderFactory.createDecimalColumnReader(field).orElse(new IntColumnReader(field));
            case PrimitiveType.PrimitiveTypeName.INT64 -> {
                if (annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)annotation;
                    if (timeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                        yield new TimeMicrosColumnReader(field);
                    }
                    throw ColumnReaderFactory.unsupportedException(type, field);
                }
                if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) {
                    LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
                    if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                        yield new Int64TimestampMillisColumnReader(field);
                    }
                    if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                        yield new TimestampMicrosColumnReader(field);
                    }
                    if (timestampAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.NANOS) {
                        yield new Int64TimestampNanosColumnReader(field);
                    }
                    throw ColumnReaderFactory.unsupportedException(type, field);
                }
                yield ColumnReaderFactory.createDecimalColumnReader(field).orElse(new LongColumnReader(field));
            }
            case PrimitiveType.PrimitiveTypeName.INT96 -> new TimestampColumnReader(field, timeZone);
            case PrimitiveType.PrimitiveTypeName.FLOAT -> new FloatColumnReader(field);
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> new DoubleColumnReader(field);
            case PrimitiveType.PrimitiveTypeName.BINARY -> ColumnReaderFactory.createDecimalColumnReader(field).orElse(new BinaryColumnReader(field));
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> {
                Optional<PrimitiveColumnReader> decimalColumnReader = ColumnReaderFactory.createDecimalColumnReader(field);
                if (decimalColumnReader.isPresent()) {
                    yield decimalColumnReader.get();
                }
                if (ColumnReaderFactory.isLogicalUuid(annotation)) {
                    yield new UuidColumnReader(field);
                }
                if (annotation == null) {
                    yield new UuidColumnReader(field);
                }
                throw ColumnReaderFactory.unsupportedException(type, field);
            }
        };
    }

    private static boolean isLogicalUuid(LogicalTypeAnnotation annotation) {
        return Optional.ofNullable(annotation).flatMap(logicalTypeAnnotation -> logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
                return Optional.of(Boolean.TRUE);
            }
        })).orElse(Boolean.FALSE);
    }

    private static Optional<PrimitiveColumnReader> createDecimalColumnReader(PrimitiveField field) {
        return ParquetTypeUtils.createDecimalType(field).map(decimalType -> DecimalColumnReaderFactory.createReader(field, decimalType));
    }

    private static boolean isDecimalRescaled(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation, DecimalType trinoType) {
        return decimalAnnotation.getPrecision() != trinoType.getPrecision() || decimalAnnotation.getScale() != trinoType.getScale();
    }

    private static boolean isIntegerAnnotation(LogicalTypeAnnotation typeAnnotation) {
        return typeAnnotation == null || typeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation || ColumnReaderFactory.isZeroScaleDecimalAnnotation(typeAnnotation);
    }

    private static boolean isZeroScaleDecimalAnnotation(LogicalTypeAnnotation typeAnnotation) {
        return typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && ((LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale() == 0;
    }

    private static TrinoException unsupportedException(Type type, PrimitiveField field) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", type, field.getDescriptor()));
    }
}

