/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;

public class FilteredRowRanges {
    private final RowRanges parquetRowRanges;
    private final List<RowRange> rowRanges;
    private final long rowCount;

    public FilteredRowRanges(RowRanges parquetRowRanges) {
        this.parquetRowRanges = Objects.requireNonNull(parquetRowRanges, "parquetRowRanges is null");
        this.rowRanges = FilteredRowRanges.constructRanges(parquetRowRanges);
        this.rowCount = parquetRowRanges.rowCount();
    }

    public RowRanges getParquetRowRanges() {
        return this.parquetRowRanges;
    }

    public List<RowRange> getRowRanges() {
        return this.rowRanges;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    private static List<RowRange> constructRanges(RowRanges rowRanges) {
        return (List)rowRanges.getRanges().stream().map(range -> new RowRange(range.from, range.to)).collect(ImmutableList.toImmutableList());
    }

    public record RowRange(long start, long end) {
    }
}

