/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.Field;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public record ParquetReaderColumn(Type type, Optional<Field> field, boolean isRowIndexColumn) {
    public ParquetReaderColumn(Type type, Optional<Field> field, boolean isRowIndexColumn) {
        this.type = Objects.requireNonNull(type, "type is null");
        this.field = Objects.requireNonNull(field, "field is null");
        Preconditions.checkArgument((!isRowIndexColumn || field.isEmpty() ? 1 : 0) != 0, (Object)"Field info for row index column must be empty Optional");
        this.isRowIndexColumn = isRowIndexColumn;
    }

    public static List<Field> getParquetReaderFields(List<ParquetReaderColumn> parquetReaderColumns) {
        return (List)parquetReaderColumns.stream().filter(column -> !column.isRowIndexColumn()).map(ParquetReaderColumn::field).filter(Optional::isPresent).map(Optional::get).collect(ImmutableList.toImmutableList());
    }
}

