/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTimestampUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.Int96ColumnAdapter;
import io.trino.plugin.base.type.DecodedTimestamp;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Chars;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.spi.type.Varchars;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Objects;
import org.apache.parquet.bytes.ByteBufferInputStream;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;

public class ApacheParquetValueDecoders {
    private ApacheParquetValueDecoders() {
    }

    private static void initialize(SimpleSliceInputStream input, ValuesReader reader) {
        byte[] buffer = input.readBytes();
        try {
            reader.initFromPage(0, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, 0, buffer.length)}));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static final class Int96ApacheParquetValueDecoder
    implements ValueDecoder<Int96ColumnAdapter.Int96Buffer> {
        private final ValuesReader delegate;

        public Int96ApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
            int endOffset = offset + length;
            for (int i = offset; i < endOffset; ++i) {
                DecodedTimestamp decodedTimestamp = ParquetTimestampUtils.decodeInt96Timestamp(this.delegate.readBytes());
                values.longs[i] = decodedTimestamp.epochSeconds();
                values.ints[i] = decodedTimestamp.nanosOfSecond();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class UuidApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private static final VarHandle LONG_ARRAY_HANDLE = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
        private final ValuesReader delegate;

        public UuidApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            int endOffset = (offset + length) * 2;
            for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
                byte[] data = this.delegate.readBytes().getBytes();
                values[currentOutputOffset] = LONG_ARRAY_HANDLE.get(data, 0);
                values[currentOutputOffset + 1] = LONG_ARRAY_HANDLE.get(data, 8);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class BinaryApacheParquetValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final ValuesReader delegate;

        public BinaryApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(BinaryBuffer values, int offsetsIndex, int length) {
            for (int i = 0; i < length; ++i) {
                byte[] value = this.delegate.readBytes().getBytes();
                values.add(value, i + offsetsIndex);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class CharApacheParquetValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final ValuesReader delegate;
        private final int maxLength;

        public CharApacheParquetValueDecoder(ValuesReader delegate, CharType charType) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            this.maxLength = charType.getLength();
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(BinaryBuffer values, int offsetsIndex, int length) {
            for (int i = 0; i < length; ++i) {
                byte[] value = this.delegate.readBytes().getBytes();
                Slice slice = Chars.trimTrailingSpaces((Slice)Varchars.truncateToLength((Slice)Slices.wrappedBuffer((byte[])value), (int)this.maxLength));
                values.add(slice, i + offsetsIndex);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class BoundedVarcharApacheParquetValueDecoder
    implements ValueDecoder<BinaryBuffer> {
        private final ValuesReader delegate;
        private final int boundedLength;

        public BoundedVarcharApacheParquetValueDecoder(ValuesReader delegate, VarcharType varcharType) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            Preconditions.checkArgument((!varcharType.isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)varcharType);
            this.boundedLength = varcharType.getBoundedLength();
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(BinaryBuffer values, int offsetsIndex, int length) {
            for (int i = 0; i < length; ++i) {
                byte[] value = this.delegate.readBytes().getBytes();
                Slice slice = Varchars.truncateToLength((Slice)Slices.wrappedBuffer((byte[])value), (int)this.boundedLength);
                values.add(slice, i + offsetsIndex);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class LongDecimalApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private final ValuesReader delegate;

        public LongDecimalApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            int endOffset = (offset + length) * 2;
            for (int currentOutputOffset = offset * 2; currentOutputOffset < endOffset; currentOutputOffset += 2) {
                Int128 value = Int128.fromBigEndian((byte[])this.delegate.readBytes().getBytes());
                values[currentOutputOffset] = value.getHigh();
                values[currentOutputOffset + 1] = value.getLow();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class ShortDecimalApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private final ValuesReader delegate;
        private final DecimalType decimalType;
        private final ColumnDescriptor descriptor;
        private final int typeLength;

        public ShortDecimalApacheParquetValueDecoder(ValuesReader delegate, DecimalType decimalType, ColumnDescriptor descriptor) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
            Preconditions.checkArgument((boolean)decimalType.isShort(), (String)"Decimal type %s is not a short decimal", (Object)decimalType);
            this.decimalType = decimalType;
            this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
            this.typeLength = descriptor.getPrimitiveType().getTypeLength();
            Preconditions.checkArgument((this.typeLength > 0 && this.typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)descriptor);
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            int bytesOffset = 0;
            int bytesLength = this.typeLength;
            if (this.typeLength > 8) {
                bytesOffset = this.typeLength - 8;
                bytesLength = 8;
            }
            for (int i = offset; i < offset + length; ++i) {
                byte[] bytes = this.delegate.readBytes().getBytes();
                ParquetTypeUtils.checkBytesFitInShortDecimal(bytes, 0, bytesOffset, (Type)this.decimalType, this.descriptor);
                values[i] = ParquetTypeUtils.getShortDecimalValue(bytes, bytesOffset, bytesLength);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class BooleanApacheParquetValueDecoder
    implements ValueDecoder<byte[]> {
        private final ValuesReader delegate;

        public BooleanApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            byte[] buffer = input.readBytes();
            try {
                int valueCount = buffer.length * 8;
                this.delegate.initFromPage(valueCount, ByteBufferInputStream.wrap((ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(buffer, 0, buffer.length)}));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.castToByte(this.delegate.readBoolean());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class LongApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private final ValuesReader delegate;

        public LongApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = this.delegate.readLong();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class IntToLongApacheParquetValueDecoder
    implements ValueDecoder<long[]> {
        private final ValuesReader delegate;

        public IntToLongApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = this.delegate.readInteger();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class ByteApacheParquetValueDecoder
    implements ValueDecoder<byte[]> {
        private final ValuesReader delegate;

        public ByteApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.toByteExact(this.delegate.readInteger());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class ShortApacheParquetValueDecoder
    implements ValueDecoder<short[]> {
        private final ValuesReader delegate;

        public ShortApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(short[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = ParquetReaderUtils.toShortExact(this.delegate.readInteger());
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    public static final class IntApacheParquetValueDecoder
    implements ValueDecoder<int[]> {
        private final ValuesReader delegate;

        public IntApacheParquetValueDecoder(ValuesReader delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            ApacheParquetValueDecoders.initialize(input, this.delegate);
        }

        @Override
        public void read(int[] values, int offset, int length) {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = this.delegate.readInteger();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }
}

