/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.decoders.ValueDecoders;
import io.trino.parquet.reader.flat.Int96ColumnAdapter;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.joda.time.DateTimeZone;

public class TransformingValueDecoders {
    private TransformingValueDecoders() {
    }

    public static ValueDecoder<long[]> getTimeMicrosDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000000L;
            }
        });
    }

    public static ValueDecoder<long[]> getInt96ToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field, final DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        final int precision = ((TimestampType)field.getType()).getPrecision();
        final ValueDecoder<Int96ColumnAdapter.Int96Buffer> delegate = ValueDecoders.getInt96Decoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                Int96ColumnAdapter.Int96Buffer int96Buffer = new Int96ColumnAdapter.Int96Buffer(length);
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = int96Buffer.longs[i];
                    long epochMicros = timeZone == DateTimeZone.UTC ? epochSeconds * 1000000L : timeZone.convertUTCToLocal(epochSeconds * 1000L) * 1000L;
                    int nanosOfSecond = (int)Timestamps.round((long)int96Buffer.ints[i], (int)(9 - precision));
                    values[offset + i] = epochMicros + (long)(nanosOfSecond / 1000);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt96ToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && !(timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a long timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        return new InlineTransformDecoder<Int96ColumnAdapter.Int96Buffer>(ValueDecoders.getInt96Decoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochSeconds = values.longs[i];
                long nanosOfSecond = values.ints[i];
                if (timeZone != DateTimeZone.UTC) {
                    epochSeconds = timeZone.convertUTCToLocal(epochSeconds * 1000L) / 1000L;
                }
                if (precision < 9) {
                    nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
                }
                values.longs[i] = epochSeconds * 1000000L + nanosOfSecond / 1000L;
                values.ints[i] = (int)(nanosOfSecond * 1000L % 1000000L);
            }
        });
    }

    public static ValueDecoder<long[]> getInt96ToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp with timezone", (Object)field.getType());
        final ValueDecoder<Int96ColumnAdapter.Int96Buffer> delegate = ValueDecoders.getInt96Decoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                Int96ColumnAdapter.Int96Buffer int96Buffer = new Int96ColumnAdapter.Int96Buffer(length);
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = int96Buffer.longs[i];
                    int nanosOfSecond = int96Buffer.ints[i];
                    long utcMillis = epochSeconds * 1000L + (long)(nanosOfSecond / 1000000);
                    values[offset + i] = DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getInt64TimestampMillsToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = Timestamps.round((long)values[i], (int)(3 - precision)) * 1000L;
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000L;
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMillsToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampWithTimeZoneType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = DateTimeEncoding.packDateTimeWithZone((long)Timestamps.round((long)values[i], (int)(3 - precision)), (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)values[i], (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision == 6) {
            return valueDecoder;
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Timestamps.round((long)values[i], (int)(6 - precision));
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampWithTimeZoneType)field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)(Timestamps.round((long)values[i], (int)(6 - precision)) / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampNanosToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Timestamps.round((long)values[i], (int)(9 - precision)) / 1000L;
            }
        });
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMillisToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    values.longs[i] = values.longs[i] * 1000L;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMicrosToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMicrosToLongTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    long epochMicros = values.longs[i];
                    values.longs[i] = DateTimeEncoding.packDateTimeWithZone((long)Math.floorDiv(epochMicros, 1000), (TimeZoneKey)TimeZoneKey.UTC_KEY);
                    values.ints[i] = Math.floorMod(epochMicros, 1000) * 1000000;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampNanosToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    long epochNanos = values.longs[i];
                    values.longs[i] = Math.floorDiv(epochNanos, 1000);
                    values.ints[i] = Math.floorMod(epochNanos, 1000) * 1000;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getFloatToDoubleDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<int[]> delegate = ValueDecoders.getRealDecoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[offset + i] = Double.doubleToLongBits(Float.intBitsToFloat(buffer[i]));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    private static class InlineTransformDecoder<T>
    implements ValueDecoder<T> {
        private final ValueDecoder<T> valueDecoder;
        private final TypeTransform<T> typeTransform;

        private InlineTransformDecoder(ValueDecoder<T> valueDecoder, TypeTransform<T> typeTransform) {
            this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
            this.typeTransform = Objects.requireNonNull(typeTransform, "typeTransform is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.valueDecoder.init(input);
        }

        @Override
        public void read(T values, int offset, int length) {
            this.valueDecoder.read(values, offset, length);
            this.typeTransform.process(values, offset, length);
        }

        @Override
        public void skip(int n) {
            this.valueDecoder.skip(n);
        }
    }

    private static interface TypeTransform<T> {
        public void process(T var1, int var2, int var3);
    }
}

