/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.ValuesType;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ApacheParquetValueDecoders;
import io.trino.parquet.reader.decoders.PlainByteArrayDecoders;
import io.trino.parquet.reader.decoders.PlainValueDecoders;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.parquet.reader.flat.DictionaryDecoder;
import io.trino.parquet.reader.flat.Int96ColumnAdapter;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.schema.PrimitiveType;

public final class ValueDecoders {
    private ValueDecoders() {
    }

    public static ValueDecoder<long[]> getDoubleDecoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.LongPlainValueDecoder();
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<int[]> getRealDecoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.IntPlainValueDecoder();
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<long[]> getShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        Preconditions.checkArgument((boolean)(field.getType() instanceof DecimalType), (String)"Trino type %s is not a decimal", (Object)field.getType());
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> ValueDecoders.getLongDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> ValueDecoders.getIntToLongDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> ValueDecoders.getFixedWidthShortDecimalDecoder(encoding, field, (DecimalType)field.getType());
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> ValueDecoders.getFixedWidthLongDecimalDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.BINARY -> ValueDecoders.getBinaryLongDecimalDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getUuidDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.UuidPlainValueDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new ApacheParquetValueDecoders.UuidApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getLongDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED, ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.LongApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getIntToLongDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToLongPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED, ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.IntToLongApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<int[]> getIntDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED, ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.IntApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<byte[]> getByteDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToBytePlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED, ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.ByteApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<short[]> getShortDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToShortPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED, ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.ShortApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<byte[]> getBooleanDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.BooleanPlainValueDecoder();
            case ParquetEncoding.RLE, ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.BooleanApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt96Decoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new ApacheParquetValueDecoders.Int96ApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<long[]> getFixedWidthShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field, DecimalType decimalType) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.ShortDecimalFixedLengthByteArrayDecoder(decimalType, field.getDescriptor());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new ApacheParquetValueDecoders.ShortDecimalApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field), decimalType, field.getDescriptor());
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getFixedWidthLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongDecimalPlainValueDecoder(field.getDescriptor().getPrimitiveType().getTypeLength());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new ApacheParquetValueDecoders.LongDecimalApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ValueDecoder<long[]> getBinaryLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        switch (encoding) {
            case PLAIN: 
            case DELTA_BYTE_ARRAY: 
            case DELTA_LENGTH_BYTE_ARRAY: {
                return new ApacheParquetValueDecoders.LongDecimalApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            }
            default: {
                throw ValueDecoders.wrongEncoding(encoding, field);
            }
        }
    }

    public static ValueDecoder<BinaryBuffer> getBoundedVarcharBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        VarcharType varcharType;
        Type trinoType = field.getType();
        Preconditions.checkArgument((trinoType instanceof VarcharType && !(varcharType = (VarcharType)trinoType).isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BoundedVarcharPlainValueDecoder((VarcharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY, ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new ApacheParquetValueDecoders.BoundedVarcharApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field), (VarcharType)trinoType);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getCharBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        Type trinoType = field.getType();
        Preconditions.checkArgument((boolean)(trinoType instanceof CharType), (String)"Trino type %s is not a char", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.CharPlainValueDecoder((CharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY, ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new ApacheParquetValueDecoders.CharApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field), (CharType)trinoType);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BinaryPlainValueDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY, ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new ApacheParquetValueDecoders.BinaryApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static <T> DictionaryDecoder<T> getDictionaryDecoder(DictionaryPage dictionaryPage, ColumnAdapter<T> columnAdapter, ValueDecoder<T> plainValuesDecoder, boolean isNonNull) {
        int size = dictionaryPage.getDictionarySize();
        T dictionary = columnAdapter.createBuffer(size + (isNonNull ? 0 : 1));
        plainValuesDecoder.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        plainValuesDecoder.read(dictionary, 0, size);
        return new DictionaryDecoder<T>(dictionary, columnAdapter, size, isNonNull);
    }

    private static ValuesReader getApacheParquetReader(ParquetEncoding encoding, PrimitiveField field) {
        return encoding.getValuesReader(field.getDescriptor(), ValuesType.VALUES);
    }

    private static IllegalArgumentException wrongEncoding(ParquetEncoding encoding, PrimitiveField field) {
        return new IllegalArgumentException("Wrong encoding " + encoding + " for column type " + field.getDescriptor().getPrimitiveType().getPrimitiveTypeName());
    }
}

