/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.trino.parquet.reader.FilteredRowRanges;
import io.trino.parquet.reader.flat.FilteredRowRangesIterator;
import java.util.Optional;
import java.util.OptionalLong;

public interface RowRangesIterator {
    public static final RowRangesIterator ALL_ROW_RANGES_ITERATOR = new AllRowRangesIterator();

    public int advanceRange(int var1);

    public int seekForward(int var1);

    public long skipToRangeStart();

    public void resetForNewPage(OptionalLong var1);

    public boolean isPageFullyConsumed(int var1);

    public static RowRangesIterator createRowRangesIterator(Optional<FilteredRowRanges> filteredRowRanges) {
        if (filteredRowRanges.isEmpty()) {
            return ALL_ROW_RANGES_ITERATOR;
        }
        return new FilteredRowRangesIterator(filteredRowRanges.get());
    }

    public static class AllRowRangesIterator
    implements RowRangesIterator {
        @Override
        public int advanceRange(int chunkSize) {
            return chunkSize;
        }

        @Override
        public int seekForward(int chunkSize) {
            return chunkSize;
        }

        @Override
        public long skipToRangeStart() {
            return 0L;
        }

        @Override
        public void resetForNewPage(OptionalLong firstRowIndex) {
        }

        @Override
        public boolean isPageFullyConsumed(int pageValueCount) {
            return true;
        }
    }
}

