/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.airlift.slice.SizeOf;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.ShortArrayBlock;
import java.util.Optional;

public class ShortColumnAdapter
implements ColumnAdapter<short[]> {
    public static final ShortColumnAdapter SHORT_ADAPTER = new ShortColumnAdapter();

    @Override
    public short[] createBuffer(int size) {
        return new short[size];
    }

    @Override
    public Block createNonNullBlock(short[] values) {
        return new ShortArrayBlock(values.length, Optional.empty(), values);
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, short[] values) {
        return new ShortArrayBlock(values.length, Optional.of(nulls), values);
    }

    @Override
    public void copyValue(short[] source, int sourceIndex, short[] destination, int destinationIndex) {
        destination[destinationIndex] = source[sourceIndex];
    }

    @Override
    public void decodeDictionaryIds(short[] values, int offset, int length, int[] ids, short[] dictionary) {
        for (int i = 0; i < length; ++i) {
            values[offset + i] = dictionary[ids[i]];
        }
    }

    @Override
    public long getSizeInBytes(short[] values) {
        return SizeOf.sizeOf((short[])values);
    }
}

