/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.predicate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.airlift.slice.SliceInput;
import io.trino.parquet.BloomFilterStore;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetCompressionUtils;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.predicate.DictionaryDescriptor;
import io.trino.parquet.predicate.TupleDomainParquetPredicate;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.DictionaryPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.MessageType;
import org.joda.time.DateTimeZone;

public final class PredicateUtils {
    private static final int MAX_DICTIONARY_SIZE = 8096;

    private PredicateUtils() {
    }

    public static boolean isStatisticsOverflow(Type type, long min, long max) {
        if (type == TinyintType.TINYINT) {
            return min < -128L || max > 127L;
        }
        if (type == SmallintType.SMALLINT) {
            return min < -32768L || max > 32767L;
        }
        if (type == IntegerType.INTEGER || type == DateType.DATE) {
            return min < Integer.MIN_VALUE || max > Integer.MAX_VALUE;
        }
        if (type == BigintType.BIGINT) {
            return false;
        }
        if (type instanceof DecimalType) {
            DecimalType decimalType = (DecimalType)type;
            if (!decimalType.isShort()) {
                return false;
            }
            return BigDecimal.valueOf(min, decimalType.getScale()).compareTo(PredicateUtils.minimalValue(decimalType)) < 0 || BigDecimal.valueOf(max, decimalType.getScale()).compareTo(PredicateUtils.maximalValue(decimalType)) > 0;
        }
        throw new IllegalArgumentException("Unsupported type: " + type);
    }

    private static BigDecimal minimalValue(DecimalType decimalType) {
        return new BigDecimal(String.format("-%s.%s", "9".repeat(decimalType.getPrecision() - decimalType.getScale()), "9".repeat(decimalType.getScale())));
    }

    private static BigDecimal maximalValue(DecimalType decimalType) {
        return new BigDecimal(String.format("+%s.%s", "9".repeat(decimalType.getPrecision() - decimalType.getScale()), "9".repeat(decimalType.getScale())));
    }

    public static TupleDomainParquetPredicate buildPredicate(MessageType requestedSchema, TupleDomain<ColumnDescriptor> parquetTupleDomain, Map<List<String>, ColumnDescriptor> descriptorsByPath, DateTimeZone timeZone) {
        ImmutableList.Builder columnReferences = ImmutableList.builder();
        for (String[] paths : requestedSchema.getPaths()) {
            ColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(paths));
            if (descriptor == null) continue;
            columnReferences.add((Object)descriptor);
        }
        return new TupleDomainParquetPredicate(parquetTupleDomain, (List<ColumnDescriptor>)columnReferences.build(), timeZone);
    }

    public static boolean predicateMatches(TupleDomainParquetPredicate parquetPredicate, BlockMetaData block, ParquetDataSource dataSource, Map<List<String>, ColumnDescriptor> descriptorsByPath, TupleDomain<ColumnDescriptor> parquetTupleDomain, Optional<ColumnIndexStore> columnIndexStore, Optional<BloomFilterStore> bloomFilterStore, DateTimeZone timeZone, int domainCompactionThreshold) throws IOException {
        if (block.getRowCount() == 0L) {
            return false;
        }
        Map<ColumnDescriptor, Statistics<?>> columnStatistics = PredicateUtils.getStatistics(block, descriptorsByPath);
        Map<ColumnDescriptor, Long> columnValueCounts = PredicateUtils.getColumnValueCounts(block, descriptorsByPath);
        Optional<List<ColumnDescriptor>> candidateColumns = parquetPredicate.getIndexLookupCandidates(columnValueCounts, columnStatistics, dataSource.getId());
        if (candidateColumns.isEmpty()) {
            return false;
        }
        if (candidateColumns.get().isEmpty()) {
            return true;
        }
        TupleDomainParquetPredicate indexPredicate = new TupleDomainParquetPredicate(parquetTupleDomain, candidateColumns.get(), timeZone);
        if (columnIndexStore.isPresent() && !indexPredicate.matches(columnValueCounts, columnIndexStore.get(), dataSource.getId())) {
            return false;
        }
        if (bloomFilterStore.isPresent() && !indexPredicate.matches(bloomFilterStore.get(), domainCompactionThreshold)) {
            return false;
        }
        return PredicateUtils.dictionaryPredicatesMatch(indexPredicate, block, dataSource, descriptorsByPath, (Set<ColumnDescriptor>)ImmutableSet.copyOf((Collection)candidateColumns.get()), columnIndexStore);
    }

    private static Map<ColumnDescriptor, Statistics<?>> getStatistics(BlockMetaData blockMetadata, Map<List<String>, ColumnDescriptor> descriptorsByPath) {
        ImmutableMap.Builder statistics = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            ColumnDescriptor descriptor;
            Statistics columnStatistics = columnMetaData.getStatistics();
            if (columnStatistics == null || (descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()))) == null) continue;
            statistics.put((Object)descriptor, (Object)columnStatistics);
        }
        return statistics.buildOrThrow();
    }

    private static Map<ColumnDescriptor, Long> getColumnValueCounts(BlockMetaData blockMetadata, Map<List<String>, ColumnDescriptor> descriptorsByPath) {
        ImmutableMap.Builder columnValueCounts = ImmutableMap.builder();
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            ColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()));
            if (descriptor == null) continue;
            columnValueCounts.put((Object)descriptor, (Object)columnMetaData.getValueCount());
        }
        return columnValueCounts.buildOrThrow();
    }

    private static boolean dictionaryPredicatesMatch(TupleDomainParquetPredicate parquetPredicate, BlockMetaData blockMetadata, ParquetDataSource dataSource, Map<List<String>, ColumnDescriptor> descriptorsByPath, Set<ColumnDescriptor> candidateColumns, Optional<ColumnIndexStore> columnIndexStore) throws IOException {
        for (ColumnChunkMetaData columnMetaData : blockMetadata.getColumns()) {
            Statistics columnStatistics;
            boolean nullAllowed;
            ColumnDescriptor descriptor = descriptorsByPath.get(Arrays.asList(columnMetaData.getPath().toArray()));
            if (descriptor == null || !candidateColumns.contains(descriptor) || !ParquetReaderUtils.isOnlyDictionaryEncodingPages(columnMetaData) || parquetPredicate.matches(new DictionaryDescriptor(descriptor, nullAllowed = (columnStatistics = columnMetaData.getStatistics()) == null || columnStatistics.getNumNulls() != 0L, PredicateUtils.readDictionaryPage(dataSource, columnMetaData, columnIndexStore)))) continue;
            return false;
        }
        return true;
    }

    private static Optional<DictionaryPage> readDictionaryPage(ParquetDataSource dataSource, ColumnChunkMetaData columnMetaData, Optional<ColumnIndexStore> columnIndexStore) throws IOException {
        int dictionaryPageSize = columnMetaData.getDictionaryPageOffset() == 0L || columnMetaData.getFirstDataPageOffset() <= columnMetaData.getDictionaryPageOffset() ? columnIndexStore.flatMap(index -> PredicateUtils.getDictionaryPageSize(index, columnMetaData)).orElseGet(() -> Math.toIntExact(columnMetaData.getTotalSize())) : Math.toIntExact(columnMetaData.getFirstDataPageOffset() - columnMetaData.getDictionaryPageOffset());
        Slice buffer = dataSource.readFully(columnMetaData.getStartingPos(), dictionaryPageSize);
        return PredicateUtils.readPageHeaderWithData((SliceInput)buffer.getInput()).map(data -> PredicateUtils.decodeDictionaryPage(data, columnMetaData));
    }

    private static Optional<Integer> getDictionaryPageSize(ColumnIndexStore columnIndexStore, ColumnChunkMetaData columnMetaData) {
        long firstPageOffset;
        OffsetIndex offsetIndex = columnIndexStore.getOffsetIndex(columnMetaData.getPath());
        if (offsetIndex == null) {
            return Optional.empty();
        }
        long rowGroupOffset = columnMetaData.getStartingPos();
        if (rowGroupOffset < (firstPageOffset = offsetIndex.getOffset(0))) {
            return Optional.of(Math.toIntExact(firstPageOffset - rowGroupOffset));
        }
        return Optional.empty();
    }

    private static Optional<PageHeaderWithData> readPageHeaderWithData(SliceInput inputStream) {
        PageHeader pageHeader;
        try {
            pageHeader = Util.readPageHeader((InputStream)inputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        if (pageHeader.type != PageType.DICTIONARY_PAGE) {
            return Optional.empty();
        }
        DictionaryPageHeader dictionaryHeader = pageHeader.getDictionary_page_header();
        if (dictionaryHeader.getNum_values() > 8096) {
            return Optional.empty();
        }
        return Optional.of(new PageHeaderWithData(pageHeader, inputStream.readSlice(pageHeader.getCompressed_page_size())));
    }

    private static DictionaryPage decodeDictionaryPage(PageHeaderWithData pageHeaderWithData, ColumnChunkMetaData chunkMetaData) {
        PageHeader pageHeader = pageHeaderWithData.pageHeader();
        DictionaryPageHeader dicHeader = pageHeader.getDictionary_page_header();
        ParquetEncoding encoding = ParquetTypeUtils.getParquetEncoding(Encoding.valueOf((String)dicHeader.getEncoding().name()));
        int dictionarySize = dicHeader.getNum_values();
        Slice compressedData = pageHeaderWithData.compressedData();
        try {
            return new DictionaryPage(ParquetCompressionUtils.decompress(chunkMetaData.getCodec().getParquetCompressionCodec(), compressedData, pageHeader.getUncompressed_page_size()), dictionarySize, encoding);
        }
        catch (IOException e) {
            throw new ParquetDecodingException("Could not decode the dictionary for " + chunkMetaData.getPath(), (Throwable)e);
        }
    }

    private record PageHeaderWithData(PageHeader pageHeader, Slice compressedData) {
        private PageHeaderWithData(PageHeader pageHeader, Slice compressedData) {
            this.pageHeader = Objects.requireNonNull(pageHeader, "pageHeader is null");
            this.compressedData = Objects.requireNonNull(compressedData, "compressedData is null");
        }
    }
}

