/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.api.Binary;

public class LongDecimalColumnReader
extends PrimitiveColumnReader {
    private final DecimalType parquetDecimalType;

    LongDecimalColumnReader(PrimitiveField field, DecimalType parquetDecimalType) {
        super(field);
        this.parquetDecimalType = Objects.requireNonNull(parquetDecimalType, "parquetDecimalType is null");
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        if (!(trinoType instanceof DecimalType)) {
            throw new ParquetDecodingException(String.format("Unsupported Trino column type (%s) for Parquet column (%s)", trinoType, this.field.getDescriptor()));
        }
        DecimalType trinoDecimalType = (DecimalType)trinoType;
        Binary binary = this.valuesReader.readBytes();
        Int128 value = Int128.fromBigEndian((byte[])binary.getBytes());
        if (trinoDecimalType.isShort()) {
            trinoType.writeLong(blockBuilder, DecimalConversions.longToShortCast((Int128)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
        } else {
            trinoType.writeObject(blockBuilder, (Object)DecimalConversions.longToLongCast((Int128)value, (long)this.parquetDecimalType.getPrecision(), (long)this.parquetDecimalType.getScale(), (long)trinoDecimalType.getPrecision(), (long)trinoDecimalType.getScale()));
        }
    }
}

