/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.spi.block.Block;
import java.util.List;
import java.util.Objects;

public class ColumnChunk {
    private final Block block;
    private final List<DefLevelWriterProvider> defLevelWriterProviders;
    private final List<RepLevelIterable> repLevelIterables;

    ColumnChunk(Block block) {
        this(block, (List<DefLevelWriterProvider>)ImmutableList.of(), (List<RepLevelIterable>)ImmutableList.of());
    }

    ColumnChunk(Block block, List<DefLevelWriterProvider> defLevelWriterProviders, List<RepLevelIterable> repLevelIterables) {
        this.block = Objects.requireNonNull(block, "block is null");
        this.defLevelWriterProviders = ImmutableList.copyOf(defLevelWriterProviders);
        this.repLevelIterables = ImmutableList.copyOf(repLevelIterables);
    }

    List<DefLevelWriterProvider> getDefLevelWriterProviders() {
        return this.defLevelWriterProviders;
    }

    List<RepLevelIterable> getRepLevelIterables() {
        return this.repLevelIterables;
    }

    public Block getBlock() {
        return this.block;
    }
}

