/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.spi.block.Block;
import java.util.Objects;
import java.util.OptionalLong;

public class ColumnChunk {
    private final Block block;
    private final int[] definitionLevels;
    private final int[] repetitionLevels;
    private OptionalLong maxBlockSize;

    public ColumnChunk(Block block, int[] definitionLevels, int[] repetitionLevels) {
        this(block, definitionLevels, repetitionLevels, OptionalLong.empty());
    }

    public ColumnChunk(Block block, int[] definitionLevels, int[] repetitionLevels, OptionalLong maxBlockSize) {
        this.block = Objects.requireNonNull(block, "block is null");
        this.definitionLevels = Objects.requireNonNull(definitionLevels, "definitionLevels is null");
        this.repetitionLevels = Objects.requireNonNull(repetitionLevels, "repetitionLevels is null");
        this.maxBlockSize = maxBlockSize;
    }

    public Block getBlock() {
        return this.block;
    }

    public int[] getDefinitionLevels() {
        return this.definitionLevels;
    }

    public int[] getRepetitionLevels() {
        return this.repetitionLevels;
    }

    public long getMaxBlockSize() {
        if (this.maxBlockSize.isEmpty()) {
            this.maxBlockSize = OptionalLong.of(this.block.getSizeInBytes());
        }
        return this.maxBlockSize.getAsLong();
    }
}

