/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.DeltaByteArrayDecoders;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.decoders.ValueDecoders;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.Int96ColumnAdapter;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.joda.time.DateTimeZone;

public class TransformingValueDecoders {
    private TransformingValueDecoders() {
    }

    public static ValueDecoder<long[]> getTimeMicrosDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000000L;
            }
        });
    }

    public static ValueDecoder<long[]> getInt96ToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field, final DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        final int precision = ((TimestampType)field.getType()).getPrecision();
        final ValueDecoder<Int96ColumnAdapter.Int96Buffer> delegate = ValueDecoders.getInt96Decoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                Int96ColumnAdapter.Int96Buffer int96Buffer = new Int96ColumnAdapter.Int96Buffer(length);
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = int96Buffer.longs[i];
                    long epochMicros = timeZone == DateTimeZone.UTC ? epochSeconds * 1000000L : timeZone.convertUTCToLocal(epochSeconds * 1000L) * 1000L;
                    int nanosOfSecond = (int)Timestamps.round((long)int96Buffer.ints[i], (int)(9 - precision));
                    values[offset + i] = epochMicros + (long)(nanosOfSecond / 1000);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt96ToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && !(timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a long timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        return new InlineTransformDecoder<Int96ColumnAdapter.Int96Buffer>(ValueDecoders.getInt96Decoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochSeconds = values.longs[i];
                long nanosOfSecond = values.ints[i];
                if (timeZone != DateTimeZone.UTC) {
                    epochSeconds = timeZone.convertUTCToLocal(epochSeconds * 1000L) / 1000L;
                }
                if (precision < 9) {
                    nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
                }
                values.longs[i] = epochSeconds * 1000000L + nanosOfSecond / 1000L;
                values.ints[i] = (int)(nanosOfSecond * 1000L % 1000000L);
            }
        });
    }

    public static ValueDecoder<long[]> getInt96ToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp with timezone", (Object)field.getType());
        final ValueDecoder<Int96ColumnAdapter.Int96Buffer> delegate = ValueDecoders.getInt96Decoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                Int96ColumnAdapter.Int96Buffer int96Buffer = new Int96ColumnAdapter.Int96Buffer(length);
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = int96Buffer.longs[i];
                    int nanosOfSecond = int96Buffer.ints[i];
                    long utcMillis = epochSeconds * 1000L + (long)(nanosOfSecond / 1000000);
                    values[offset + i] = DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getInt64TimestampMillsToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = Timestamps.round((long)values[i], (int)(3 - precision)) * 1000L;
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000L;
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMillsToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampWithTimeZoneType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = DateTimeEncoding.packDateTimeWithZone((long)Timestamps.round((long)values[i], (int)(3 - precision)), (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)values[i], (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = ValueDecoders.getLongDecoder(encoding, field);
        if (precision == 6) {
            return valueDecoder;
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Timestamps.round((long)values[i], (int)(6 - precision));
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampWithTimeZoneType)field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)(Timestamps.round((long)values[i], (int)(6 - precision)) / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public static ValueDecoder<long[]> getInt64TimestampNanosToShortTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        TimestampType timestampType;
        Type type = field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)field.getType());
        int precision = ((TimestampType)field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecoder(encoding, field), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = Timestamps.round((long)values[i], (int)(9 - precision)) / 1000L;
            }
        });
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMillisToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    values.longs[i] = values.longs[i] * 1000L;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMicrosToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampMicrosToLongTimestampWithTimeZoneDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    long epochMicros = values.longs[i];
                    values.longs[i] = DateTimeEncoding.packDateTimeWithZone((long)Math.floorDiv(epochMicros, 1000), (TimeZoneKey)TimeZoneKey.UTC_KEY);
                    values.ints[i] = Math.floorMod(epochMicros, 1000) * 1000000;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<Int96ColumnAdapter.Int96Buffer> getInt64TimestampNanosToLongTimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecoder(encoding, field);
        return new ValueDecoder<Int96ColumnAdapter.Int96Buffer>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(Int96ColumnAdapter.Int96Buffer values, int offset, int length) {
                delegate.read(values.longs, offset, length);
                for (int i = offset; i < offset + length; ++i) {
                    long epochNanos = values.longs[i];
                    values.longs[i] = Math.floorDiv(epochNanos, 1000);
                    values.ints[i] = Math.floorMod(epochNanos, 1000) * 1000;
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getFloatToDoubleDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<int[]> delegate = ValueDecoders.getRealDecoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[offset + i] = Double.doubleToLongBits(Float.intBitsToFloat(buffer[i]));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getBinaryLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new BinaryToLongDecimalTransformDecoder(ValueDecoders.getBinaryDecoder(encoding, field));
    }

    public static ValueDecoder<long[]> getDeltaFixedWidthLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        ColumnDescriptor descriptor = field.getDescriptor();
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getPrecision() > 18 ? 1 : 0) != 0, (String)"Column %s is not a long decimal", (Object)descriptor);
        return new BinaryToLongDecimalTransformDecoder(new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder());
    }

    public static ValueDecoder<long[]> getBinaryShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<BinaryBuffer> delegate = ValueDecoders.getBinaryDecoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                delegate.read(buffer, 0, length);
                int[] offsets = buffer.getOffsets();
                byte[] inputBytes = buffer.asSlice().byteArray();
                for (int i = 0; i < length; ++i) {
                    int positionOffset = offsets[i];
                    int positionLength = offsets[i + 1] - positionOffset;
                    if (positionLength > 8) {
                        throw new ParquetDecodingException("Unable to read BINARY type decimal of size " + positionLength + " as a short decimal");
                    }
                    values[offset + i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, positionOffset, positionLength);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getDeltaFixedWidthShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        final ColumnDescriptor descriptor = field.getDescriptor();
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getPrecision() <= 18 ? 1 : 0) != 0, (String)"Column %s is not a short decimal", (Object)descriptor);
        final int typeLength = descriptor.getPrimitiveType().getTypeLength();
        Preconditions.checkArgument((typeLength > 0 && typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)descriptor);
        return new ValueDecoder<long[]>(){
            private final ValueDecoder<BinaryBuffer> delegate = new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();

            @Override
            public void init(SimpleSliceInputStream input) {
                this.delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                this.delegate.read(buffer, 0, length);
                int bytesOffset = 0;
                int bytesLength = typeLength;
                if (typeLength > 8) {
                    bytesOffset = typeLength - 8;
                    bytesLength = 8;
                }
                byte[] inputBytes = buffer.asSlice().byteArray();
                int[] offsets = buffer.getOffsets();
                for (int i = 0; i < length; ++i) {
                    int inputOffset = offsets[i];
                    ParquetTypeUtils.checkBytesFitInShortDecimal(inputBytes, inputOffset, bytesOffset, descriptor);
                    values[offset + i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, inputOffset + bytesOffset, bytesLength);
                }
            }

            @Override
            public void skip(int n) {
                this.delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getRescaledLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final DecimalType decimalType = (DecimalType)field.getType();
        final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (decimalAnnotation.getPrecision() <= 18) {
            final ValueDecoder<long[]> delegate = ValueDecoders.getShortDecimalDecoder(encoding, field);
            return new ValueDecoder<long[]>(){

                @Override
                public void init(SimpleSliceInputStream input) {
                    delegate.init(input);
                }

                @Override
                public void read(long[] values, int offset, int length) {
                    long[] buffer = new long[length];
                    delegate.read(buffer, 0, length);
                    for (int i = 0; i < length; ++i) {
                        Int128 rescaled = DecimalConversions.shortToLongCast((long)buffer[i], (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                        values[2 * (offset + i)] = rescaled.getHigh();
                        values[2 * (offset + i) + 1] = rescaled.getLow();
                    }
                }

                @Override
                public void skip(int n) {
                    delegate.skip(n);
                }
            };
        }
        return new InlineTransformDecoder<long[]>(ValueDecoders.getLongDecimalDecoder(encoding, field), (values, offset, length) -> {
            int endOffset = (offset + length) * 2;
            for (int currentOffset = offset * 2; currentOffset < endOffset; currentOffset += 2) {
                Int128 rescaled = DecimalConversions.longToLongCast((Int128)Int128.valueOf((long)values[currentOffset], (long)values[currentOffset + 1]), (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                values[currentOffset] = rescaled.getHigh();
                values[currentOffset + 1] = rescaled.getLow();
            }
        });
    }

    public static ValueDecoder<long[]> getRescaledShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final DecimalType decimalType = (DecimalType)field.getType();
        final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (decimalAnnotation.getPrecision() <= 18) {
            long rescale = Decimals.longTenToNth((int)Math.abs(decimalType.getScale() - decimalAnnotation.getScale()));
            return new InlineTransformDecoder<long[]>(ValueDecoders.getShortDecimalDecoder(encoding, field), (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = DecimalConversions.shortToShortCast((long)values[i], (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale(), (long)rescale, (long)(rescale / 2L));
                }
            });
        }
        final ValueDecoder<long[]> delegate = ValueDecoders.getLongDecimalDecoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                long[] buffer = new long[2 * length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[offset + i] = DecimalConversions.longToShortCast((Int128)Int128.valueOf((long)buffer[2 * i], (long)buffer[2 * i + 1]), (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<long[]> getInt32ToLongDecoder(ParquetEncoding encoding, PrimitiveField field) {
        final ValueDecoder<int[]> delegate = ValueDecoders.getInt32Decoder(encoding, field);
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[i + offset] = buffer[i];
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public static ValueDecoder<int[]> getInt64ToIntDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToIntTransformDecoder(ValueDecoders.getLongDecoder(encoding, field));
    }

    public static ValueDecoder<int[]> getShortDecimalToIntDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToIntTransformDecoder(ValueDecoders.getShortDecimalDecoder(encoding, field));
    }

    public static ValueDecoder<short[]> getInt64ToShortDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToShortTransformDecoder(ValueDecoders.getLongDecoder(encoding, field));
    }

    public static ValueDecoder<short[]> getShortDecimalToShortDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToShortTransformDecoder(ValueDecoders.getShortDecimalDecoder(encoding, field));
    }

    public static ValueDecoder<byte[]> getInt64ToByteDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToByteTransformDecoder(ValueDecoders.getLongDecoder(encoding, field));
    }

    public static ValueDecoder<byte[]> getShortDecimalToByteDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return new LongToByteTransformDecoder(ValueDecoders.getShortDecimalDecoder(encoding, field));
    }

    public static ValueDecoder<long[]> getDeltaUuidDecoder(ParquetEncoding encoding) {
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        final DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder delegate = new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
        return new ValueDecoder<long[]>(){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                delegate.read(buffer, 0, length);
                SimpleSliceInputStream binaryInput = new SimpleSliceInputStream(buffer.asSlice());
                int endOffset = (offset + length) * 2;
                for (int outputOffset = offset * 2; outputOffset < endOffset; outputOffset += 2) {
                    values[outputOffset] = binaryInput.readLong();
                    values[outputOffset + 1] = binaryInput.readLong();
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    private static class InlineTransformDecoder<T>
    implements ValueDecoder<T> {
        private final ValueDecoder<T> valueDecoder;
        private final TypeTransform<T> typeTransform;

        private InlineTransformDecoder(ValueDecoder<T> valueDecoder, TypeTransform<T> typeTransform) {
            this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
            this.typeTransform = Objects.requireNonNull(typeTransform, "typeTransform is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.valueDecoder.init(input);
        }

        @Override
        public void read(T values, int offset, int length) {
            this.valueDecoder.read(values, offset, length);
            this.typeTransform.process(values, offset, length);
        }

        @Override
        public void skip(int n) {
            this.valueDecoder.skip(n);
        }
    }

    private static interface TypeTransform<T> {
        public void process(T var1, int var2, int var3);
    }

    private static class BinaryToLongDecimalTransformDecoder
    implements ValueDecoder<long[]> {
        private final ValueDecoder<BinaryBuffer> delegate;

        private BinaryToLongDecimalTransformDecoder(ValueDecoder<BinaryBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            BinaryBuffer buffer = new BinaryBuffer(length);
            this.delegate.read(buffer, 0, length);
            int[] offsets = buffer.getOffsets();
            Slice binaryInput = buffer.asSlice();
            for (int i = 0; i < length; ++i) {
                int positionOffset = offsets[i];
                int positionLength = offsets[i + 1] - positionOffset;
                Int128 value = Int128.fromBigEndian((byte[])binaryInput.getBytes(positionOffset, positionLength));
                values[2 * (offset + i)] = value.getHigh();
                values[2 * (offset + i) + 1] = value.getLow();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToIntTransformDecoder
    implements ValueDecoder<int[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToIntTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(int[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = Math.toIntExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToShortTransformDecoder
    implements ValueDecoder<short[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToShortTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(short[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = ParquetReaderUtils.toShortExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToByteTransformDecoder
    implements ValueDecoder<byte[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToByteTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = ParquetReaderUtils.toByteExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }
}

