/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import com.google.common.primitives.Longs;
import io.airlift.slice.SizeOf;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import io.trino.spi.block.Int96ArrayBlock;
import java.util.List;
import java.util.Optional;

public class Int96ColumnAdapter
implements ColumnAdapter<Int96Buffer> {
    public static final Int96ColumnAdapter INT96_ADAPTER = new Int96ColumnAdapter();

    @Override
    public Int96Buffer createBuffer(int size) {
        return new Int96Buffer(size);
    }

    @Override
    public void copyValue(Int96Buffer source, int sourceIndex, Int96Buffer destination, int destinationIndex) {
        destination.longs[destinationIndex] = source.longs[sourceIndex];
        destination.ints[destinationIndex] = source.ints[sourceIndex];
    }

    @Override
    public Block createNullableBlock(boolean[] nulls, Int96Buffer values) {
        return new Int96ArrayBlock(values.size(), Optional.of(nulls), values.longs, values.ints);
    }

    @Override
    public Block createNonNullBlock(Int96Buffer values) {
        return new Int96ArrayBlock(values.size(), Optional.empty(), values.longs, values.ints);
    }

    @Override
    public void decodeDictionaryIds(Int96Buffer values, int offset, int length, int[] ids, Int96Buffer dictionary) {
        for (int i = 0; i < length; ++i) {
            values.longs[offset + i] = dictionary.longs[ids[i]];
            values.ints[offset + i] = dictionary.ints[ids[i]];
        }
    }

    @Override
    public long getSizeInBytes(Int96Buffer values) {
        return SizeOf.sizeOf((long[])values.longs) + SizeOf.sizeOf((int[])values.ints);
    }

    @Override
    public Int96Buffer merge(List<Int96Buffer> buffers) {
        return new Int96Buffer(Longs.concat((long[][])((long[][])buffers.stream().map(buffer -> buffer.longs).toArray(x$0 -> new long[x$0][]))), Ints.concat((int[][])((int[][])buffers.stream().map(buffer -> buffer.ints).toArray(x$0 -> new int[x$0][]))));
    }

    public static class Int96Buffer {
        public final long[] longs;
        public final int[] ints;

        public Int96Buffer(int size) {
            this(new long[size], new int[size]);
        }

        private Int96Buffer(long[] longs, int[] ints) {
            Preconditions.checkArgument((longs.length == ints.length ? 1 : 0) != 0, (String)"Length of longs %s does not match length of ints %s", (int)longs.length, (int)ints.length);
            this.longs = longs;
            this.ints = ints;
        }

        public int size() {
            return this.longs.length;
        }
    }
}

