/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.parquet.writer.ArrayColumnWriter;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.MapColumnWriter;
import io.trino.parquet.writer.ParquetTypeVisitor;
import io.trino.parquet.writer.PrimitiveColumnWriter;
import io.trino.parquet.writer.StructColumnWriter;
import io.trino.parquet.writer.valuewriter.BigintValueWriter;
import io.trino.parquet.writer.valuewriter.BinaryValueWriter;
import io.trino.parquet.writer.valuewriter.BooleanValueWriter;
import io.trino.parquet.writer.valuewriter.DateValueWriter;
import io.trino.parquet.writer.valuewriter.DoubleValueWriter;
import io.trino.parquet.writer.valuewriter.FixedLenByteArrayLongDecimalValueWriter;
import io.trino.parquet.writer.valuewriter.FixedLenByteArrayShortDecimalValueWriter;
import io.trino.parquet.writer.valuewriter.Int32ShortDecimalValueWriter;
import io.trino.parquet.writer.valuewriter.Int64ShortDecimalValueWriter;
import io.trino.parquet.writer.valuewriter.Int96TimestampValueWriter;
import io.trino.parquet.writer.valuewriter.IntegerValueWriter;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.parquet.writer.valuewriter.RealValueWriter;
import io.trino.parquet.writer.valuewriter.TimeMicrosValueWriter;
import io.trino.parquet.writer.valuewriter.TimestampMillisValueWriter;
import io.trino.parquet.writer.valuewriter.TimestampNanosValueWriter;
import io.trino.parquet.writer.valuewriter.TimestampTzMicrosValueWriter;
import io.trino.parquet.writer.valuewriter.TimestampTzMillisValueWriter;
import io.trino.parquet.writer.valuewriter.UuidValueWriter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.joda.time.DateTimeZone;

final class ParquetWriters {
    private ParquetWriters() {
    }

    static List<ColumnWriter> getColumnWriters(MessageType messageType, Map<List<String>, io.trino.spi.type.Type> trinoTypes, ParquetProperties parquetProperties, CompressionCodec compressionCodec, Optional<DateTimeZone> parquetTimeZone) {
        WriteBuilder writeBuilder = new WriteBuilder(messageType, trinoTypes, parquetProperties, compressionCodec, parquetTimeZone);
        ParquetTypeVisitor.visit((Type)messageType, writeBuilder);
        return writeBuilder.build();
    }

    private static PrimitiveValueWriter getValueWriter(ValuesWriter valuesWriter, io.trino.spi.type.Type type, PrimitiveType parquetType, Optional<DateTimeZone> parquetTimeZone) {
        if (BooleanType.BOOLEAN.equals((Object)type)) {
            return new BooleanValueWriter(valuesWriter, parquetType);
        }
        if (IntegerType.INTEGER.equals((Object)type) || SmallintType.SMALLINT.equals((Object)type) || TinyintType.TINYINT.equals((Object)type)) {
            return new IntegerValueWriter(valuesWriter, type, parquetType);
        }
        if (BigintType.BIGINT.equals((Object)type)) {
            return new BigintValueWriter(valuesWriter, type, parquetType);
        }
        if (type instanceof DecimalType) {
            if (parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT32) {
                return new Int32ShortDecimalValueWriter(valuesWriter, type, parquetType);
            }
            if (parquetType.getPrimitiveTypeName() == PrimitiveType.PrimitiveTypeName.INT64) {
                return new Int64ShortDecimalValueWriter(valuesWriter, type, parquetType);
            }
            if (((DecimalType)type).isShort()) {
                return new FixedLenByteArrayShortDecimalValueWriter(valuesWriter, type, parquetType);
            }
            return new FixedLenByteArrayLongDecimalValueWriter(valuesWriter, type, parquetType);
        }
        if (DateType.DATE.equals((Object)type)) {
            return new DateValueWriter(valuesWriter, parquetType);
        }
        if (TimeType.TIME_MICROS.equals((Object)type)) {
            ParquetWriters.verifyParquetType(type, parquetType, LogicalTypeAnnotation.TimeLogicalTypeAnnotation.class, ParquetWriters.isTime(LogicalTypeAnnotation.TimeUnit.MICROS));
            return new TimeMicrosValueWriter(valuesWriter, parquetType);
        }
        if (type instanceof TimestampType) {
            if (parquetType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT96)) {
                Preconditions.checkArgument((boolean)parquetTimeZone.isPresent(), (Object)"parquetTimeZone must be provided for INT96 timestamps");
                return new Int96TimestampValueWriter(valuesWriter, type, parquetType, parquetTimeZone.get());
            }
            if (TimestampType.TIMESTAMP_MILLIS.equals((Object)type)) {
                ParquetWriters.verifyParquetType(type, parquetType, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.class, ParquetWriters.isTimestamp(LogicalTypeAnnotation.TimeUnit.MILLIS));
                return new TimestampMillisValueWriter(valuesWriter, type, parquetType);
            }
            if (TimestampType.TIMESTAMP_MICROS.equals((Object)type)) {
                ParquetWriters.verifyParquetType(type, parquetType, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.class, ParquetWriters.isTimestamp(LogicalTypeAnnotation.TimeUnit.MICROS));
                return new BigintValueWriter(valuesWriter, type, parquetType);
            }
            if (TimestampType.TIMESTAMP_NANOS.equals((Object)type)) {
                ParquetWriters.verifyParquetType(type, parquetType, LogicalTypeAnnotation.TimestampLogicalTypeAnnotation.class, ParquetWriters.isTimestamp(LogicalTypeAnnotation.TimeUnit.NANOS));
                return new TimestampNanosValueWriter(valuesWriter, type, parquetType);
            }
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS.equals((Object)type)) {
            return new TimestampTzMillisValueWriter(valuesWriter, parquetType);
        }
        if (TimestampWithTimeZoneType.TIMESTAMP_TZ_MICROS.equals((Object)type)) {
            return new TimestampTzMicrosValueWriter(valuesWriter, parquetType);
        }
        if (DoubleType.DOUBLE.equals((Object)type)) {
            return new DoubleValueWriter(valuesWriter, parquetType);
        }
        if (RealType.REAL.equals((Object)type)) {
            return new RealValueWriter(valuesWriter, parquetType);
        }
        if (type instanceof VarcharType || type instanceof CharType || type instanceof VarbinaryType) {
            return new BinaryValueWriter(valuesWriter, type, parquetType);
        }
        if (type instanceof UuidType) {
            return new UuidValueWriter(valuesWriter, parquetType);
        }
        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported type for Parquet writer: %s", type));
    }

    private static <T> void verifyParquetType(io.trino.spi.type.Type type, PrimitiveType parquetType, Class<T> annotationType, Predicate<T> predicate) {
        Preconditions.checkArgument((annotationType.isInstance(parquetType.getLogicalTypeAnnotation()) && predicate.test(annotationType.cast(parquetType.getLogicalTypeAnnotation())) ? 1 : 0) != 0, (String)"Wrong Parquet type '%s' for Trino type '%s'", (Object)parquetType, (Object)type);
    }

    private static Predicate<LogicalTypeAnnotation.TimeLogicalTypeAnnotation> isTime(LogicalTypeAnnotation.TimeUnit precision) {
        Objects.requireNonNull(precision, "precision is null");
        return annotation -> annotation.getUnit() == precision && !annotation.isAdjustedToUTC();
    }

    private static Predicate<LogicalTypeAnnotation.TimestampLogicalTypeAnnotation> isTimestamp(LogicalTypeAnnotation.TimeUnit precision) {
        Objects.requireNonNull(precision, "precision is null");
        return annotation -> annotation.getUnit() == precision && !annotation.isAdjustedToUTC();
    }

    private static class WriteBuilder
    extends ParquetTypeVisitor<ColumnWriter> {
        private final MessageType type;
        private final Map<List<String>, io.trino.spi.type.Type> trinoTypes;
        private final ParquetProperties parquetProperties;
        private final CompressionCodec compressionCodec;
        private final Optional<DateTimeZone> parquetTimeZone;
        private final ImmutableList.Builder<ColumnWriter> builder = ImmutableList.builder();

        WriteBuilder(MessageType messageType, Map<List<String>, io.trino.spi.type.Type> trinoTypes, ParquetProperties parquetProperties, CompressionCodec compressionCodec, Optional<DateTimeZone> parquetTimeZone) {
            this.type = Objects.requireNonNull(messageType, "messageType is null");
            this.trinoTypes = Objects.requireNonNull(trinoTypes, "trinoTypes is null");
            this.parquetProperties = Objects.requireNonNull(parquetProperties, "parquetProperties is null");
            this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
            this.parquetTimeZone = Objects.requireNonNull(parquetTimeZone, "parquetTimeZone is null");
        }

        List<ColumnWriter> build() {
            return this.builder.build();
        }

        @Override
        public ColumnWriter message(MessageType message, List<ColumnWriter> fields) {
            this.builder.addAll(fields);
            return super.message(message, fields);
        }

        @Override
        public ColumnWriter struct(GroupType struct, List<ColumnWriter> fields) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            return new StructColumnWriter((List<ColumnWriter>)ImmutableList.copyOf(fields), fieldDefinitionLevel);
        }

        @Override
        public ColumnWriter list(GroupType array, ColumnWriter element) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new ArrayColumnWriter(element, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter map(GroupType map, ColumnWriter key, ColumnWriter value) {
            String[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel(path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel(path);
            return new MapColumnWriter(key, value, fieldDefinitionLevel, fieldRepetitionLevel);
        }

        @Override
        public ColumnWriter primitive(PrimitiveType primitive) {
            Object[] path = this.currentPath();
            int fieldDefinitionLevel = this.type.getMaxDefinitionLevel((String[])path);
            int fieldRepetitionLevel = this.type.getMaxRepetitionLevel((String[])path);
            ColumnDescriptor columnDescriptor = new ColumnDescriptor((String[])path, primitive, fieldRepetitionLevel, fieldDefinitionLevel);
            io.trino.spi.type.Type trinoType = Objects.requireNonNull(this.trinoTypes.get(ImmutableList.copyOf((Object[])path)), "Trino type is null");
            return new PrimitiveColumnWriter(columnDescriptor, ParquetWriters.getValueWriter(this.parquetProperties.newValuesWriter(columnDescriptor), trinoType, columnDescriptor.getPrimitiveType(), this.parquetTimeZone), this.parquetProperties.newDefinitionLevelWriter(columnDescriptor), this.parquetProperties.newRepetitionLevelWriter(columnDescriptor), this.compressionCodec, this.parquetProperties.getPageSizeThreshold());
        }

        private String[] currentPath() {
            String[] path = new String[this.fieldNames.size()];
            if (!this.fieldNames.isEmpty()) {
                Iterator iter = this.fieldNames.descendingIterator();
                int i = 0;
                while (iter.hasNext()) {
                    path[i] = (String)iter.next();
                    ++i;
                }
            }
            return path;
        }
    }
}

