/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slices;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.ParquetCompressor;
import io.trino.parquet.writer.ParquetDataOutput;
import io.trino.parquet.writer.ParquetTypeConverter;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.DefLevelWriterProviders;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.parquet.writer.repdef.RepLevelIterables;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.PageEncodingStats;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.schema.Type;

public class PrimitiveColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(PrimitiveColumnWriter.class);
    private final ColumnDescriptor columnDescriptor;
    private final CompressionCodec compressionCodec;
    private final PrimitiveValueWriter primitiveValueWriter;
    private final ValuesWriter definitionLevelWriter;
    private final ValuesWriter repetitionLevelWriter;
    private final ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
    private boolean closed;
    private boolean getDataStreamsCalled;
    private int valueCount;
    private int currentPageNullCounts;
    private final Set<org.apache.parquet.column.Encoding> encodings = new HashSet<org.apache.parquet.column.Encoding>();
    private final Map<Encoding, Integer> dataPagesWithEncoding = new HashMap<Encoding, Integer>();
    private final Map<Encoding, Integer> dictionaryPagesWithEncoding = new HashMap<Encoding, Integer>();
    private long totalCompressedSize;
    private long totalUnCompressedSize;
    private long totalValues;
    private Statistics<?> columnStatistics;
    private final int maxDefinitionLevel;
    private final List<ParquetDataOutput> pageBuffer = new ArrayList<ParquetDataOutput>();
    @Nullable
    private final ParquetCompressor compressor;
    private final int pageSizeThreshold;
    private long bufferedBytes;
    private long pageBufferedBytes;

    public PrimitiveColumnWriter(ColumnDescriptor columnDescriptor, PrimitiveValueWriter primitiveValueWriter, ValuesWriter definitionLevelWriter, ValuesWriter repetitionLevelWriter, CompressionCodec compressionCodec, int pageSizeThreshold) {
        this.columnDescriptor = Objects.requireNonNull(columnDescriptor, "columnDescriptor is null");
        this.maxDefinitionLevel = columnDescriptor.getMaxDefinitionLevel();
        this.definitionLevelWriter = Objects.requireNonNull(definitionLevelWriter, "definitionLevelWriter is null");
        this.repetitionLevelWriter = Objects.requireNonNull(repetitionLevelWriter, "repetitionLevelWriter is null");
        this.primitiveValueWriter = Objects.requireNonNull(primitiveValueWriter, "primitiveValueWriter is null");
        this.compressionCodec = Objects.requireNonNull(compressionCodec, "compressionCodec is null");
        this.compressor = ParquetCompressor.getCompressor(compressionCodec);
        this.pageSizeThreshold = pageSizeThreshold;
        this.columnStatistics = Statistics.createStats((Type)columnDescriptor.getPrimitiveType());
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.primitiveValueWriter.write(columnChunk.getBlock());
        ImmutableList defLevelWriterProviders = ImmutableList.builder().addAll(columnChunk.getDefLevelWriterProviders()).add((Object)DefLevelWriterProviders.of(columnChunk.getBlock(), this.maxDefinitionLevel)).build();
        DefLevelWriterProvider.DefinitionLevelWriter rootDefinitionLevelWriter = DefLevelWriterProvider.getRootDefinitionLevelWriter((List<DefLevelWriterProvider>)defLevelWriterProviders, this.definitionLevelWriter);
        DefLevelWriterProvider.ValuesCount valuesCount = rootDefinitionLevelWriter.writeDefinitionLevels();
        this.currentPageNullCounts += valuesCount.totalValuesCount() - valuesCount.maxDefinitionLevelValuesCount();
        this.valueCount += valuesCount.totalValuesCount();
        if (this.columnDescriptor.getMaxRepetitionLevel() > 0) {
            Iterator<Integer> repIterator = RepLevelIterables.getIterator((List<RepLevelIterable>)ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnChunk.getBlock())).build());
            while (repIterator.hasNext()) {
                int next = repIterator.next();
                this.repetitionLevelWriter.writeInteger(next);
            }
        }
        this.updateBufferedBytes();
        if (this.bufferedBytes >= (long)this.pageSizeThreshold) {
            this.flushCurrentPageToBuffer();
        }
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableList.of((Object)new ColumnWriter.BufferData(this.getDataStreams(), this.getColumnMetaData()));
    }

    private ColumnMetaData getColumnMetaData() {
        Preconditions.checkState((boolean)this.getDataStreamsCalled);
        ColumnMetaData columnMetaData = new ColumnMetaData(ParquetTypeConverter.getType(this.columnDescriptor.getPrimitiveType().getPrimitiveTypeName()), (List)this.encodings.stream().map(arg_0 -> ((ParquetMetadataConverter)this.parquetMetadataConverter).getEncoding(arg_0)).collect(ImmutableList.toImmutableList()), (List)ImmutableList.copyOf((Object[])this.columnDescriptor.getPath()), this.compressionCodec, this.totalValues, this.totalUnCompressedSize, this.totalCompressedSize, -1L);
        columnMetaData.setStatistics(ParquetMetadataConverter.toParquetStatistics(this.columnStatistics));
        ImmutableList.Builder pageEncodingStats = ImmutableList.builder();
        this.dataPagesWithEncoding.entrySet().stream().map(encodingAndCount -> new PageEncodingStats(PageType.DATA_PAGE, (Encoding)encodingAndCount.getKey(), ((Integer)encodingAndCount.getValue()).intValue())).forEach(arg_0 -> ((ImmutableList.Builder)pageEncodingStats).add(arg_0));
        this.dictionaryPagesWithEncoding.entrySet().stream().map(encodingAndCount -> new PageEncodingStats(PageType.DICTIONARY_PAGE, (Encoding)encodingAndCount.getKey(), ((Integer)encodingAndCount.getValue()).intValue())).forEach(arg_0 -> ((ImmutableList.Builder)pageEncodingStats).add(arg_0));
        columnMetaData.setEncoding_stats((List)pageEncodingStats.build());
        return columnMetaData;
    }

    private void flushCurrentPageToBuffer() throws IOException {
        byte[] pageDataBytes = BytesInput.concat((BytesInput[])new BytesInput[]{this.repetitionLevelWriter.getBytes(), this.definitionLevelWriter.getBytes(), this.primitiveValueWriter.getBytes()}).toByteArray();
        long uncompressedSize = pageDataBytes.length;
        ParquetDataOutput pageData = this.compressor != null ? this.compressor.compress(pageDataBytes) : ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])pageDataBytes));
        long compressedSize = pageData.size();
        Statistics<?> statistics = this.primitiveValueWriter.getStatistics();
        statistics.incrementNumNulls((long)this.currentPageNullCounts);
        this.columnStatistics.mergeStatistics(statistics);
        ByteArrayOutputStream pageHeaderOutputStream = new ByteArrayOutputStream();
        this.parquetMetadataConverter.writeDataPageV1Header(Math.toIntExact(uncompressedSize), Math.toIntExact(compressedSize), this.valueCount, this.repetitionLevelWriter.getEncoding(), this.definitionLevelWriter.getEncoding(), this.primitiveValueWriter.getEncoding(), (OutputStream)pageHeaderOutputStream);
        ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(BytesInput.from((ByteArrayOutputStream)pageHeaderOutputStream));
        this.dataPagesWithEncoding.merge(this.parquetMetadataConverter.getEncoding(this.primitiveValueWriter.getEncoding()), 1, Integer::sum);
        this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
        long pageCompressedSize = pageHeader.size() + compressedSize;
        this.totalCompressedSize += pageCompressedSize;
        this.totalValues += (long)this.valueCount;
        this.pageBuffer.add(pageHeader);
        this.pageBuffer.add(pageData);
        this.pageBufferedBytes += pageCompressedSize;
        this.encodings.add(this.repetitionLevelWriter.getEncoding());
        this.encodings.add(this.definitionLevelWriter.getEncoding());
        this.encodings.add(this.primitiveValueWriter.getEncoding());
        this.valueCount = 0;
        this.currentPageNullCounts = 0;
        this.repetitionLevelWriter.reset();
        this.definitionLevelWriter.reset();
        this.primitiveValueWriter.reset();
        this.updateBufferedBytes();
    }

    private List<ParquetDataOutput> getDataStreams() throws IOException {
        DictionaryPage dictionaryPage;
        ArrayList<ParquetDataOutput> dictPage = new ArrayList<ParquetDataOutput>();
        if (this.valueCount > 0) {
            this.flushCurrentPageToBuffer();
        }
        if ((dictionaryPage = this.primitiveValueWriter.toDictPageAndClose()) != null) {
            long uncompressedSize = dictionaryPage.getUncompressedSize();
            byte[] pageBytes = dictionaryPage.getBytes().toByteArray();
            ParquetDataOutput pageData = this.compressor != null ? this.compressor.compress(pageBytes) : ParquetDataOutput.createDataOutput(Slices.wrappedBuffer((byte[])pageBytes));
            long compressedSize = pageData.size();
            ByteArrayOutputStream dictStream = new ByteArrayOutputStream();
            this.parquetMetadataConverter.writeDictionaryPageHeader(Math.toIntExact(uncompressedSize), Math.toIntExact(compressedSize), dictionaryPage.getDictionarySize(), dictionaryPage.getEncoding(), (OutputStream)dictStream);
            ParquetDataOutput pageHeader = ParquetDataOutput.createDataOutput(BytesInput.from((ByteArrayOutputStream)dictStream));
            dictPage.add(pageHeader);
            dictPage.add(pageData);
            this.totalCompressedSize += pageHeader.size() + compressedSize;
            this.totalUnCompressedSize += pageHeader.size() + uncompressedSize;
            this.dictionaryPagesWithEncoding.merge(new ParquetMetadataConverter().getEncoding(dictionaryPage.getEncoding()), 1, Integer::sum);
            this.primitiveValueWriter.resetDictionary();
            this.updateBufferedBytes();
        }
        this.getDataStreamsCalled = true;
        return ImmutableList.builder().addAll(dictPage).addAll(this.pageBuffer).build();
    }

    @Override
    public long getBufferedBytes() {
        return this.bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.primitiveValueWriter.getAllocatedSize() + this.definitionLevelWriter.getAllocatedSize() + this.repetitionLevelWriter.getAllocatedSize();
    }

    private void updateBufferedBytes() {
        this.bufferedBytes = this.pageBufferedBytes + this.definitionLevelWriter.getBufferedSize() + this.repetitionLevelWriter.getBufferedSize() + this.primitiveValueWriter.getBufferedSize();
    }
}

