/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ColumnWriter;
import io.trino.parquet.writer.repdef.DefLevelWriterProvider;
import io.trino.parquet.writer.repdef.DefLevelWriterProviders;
import io.trino.parquet.writer.repdef.RepLevelIterable;
import io.trino.parquet.writer.repdef.RepLevelIterables;
import io.trino.spi.block.Block;
import io.trino.spi.block.ColumnarRow;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.parquet.Preconditions;

public class StructColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(StructColumnWriter.class);
    private final List<ColumnWriter> columnWriters;
    private final int maxDefinitionLevel;

    public StructColumnWriter(List<ColumnWriter> columnWriters, int maxDefinitionLevel) {
        this.columnWriters = Objects.requireNonNull(columnWriters, "columnWriters is null");
        this.maxDefinitionLevel = maxDefinitionLevel;
    }

    @Override
    public void writeBlock(ColumnChunk columnChunk) throws IOException {
        ColumnarRow columnarRow = ColumnarRow.toColumnarRow((Block)columnChunk.getBlock());
        Preconditions.checkArgument((columnarRow.getFieldCount() == this.columnWriters.size() ? 1 : 0) != 0, (String)"ColumnarRow field size %s is not equal to columnWriters size %s", (Object[])new Object[]{columnarRow.getFieldCount(), this.columnWriters.size()});
        ImmutableList defLevelWriterProviders = ImmutableList.builder().addAll(columnChunk.getDefLevelWriterProviders()).add((Object)DefLevelWriterProviders.of(columnarRow, this.maxDefinitionLevel)).build();
        ImmutableList repLevelIterables = ImmutableList.builder().addAll(columnChunk.getRepLevelIterables()).add((Object)RepLevelIterables.of(columnChunk.getBlock())).build();
        for (int i = 0; i < this.columnWriters.size(); ++i) {
            ColumnWriter columnWriter = this.columnWriters.get(i);
            Block block = columnarRow.getField(i);
            columnWriter.writeBlock(new ColumnChunk(block, (List<DefLevelWriterProvider>)defLevelWriterProviders, (List<RepLevelIterable>)repLevelIterables));
        }
    }

    @Override
    public void close() {
        this.columnWriters.forEach(ColumnWriter::close);
    }

    @Override
    public List<ColumnWriter.BufferData> getBuffer() throws IOException {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnWriter columnWriter : this.columnWriters) {
            builder.addAll(columnWriter.getBuffer());
        }
        return builder.build();
    }

    @Override
    public long getBufferedBytes() {
        long bufferedBytes = 0L;
        for (ColumnWriter columnWriter : this.columnWriters) {
            bufferedBytes += columnWriter.getBufferedBytes();
        }
        return bufferedBytes;
    }

    @Override
    public long getRetainedBytes() {
        return (long)INSTANCE_SIZE + this.columnWriters.stream().mapToLong(ColumnWriter::getRetainedBytes).sum();
    }
}

