/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.ValuesType;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ApacheParquetValueDecoders;
import io.trino.parquet.reader.decoders.DeltaBinaryPackedDecoders;
import io.trino.parquet.reader.decoders.DeltaByteArrayDecoders;
import io.trino.parquet.reader.decoders.DeltaLengthByteArrayDecoders;
import io.trino.parquet.reader.decoders.PlainByteArrayDecoders;
import io.trino.parquet.reader.decoders.PlainValueDecoders;
import io.trino.parquet.reader.decoders.RleBitPackingHybridBooleanDecoder;
import io.trino.parquet.reader.decoders.TransformingValueDecoders;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.parquet.reader.flat.DictionaryDecoder;
import io.trino.spi.type.CharType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class ValueDecoders {
    private ValueDecoders() {
    }

    public static ValueDecoder<long[]> getDoubleDecoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.LongPlainValueDecoder();
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<int[]> getRealDecoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.IntPlainValueDecoder();
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<long[]> getShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        PrimitiveType primitiveType = field.getDescriptor().getPrimitiveType();
        Preconditions.checkArgument((boolean)(primitiveType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation), (String)"Column %s is not annotated as a decimal", (Object)field);
        return switch (primitiveType.getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> ValueDecoders.getLongDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> TransformingValueDecoders.getInt32ToLongDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> ValueDecoders.getFixedWidthShortDecimalDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.BINARY -> TransformingValueDecoders.getBinaryShortDecimalDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> ValueDecoders.getFixedWidthLongDecimalDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.BINARY -> TransformingValueDecoders.getBinaryLongDecimalDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getUuidDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.UuidPlainValueDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY -> TransformingValueDecoders.getDeltaUuidDecoder(encoding);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getLongDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedLongDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<int[]> getIntDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> TransformingValueDecoders.getInt64ToIntDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> ValueDecoders.getInt32Decoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<short[]> getShortDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> TransformingValueDecoders.getInt64ToShortDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> ValueDecoders.getInt32ToShortDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<byte[]> getByteDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> TransformingValueDecoders.getInt64ToByteDecoder(encoding, field);
            case PrimitiveType.PrimitiveTypeName.INT32 -> ValueDecoders.getInt32ToByteDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<byte[]> getBooleanDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.BooleanPlainValueDecoder();
            case ParquetEncoding.RLE -> new RleBitPackingHybridBooleanDecoder();
            case ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.BooleanApacheParquetValueDecoder(ValueDecoders.getApacheParquetReader(encoding, field));
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<int[]> getInt96TimestampDecoder(ParquetEncoding encoding, PrimitiveField field) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.Int96TimestampPlainValueDecoder();
        }
        throw ValueDecoders.wrongEncoding(encoding, field);
    }

    public static ValueDecoder<long[]> getFixedWidthShortDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.ShortDecimalFixedLengthByteArrayDecoder(field.getDescriptor());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> TransformingValueDecoders.getDeltaFixedWidthShortDecimalDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<long[]> getFixedWidthLongDecimalDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongDecimalPlainValueDecoder(field.getDescriptor().getPrimitiveType().getTypeLength());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> TransformingValueDecoders.getDeltaFixedWidthLongDecimalDecoder(encoding, field);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getFixedWidthBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.FixedLengthPlainValueDecoder(field.getDescriptor().getPrimitiveType().getTypeLength());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getBoundedVarcharBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        VarcharType varcharType;
        Type trinoType = field.getType();
        Preconditions.checkArgument((trinoType instanceof VarcharType && !(varcharType = (VarcharType)trinoType).isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BoundedVarcharPlainValueDecoder((VarcharType)trinoType);
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.BoundedVarcharDeltaLengthDecoder((VarcharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BoundedVarcharDeltaByteArrayDecoder((VarcharType)trinoType);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getCharBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        Type trinoType = field.getType();
        Preconditions.checkArgument((boolean)(trinoType instanceof CharType), (String)"Trino type %s is not a char", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.CharPlainValueDecoder((CharType)trinoType);
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.CharDeltaLengthDecoder((CharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.CharDeltaByteArrayDecoder((CharType)trinoType);
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static ValueDecoder<BinaryBuffer> getBinaryDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BinaryPlainValueDecoder();
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.BinaryDeltaLengthDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    public static <T> DictionaryDecoder<T> getDictionaryDecoder(DictionaryPage dictionaryPage, ColumnAdapter<T> columnAdapter, ValueDecoder<T> plainValuesDecoder, boolean isNonNull) {
        int size = dictionaryPage.getDictionarySize();
        T dictionary = columnAdapter.createBuffer(size + (isNonNull ? 0 : 1));
        plainValuesDecoder.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        plainValuesDecoder.read(dictionary, 0, size);
        return new DictionaryDecoder<T>(dictionary, columnAdapter, size, isNonNull);
    }

    public static ValueDecoder<int[]> getInt32Decoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    private static ValueDecoder<short[]> getInt32ToShortDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToShortPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedShortDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    private static ValueDecoder<byte[]> getInt32ToByteDecoder(ParquetEncoding encoding, PrimitiveField field) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToBytePlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedByteDecoder();
            default -> throw ValueDecoders.wrongEncoding(encoding, field);
        };
    }

    private static ValuesReader getApacheParquetReader(ParquetEncoding encoding, PrimitiveField field) {
        return encoding.getValuesReader(field.getDescriptor(), ValuesType.VALUES);
    }

    private static IllegalArgumentException wrongEncoding(ParquetEncoding encoding, PrimitiveField field) {
        return new IllegalArgumentException("Wrong encoding " + encoding + " for column " + field.getDescriptor());
    }
}

