/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Type;

public class Int32ShortDecimalColumnReader
extends PrimitiveColumnReader {
    public Int32ShortDecimalColumnReader(PrimitiveField field) {
        super(field);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type trinoType) {
        long value;
        DecimalType trinoDecimalType;
        if (trinoType instanceof DecimalType && (trinoDecimalType = (DecimalType)trinoType).isShort()) {
            value = this.valuesReader.readInteger();
            if (Decimals.overflows((long)value, (int)trinoDecimalType.getPrecision())) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot read parquet INT32 value '%s' as DECIMAL(%s, %s)", value, trinoDecimalType.getPrecision(), trinoDecimalType.getScale()));
            }
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", trinoType, this.field.getDescriptor()));
        }
        trinoType.writeLong(blockBuilder, value);
    }
}

