/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class FixedLenByteArrayShortDecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public FixedLenByteArrayShortDecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)this.decimalType.isShort(), (Object)"type is not a short decimal");
        Preconditions.checkArgument((parquetType.getTypeLength() > 0 && parquetType.getTypeLength() <= 8 ? 1 : 0) != 0, (String)"Type length %s must be in range 1-%s", (int)parquetType.getTypeLength(), (int)8);
    }

    @Override
    public void write(Block block) {
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (block.isNull(i)) continue;
            long value = this.decimalType.getLong(block, i);
            Binary binary = Binary.fromConstantByteArray((byte[])this.paddingLong(value));
            this.getValueWriter().writeBytes(binary);
            this.getStatistics().updateStats(binary);
        }
    }

    private byte[] paddingLong(long unscaledValue) {
        int numBytes = this.getTypeLength();
        byte[] result = new byte[numBytes];
        switch (numBytes) {
            case 1: {
                result[0] = (byte)unscaledValue;
                break;
            }
            case 2: {
                result[0] = (byte)(unscaledValue >> 8);
                result[1] = (byte)unscaledValue;
                break;
            }
            case 3: {
                result[0] = (byte)(unscaledValue >> 16);
                result[1] = (byte)(unscaledValue >> 8);
                result[2] = (byte)unscaledValue;
                break;
            }
            case 4: {
                result[0] = (byte)(unscaledValue >> 24);
                result[1] = (byte)(unscaledValue >> 16);
                result[2] = (byte)(unscaledValue >> 8);
                result[3] = (byte)unscaledValue;
                break;
            }
            case 5: {
                result[0] = (byte)(unscaledValue >> 32);
                result[1] = (byte)(unscaledValue >> 24);
                result[2] = (byte)(unscaledValue >> 16);
                result[3] = (byte)(unscaledValue >> 8);
                result[4] = (byte)unscaledValue;
                break;
            }
            case 6: {
                result[0] = (byte)(unscaledValue >> 40);
                result[1] = (byte)(unscaledValue >> 32);
                result[2] = (byte)(unscaledValue >> 24);
                result[3] = (byte)(unscaledValue >> 16);
                result[4] = (byte)(unscaledValue >> 8);
                result[5] = (byte)unscaledValue;
                break;
            }
            case 7: {
                result[0] = (byte)(unscaledValue >> 48);
                result[1] = (byte)(unscaledValue >> 40);
                result[2] = (byte)(unscaledValue >> 32);
                result[3] = (byte)(unscaledValue >> 24);
                result[4] = (byte)(unscaledValue >> 16);
                result[5] = (byte)(unscaledValue >> 8);
                result[6] = (byte)unscaledValue;
                break;
            }
            case 8: {
                result[0] = (byte)(unscaledValue >> 56);
                result[1] = (byte)(unscaledValue >> 48);
                result[2] = (byte)(unscaledValue >> 40);
                result[3] = (byte)(unscaledValue >> 32);
                result[4] = (byte)(unscaledValue >> 24);
                result[5] = (byte)(unscaledValue >> 16);
                result[6] = (byte)(unscaledValue >> 8);
                result[7] = (byte)unscaledValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number of bytes: " + numBytes);
            }
        }
        return result;
    }
}

