/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import com.google.common.base.MoreObjects;
import io.trino.parquet.Field;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;

public class PrimitiveField
extends Field {
    private final ColumnDescriptor descriptor;
    private final int id;

    public PrimitiveField(Type type, boolean required, ColumnDescriptor descriptor, int id) {
        super(type, descriptor.getMaxRepetitionLevel(), descriptor.getMaxDefinitionLevel(), required);
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is required");
        this.id = id;
    }

    public ColumnDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.getType()).add("id", this.id).add("repetitionLevel", this.getRepetitionLevel()).add("definitionLevel", this.getDefinitionLevel()).add("required", this.isRequired()).add("descriptor", (Object)this.descriptor).toString();
    }
}

