/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.airlift.log.Logger;
import io.airlift.slice.Slice;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.ColumnChunk;
import io.trino.parquet.reader.ColumnReader;
import io.trino.parquet.reader.FilteredRowRanges;
import io.trino.parquet.reader.PageReader;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.parquet.reader.flat.DictionaryDecoder;
import io.trino.parquet.reader.flat.RowRangesIterator;
import io.trino.spi.block.Block;
import io.trino.spi.block.DictionaryBlock;
import io.trino.spi.type.AbstractVariableWidthType;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import javax.annotation.Nullable;
import org.apache.parquet.io.ParquetDecodingException;

public abstract class AbstractColumnReader<BufferType>
implements ColumnReader {
    private static final Logger log = Logger.get(AbstractColumnReader.class);
    protected final PrimitiveField field;
    protected final ValueDecoder.ValueDecodersProvider<BufferType> decodersProvider;
    protected final ColumnAdapter<BufferType> columnAdapter;
    private final DictionaryDecoder.DictionaryDecoderProvider<BufferType> dictionaryDecoderProvider;
    protected PageReader pageReader;
    protected RowRangesIterator rowRanges;
    @Nullable
    protected DictionaryDecoder<BufferType> dictionaryDecoder;
    private boolean produceDictionaryBlock;

    public AbstractColumnReader(PrimitiveField field, ValueDecoder.ValueDecodersProvider<BufferType> decodersProvider, DictionaryDecoder.DictionaryDecoderProvider<BufferType> dictionaryDecoderProvider, ColumnAdapter<BufferType> columnAdapter) {
        this.field = Objects.requireNonNull(field, "field is null");
        this.decodersProvider = Objects.requireNonNull(decodersProvider, "decoders is null");
        this.dictionaryDecoderProvider = Objects.requireNonNull(dictionaryDecoderProvider, "dictionaryDecoderProvider is null");
        this.columnAdapter = Objects.requireNonNull(columnAdapter, "columnAdapter is null");
    }

    @Override
    public void setPageReader(PageReader pageReader, Optional<FilteredRowRanges> rowRanges) {
        this.pageReader = Objects.requireNonNull(pageReader, "pageReader");
        DictionaryPage dictionaryPage = pageReader.readDictionaryPage();
        if (dictionaryPage != null) {
            log.debug("field %s, readDictionaryPage %s", new Object[]{this.field, dictionaryPage});
            this.dictionaryDecoder = this.dictionaryDecoderProvider.create(dictionaryPage, this.isNonNull());
            this.produceDictionaryBlock = this.shouldProduceDictionaryBlock(rowRanges);
        }
        this.rowRanges = RowRangesIterator.createRowRangesIterator(rowRanges);
    }

    protected abstract boolean isNonNull();

    protected boolean produceDictionaryBlock() {
        return this.produceDictionaryBlock;
    }

    protected ValueDecoder<BufferType> createValueDecoder(ValueDecoder.ValueDecodersProvider<BufferType> decodersProvider, ParquetEncoding encoding, Slice data) {
        ValueDecoder<BufferType> valueDecoder;
        if (encoding == ParquetEncoding.PLAIN_DICTIONARY || encoding == ParquetEncoding.RLE_DICTIONARY) {
            if (this.dictionaryDecoder == null) {
                throw new ParquetDecodingException(String.format("Dictionary is missing for %s", this.field));
            }
            valueDecoder = this.dictionaryDecoder;
        } else {
            valueDecoder = decodersProvider.create(encoding);
        }
        valueDecoder.init(new SimpleSliceInputStream(data));
        return valueDecoder;
    }

    protected static void throwEndOfBatchException(int remainingInBatch) {
        throw new ParquetDecodingException(String.format("Corrupted Parquet file: extra %d values to be consumed when scanning current batch", remainingInBatch));
    }

    protected static void unpackDictionaryNullId(int[] source, int[] destination, boolean[] isNull, int destOffset, int chunkSize, int nullId) {
        int srcOffset = 0;
        for (int i = destOffset; i < destOffset + chunkSize; ++i) {
            destination[i] = isNull[i] ? nullId : source[srcOffset++];
        }
    }

    protected static ColumnChunk createDictionaryBlock(int[] dictionaryIds, Block dictionary, int[] definitions, int[] repetitions) {
        int positionsCount = dictionaryIds.length;
        return new ColumnChunk(DictionaryBlock.create((int)positionsCount, (Block)dictionary, (int[])dictionaryIds), definitions, repetitions, OptionalLong.of(AbstractColumnReader.getMaxDictionaryBlockSize(dictionary, positionsCount)));
    }

    private boolean shouldProduceDictionaryBlock(Optional<FilteredRowRanges> filteredRowRanges) {
        if (this.pageReader.hasOnlyDictionaryEncodedPages()) {
            if (!(this.field.getType() instanceof AbstractVariableWidthType)) {
                return false;
            }
            Objects.requireNonNull(this.dictionaryDecoder, "dictionaryDecoder is null");
            return filteredRowRanges.map(rowRanges -> rowRanges.getRowCount() > (long)this.dictionaryDecoder.getDictionarySize()).orElse(true);
        }
        return false;
    }

    private static long getMaxDictionaryBlockSize(Block dictionary, long batchSize) {
        double maxDictionaryFractionUsed = Math.min((double)batchSize / (double)dictionary.getPositionCount(), 1.0);
        return (long)((double)(batchSize * 4L) + (double)dictionary.getSizeInBytes() * maxDictionaryFractionUsed);
    }
}

