/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.PrimitiveColumnReader;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.LongTimestamp;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;

public class Int64TimestampMillisColumnReader
extends PrimitiveColumnReader {
    public Int64TimestampMillisColumnReader(PrimitiveField field) {
        super(field);
    }

    @Override
    protected void readValue(BlockBuilder blockBuilder, Type type) {
        long epochMillis = this.valuesReader.readLong();
        if (type instanceof TimestampWithTimeZoneType) {
            type.writeLong(blockBuilder, DateTimeEncoding.packDateTimeWithZone((long)epochMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        } else if (type instanceof TimestampType) {
            long epochMicros = epochMillis * 1000L;
            if (((TimestampType)type).isShort()) {
                type.writeLong(blockBuilder, epochMicros);
            } else {
                type.writeObject(blockBuilder, (Object)new LongTimestamp(epochMicros, 0));
            }
        } else if (type == BigintType.BIGINT) {
            type.writeLong(blockBuilder, epochMillis);
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", type, this.field.getDescriptor()));
        }
    }
}

