/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.airlift.slice.Slices;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.IntBitUnpacker;

public final class IntBitUnpackers {
    private static final IntBitUnpacker[] UNPACKERS = new IntBitUnpacker[]{new Unpacker0(), new Unpacker1(), new Unpacker2(), new Unpacker3(), new Unpacker4(), new Unpacker5(), new Unpacker6(), new Unpacker7(), new Unpacker8(), new Unpacker9(), new Unpacker10(), new Unpacker11(), new Unpacker12(), new Unpacker13(), new Unpacker14(), new Unpacker15(), new Unpacker16(), new Unpacker17(), new Unpacker18(), new Unpacker19(), new Unpacker20(), new Unpacker21(), new Unpacker22(), new Unpacker23(), new Unpacker24(), new Unpacker25(), new Unpacker26(), new Unpacker27(), new Unpacker28(), new Unpacker29(), new Unpacker30(), new Unpacker31(), new Unpacker32()};

    public static IntBitUnpacker getIntBitUnpacker(int bitWidth) {
        return UNPACKERS[bitWidth];
    }

    private IntBitUnpackers() {
    }

    private static final class Unpacker0
    implements IntBitUnpacker {
        private Unpacker0() {
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
        }
    }

    private static final class Unpacker1
    implements IntBitUnpacker {
        private Unpacker1() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            byte v0 = input[inputOffset];
            output[outputOffset] = v0 & 1;
            output[outputOffset + 1] = v0 >>> 1 & 1;
            output[outputOffset + 2] = v0 >>> 2 & 1;
            output[outputOffset + 3] = v0 >>> 3 & 1;
            output[outputOffset + 4] = v0 >>> 4 & 1;
            output[outputOffset + 5] = v0 >>> 5 & 1;
            output[outputOffset + 6] = v0 >>> 6 & 1;
            output[outputOffset + 7] = v0 >>> 7 & 1;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArr = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker1.unpack8(output, outputOffset, inputArr, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                ++inputBytesRead;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker2
    implements IntBitUnpacker {
        private Unpacker2() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            byte v0 = input[inputOffset];
            byte v1 = input[inputOffset + 1];
            output[outputOffset] = v0 & 3;
            output[outputOffset + 1] = v0 >>> 2 & 3;
            output[outputOffset + 2] = v0 >>> 4 & 3;
            output[outputOffset + 3] = v0 >>> 6 & 3;
            output[outputOffset + 4] = v1 & 3;
            output[outputOffset + 5] = v1 >>> 2 & 3;
            output[outputOffset + 6] = v1 >>> 4 & 3;
            output[outputOffset + 7] = v1 >>> 6 & 3;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArr = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker2.unpack8(output, outputOffset, inputArr, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 2;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker3
    implements IntBitUnpacker {
        private Unpacker3() {
        }

        private static void unpack64(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = (int)(v0 & 7L);
            output[outputOffset + 1] = (int)(v0 >>> 3 & 7L);
            output[outputOffset + 2] = (int)(v0 >>> 6 & 7L);
            output[outputOffset + 3] = (int)(v0 >>> 9 & 7L);
            output[outputOffset + 4] = (int)(v0 >>> 12 & 7L);
            output[outputOffset + 5] = (int)(v0 >>> 15 & 7L);
            output[outputOffset + 6] = (int)(v0 >>> 18 & 7L);
            output[outputOffset + 7] = (int)(v0 >>> 21 & 7L);
            output[outputOffset + 8] = (int)(v0 >>> 24 & 7L);
            output[outputOffset + 9] = (int)(v0 >>> 27 & 7L);
            output[outputOffset + 10] = (int)(v0 >>> 30 & 7L);
            output[outputOffset + 11] = (int)(v0 >>> 33 & 7L);
            output[outputOffset + 12] = (int)(v0 >>> 36 & 7L);
            output[outputOffset + 13] = (int)(v0 >>> 39 & 7L);
            output[outputOffset + 14] = (int)(v0 >>> 42 & 7L);
            output[outputOffset + 15] = (int)(v0 >>> 45 & 7L);
            output[outputOffset + 16] = (int)(v0 >>> 48 & 7L);
            output[outputOffset + 17] = (int)(v0 >>> 51 & 7L);
            output[outputOffset + 18] = (int)(v0 >>> 54 & 7L);
            output[outputOffset + 19] = (int)(v0 >>> 57 & 7L);
            output[outputOffset + 20] = (int)(v0 >>> 60 & 7L);
            output[outputOffset + 21] = (int)(v0 >>> 63 & 1L | (v1 & 3L) << 1);
            output[outputOffset + 22] = (int)(v1 >>> 2 & 7L);
            output[outputOffset + 23] = (int)(v1 >>> 5 & 7L);
            output[outputOffset + 24] = (int)(v1 >>> 8 & 7L);
            output[outputOffset + 25] = (int)(v1 >>> 11 & 7L);
            output[outputOffset + 26] = (int)(v1 >>> 14 & 7L);
            output[outputOffset + 27] = (int)(v1 >>> 17 & 7L);
            output[outputOffset + 28] = (int)(v1 >>> 20 & 7L);
            output[outputOffset + 29] = (int)(v1 >>> 23 & 7L);
            output[outputOffset + 30] = (int)(v1 >>> 26 & 7L);
            output[outputOffset + 31] = (int)(v1 >>> 29 & 7L);
            output[outputOffset + 32] = (int)(v1 >>> 32 & 7L);
            output[outputOffset + 33] = (int)(v1 >>> 35 & 7L);
            output[outputOffset + 34] = (int)(v1 >>> 38 & 7L);
            output[outputOffset + 35] = (int)(v1 >>> 41 & 7L);
            output[outputOffset + 36] = (int)(v1 >>> 44 & 7L);
            output[outputOffset + 37] = (int)(v1 >>> 47 & 7L);
            output[outputOffset + 38] = (int)(v1 >>> 50 & 7L);
            output[outputOffset + 39] = (int)(v1 >>> 53 & 7L);
            output[outputOffset + 40] = (int)(v1 >>> 56 & 7L);
            output[outputOffset + 41] = (int)(v1 >>> 59 & 7L);
            output[outputOffset + 42] = (int)(v1 >>> 62 & 3L | (v2 & 1L) << 2);
            output[outputOffset + 43] = (int)(v2 >>> 1 & 7L);
            output[outputOffset + 44] = (int)(v2 >>> 4 & 7L);
            output[outputOffset + 45] = (int)(v2 >>> 7 & 7L);
            output[outputOffset + 46] = (int)(v2 >>> 10 & 7L);
            output[outputOffset + 47] = (int)(v2 >>> 13 & 7L);
            output[outputOffset + 48] = (int)(v2 >>> 16 & 7L);
            output[outputOffset + 49] = (int)(v2 >>> 19 & 7L);
            output[outputOffset + 50] = (int)(v2 >>> 22 & 7L);
            output[outputOffset + 51] = (int)(v2 >>> 25 & 7L);
            output[outputOffset + 52] = (int)(v2 >>> 28 & 7L);
            output[outputOffset + 53] = (int)(v2 >>> 31 & 7L);
            output[outputOffset + 54] = (int)(v2 >>> 34 & 7L);
            output[outputOffset + 55] = (int)(v2 >>> 37 & 7L);
            output[outputOffset + 56] = (int)(v2 >>> 40 & 7L);
            output[outputOffset + 57] = (int)(v2 >>> 43 & 7L);
            output[outputOffset + 58] = (int)(v2 >>> 46 & 7L);
            output[outputOffset + 59] = (int)(v2 >>> 49 & 7L);
            output[outputOffset + 60] = (int)(v2 >>> 52 & 7L);
            output[outputOffset + 61] = (int)(v2 >>> 55 & 7L);
            output[outputOffset + 62] = (int)(v2 >>> 58 & 7L);
            output[outputOffset + 63] = (int)(v2 >>> 61 & 7L);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            short v0 = input.readShort();
            byte v1 = input.readByte();
            output[outputOffset] = (int)((long)v0 & 7L);
            output[outputOffset + 1] = (int)((long)(v0 >>> 3) & 7L);
            output[outputOffset + 2] = (int)((long)(v0 >>> 6) & 7L);
            output[outputOffset + 3] = (int)((long)(v0 >>> 9) & 7L);
            output[outputOffset + 4] = (int)((long)(v0 >>> 12) & 7L);
            output[outputOffset + 5] = (int)((long)(v0 >>> 15) & 1L | ((long)v1 & 3L) << 1);
            output[outputOffset + 6] = (int)((long)(v1 >>> 2) & 7L);
            output[outputOffset + 7] = (int)((long)(v1 >>> 5) & 7L);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 64) {
                Unpacker3.unpack64(output, outputOffset, input);
                outputOffset += 64;
                length -= 64;
            }
            switch (length) {
                case 56: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 48: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 40: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 32: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 24: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 16: {
                    Unpacker3.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 8: {
                    Unpacker3.unpack8(output, outputOffset, input);
                }
            }
        }
    }

    private static final class Unpacker4
    implements IntBitUnpacker {
        private Unpacker4() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            byte v0 = input[inputOffset];
            byte v1 = input[inputOffset + 1];
            byte v2 = input[inputOffset + 2];
            byte v3 = input[inputOffset + 3];
            output[outputOffset] = v0 & 0xF;
            output[outputOffset + 1] = v0 >>> 4 & 0xF;
            output[outputOffset + 2] = v1 & 0xF;
            output[outputOffset + 3] = v1 >>> 4 & 0xF;
            output[outputOffset + 4] = v2 & 0xF;
            output[outputOffset + 5] = v2 >>> 4 & 0xF;
            output[outputOffset + 6] = v3 & 0xF;
            output[outputOffset + 7] = v3 >>> 4 & 0xF;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArr = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker4.unpack8(output, outputOffset, inputArr, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 4;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker5
    implements IntBitUnpacker {
        private Unpacker5() {
        }

        private static void unpack64(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            output[outputOffset] = (int)(v0 & 0x1FL);
            output[outputOffset + 1] = (int)(v0 >>> 5 & 0x1FL);
            output[outputOffset + 2] = (int)(v0 >>> 10 & 0x1FL);
            output[outputOffset + 3] = (int)(v0 >>> 15 & 0x1FL);
            output[outputOffset + 4] = (int)(v0 >>> 20 & 0x1FL);
            output[outputOffset + 5] = (int)(v0 >>> 25 & 0x1FL);
            output[outputOffset + 6] = (int)(v0 >>> 30 & 0x1FL);
            output[outputOffset + 7] = (int)(v0 >>> 35 & 0x1FL);
            output[outputOffset + 8] = (int)(v0 >>> 40 & 0x1FL);
            output[outputOffset + 9] = (int)(v0 >>> 45 & 0x1FL);
            output[outputOffset + 10] = (int)(v0 >>> 50 & 0x1FL);
            output[outputOffset + 11] = (int)(v0 >>> 55 & 0x1FL);
            output[outputOffset + 12] = (int)(v0 >>> 60 & 0xFL | (v1 & 1L) << 4);
            output[outputOffset + 13] = (int)(v1 >>> 1 & 0x1FL);
            output[outputOffset + 14] = (int)(v1 >>> 6 & 0x1FL);
            output[outputOffset + 15] = (int)(v1 >>> 11 & 0x1FL);
            output[outputOffset + 16] = (int)(v1 >>> 16 & 0x1FL);
            output[outputOffset + 17] = (int)(v1 >>> 21 & 0x1FL);
            output[outputOffset + 18] = (int)(v1 >>> 26 & 0x1FL);
            output[outputOffset + 19] = (int)(v1 >>> 31 & 0x1FL);
            output[outputOffset + 20] = (int)(v1 >>> 36 & 0x1FL);
            output[outputOffset + 21] = (int)(v1 >>> 41 & 0x1FL);
            output[outputOffset + 22] = (int)(v1 >>> 46 & 0x1FL);
            output[outputOffset + 23] = (int)(v1 >>> 51 & 0x1FL);
            output[outputOffset + 24] = (int)(v1 >>> 56 & 0x1FL);
            output[outputOffset + 25] = (int)(v1 >>> 61 & 7L | (v2 & 3L) << 3);
            output[outputOffset + 26] = (int)(v2 >>> 2 & 0x1FL);
            output[outputOffset + 27] = (int)(v2 >>> 7 & 0x1FL);
            output[outputOffset + 28] = (int)(v2 >>> 12 & 0x1FL);
            output[outputOffset + 29] = (int)(v2 >>> 17 & 0x1FL);
            output[outputOffset + 30] = (int)(v2 >>> 22 & 0x1FL);
            output[outputOffset + 31] = (int)(v2 >>> 27 & 0x1FL);
            output[outputOffset + 32] = (int)(v2 >>> 32 & 0x1FL);
            output[outputOffset + 33] = (int)(v2 >>> 37 & 0x1FL);
            output[outputOffset + 34] = (int)(v2 >>> 42 & 0x1FL);
            output[outputOffset + 35] = (int)(v2 >>> 47 & 0x1FL);
            output[outputOffset + 36] = (int)(v2 >>> 52 & 0x1FL);
            output[outputOffset + 37] = (int)(v2 >>> 57 & 0x1FL);
            output[outputOffset + 38] = (int)(v2 >>> 62 & 3L | (v3 & 7L) << 2);
            output[outputOffset + 39] = (int)(v3 >>> 3 & 0x1FL);
            output[outputOffset + 40] = (int)(v3 >>> 8 & 0x1FL);
            output[outputOffset + 41] = (int)(v3 >>> 13 & 0x1FL);
            output[outputOffset + 42] = (int)(v3 >>> 18 & 0x1FL);
            output[outputOffset + 43] = (int)(v3 >>> 23 & 0x1FL);
            output[outputOffset + 44] = (int)(v3 >>> 28 & 0x1FL);
            output[outputOffset + 45] = (int)(v3 >>> 33 & 0x1FL);
            output[outputOffset + 46] = (int)(v3 >>> 38 & 0x1FL);
            output[outputOffset + 47] = (int)(v3 >>> 43 & 0x1FL);
            output[outputOffset + 48] = (int)(v3 >>> 48 & 0x1FL);
            output[outputOffset + 49] = (int)(v3 >>> 53 & 0x1FL);
            output[outputOffset + 50] = (int)(v3 >>> 58 & 0x1FL);
            output[outputOffset + 51] = (int)(v3 >>> 63 & 1L | (v4 & 0xFL) << 1);
            output[outputOffset + 52] = (int)(v4 >>> 4 & 0x1FL);
            output[outputOffset + 53] = (int)(v4 >>> 9 & 0x1FL);
            output[outputOffset + 54] = (int)(v4 >>> 14 & 0x1FL);
            output[outputOffset + 55] = (int)(v4 >>> 19 & 0x1FL);
            output[outputOffset + 56] = (int)(v4 >>> 24 & 0x1FL);
            output[outputOffset + 57] = (int)(v4 >>> 29 & 0x1FL);
            output[outputOffset + 58] = (int)(v4 >>> 34 & 0x1FL);
            output[outputOffset + 59] = (int)(v4 >>> 39 & 0x1FL);
            output[outputOffset + 60] = (int)(v4 >>> 44 & 0x1FL);
            output[outputOffset + 61] = (int)(v4 >>> 49 & 0x1FL);
            output[outputOffset + 62] = (int)(v4 >>> 54 & 0x1FL);
            output[outputOffset + 63] = (int)(v4 >>> 59 & 0x1FL);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            byte v1 = input.readByte();
            output[outputOffset] = (int)((long)v0 & 0x1FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 5) & 0x1FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 10) & 0x1FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 15) & 0x1FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 20) & 0x1FL);
            output[outputOffset + 5] = (int)((long)(v0 >>> 25) & 0x1FL);
            output[outputOffset + 6] = (int)((long)(v0 >>> 30) & 3L | ((long)v1 & 7L) << 2);
            output[outputOffset + 7] = (int)((long)(v1 >>> 3) & 0x1FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 64) {
                Unpacker5.unpack64(output, outputOffset, input);
                outputOffset += 64;
                length -= 64;
            }
            switch (length) {
                case 56: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 48: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 40: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 32: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 24: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 16: {
                    Unpacker5.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 8: {
                    Unpacker5.unpack8(output, outputOffset, input);
                }
            }
        }
    }

    private static final class Unpacker6
    implements IntBitUnpacker {
        private Unpacker6() {
        }

        private static void unpack32(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = (int)(v0 & 0x3FL);
            output[outputOffset + 1] = (int)(v0 >>> 6 & 0x3FL);
            output[outputOffset + 2] = (int)(v0 >>> 12 & 0x3FL);
            output[outputOffset + 3] = (int)(v0 >>> 18 & 0x3FL);
            output[outputOffset + 4] = (int)(v0 >>> 24 & 0x3FL);
            output[outputOffset + 5] = (int)(v0 >>> 30 & 0x3FL);
            output[outputOffset + 6] = (int)(v0 >>> 36 & 0x3FL);
            output[outputOffset + 7] = (int)(v0 >>> 42 & 0x3FL);
            output[outputOffset + 8] = (int)(v0 >>> 48 & 0x3FL);
            output[outputOffset + 9] = (int)(v0 >>> 54 & 0x3FL);
            output[outputOffset + 10] = (int)(v0 >>> 60 & 0xFL | (v1 & 3L) << 4);
            output[outputOffset + 11] = (int)(v1 >>> 2 & 0x3FL);
            output[outputOffset + 12] = (int)(v1 >>> 8 & 0x3FL);
            output[outputOffset + 13] = (int)(v1 >>> 14 & 0x3FL);
            output[outputOffset + 14] = (int)(v1 >>> 20 & 0x3FL);
            output[outputOffset + 15] = (int)(v1 >>> 26 & 0x3FL);
            output[outputOffset + 16] = (int)(v1 >>> 32 & 0x3FL);
            output[outputOffset + 17] = (int)(v1 >>> 38 & 0x3FL);
            output[outputOffset + 18] = (int)(v1 >>> 44 & 0x3FL);
            output[outputOffset + 19] = (int)(v1 >>> 50 & 0x3FL);
            output[outputOffset + 20] = (int)(v1 >>> 56 & 0x3FL);
            output[outputOffset + 21] = (int)(v1 >>> 62 & 3L | (v2 & 0xFL) << 2);
            output[outputOffset + 22] = (int)(v2 >>> 4 & 0x3FL);
            output[outputOffset + 23] = (int)(v2 >>> 10 & 0x3FL);
            output[outputOffset + 24] = (int)(v2 >>> 16 & 0x3FL);
            output[outputOffset + 25] = (int)(v2 >>> 22 & 0x3FL);
            output[outputOffset + 26] = (int)(v2 >>> 28 & 0x3FL);
            output[outputOffset + 27] = (int)(v2 >>> 34 & 0x3FL);
            output[outputOffset + 28] = (int)(v2 >>> 40 & 0x3FL);
            output[outputOffset + 29] = (int)(v2 >>> 46 & 0x3FL);
            output[outputOffset + 30] = (int)(v2 >>> 52 & 0x3FL);
            output[outputOffset + 31] = (int)(v2 >>> 58 & 0x3FL);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            short v1 = input.readShort();
            output[outputOffset] = (int)((long)v0 & 0x3FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 6) & 0x3FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 12) & 0x3FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 18) & 0x3FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 24) & 0x3FL);
            output[outputOffset + 5] = (int)((long)(v0 >>> 30) & 3L | ((long)v1 & 0xFL) << 2);
            output[outputOffset + 6] = (int)((long)(v1 >>> 4) & 0x3FL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 10) & 0x3FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 32) {
                Unpacker6.unpack32(output, outputOffset, input);
                outputOffset += 32;
                length -= 32;
            }
            switch (length) {
                case 24: {
                    Unpacker6.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 16: {
                    Unpacker6.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 8: {
                    Unpacker6.unpack8(output, outputOffset, input);
                }
            }
        }
    }

    private static final class Unpacker7
    implements IntBitUnpacker {
        private Unpacker7() {
        }

        private static void unpack64(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            long v3 = input.readLong();
            long v4 = input.readLong();
            long v5 = input.readLong();
            long v6 = input.readLong();
            output[outputOffset] = (int)(v0 & 0x7FL);
            output[outputOffset + 1] = (int)(v0 >>> 7 & 0x7FL);
            output[outputOffset + 2] = (int)(v0 >>> 14 & 0x7FL);
            output[outputOffset + 3] = (int)(v0 >>> 21 & 0x7FL);
            output[outputOffset + 4] = (int)(v0 >>> 28 & 0x7FL);
            output[outputOffset + 5] = (int)(v0 >>> 35 & 0x7FL);
            output[outputOffset + 6] = (int)(v0 >>> 42 & 0x7FL);
            output[outputOffset + 7] = (int)(v0 >>> 49 & 0x7FL);
            output[outputOffset + 8] = (int)(v0 >>> 56 & 0x7FL);
            output[outputOffset + 9] = (int)(v0 >>> 63 & 1L | (v1 & 0x3FL) << 1);
            output[outputOffset + 10] = (int)(v1 >>> 6 & 0x7FL);
            output[outputOffset + 11] = (int)(v1 >>> 13 & 0x7FL);
            output[outputOffset + 12] = (int)(v1 >>> 20 & 0x7FL);
            output[outputOffset + 13] = (int)(v1 >>> 27 & 0x7FL);
            output[outputOffset + 14] = (int)(v1 >>> 34 & 0x7FL);
            output[outputOffset + 15] = (int)(v1 >>> 41 & 0x7FL);
            output[outputOffset + 16] = (int)(v1 >>> 48 & 0x7FL);
            output[outputOffset + 17] = (int)(v1 >>> 55 & 0x7FL);
            output[outputOffset + 18] = (int)(v1 >>> 62 & 3L | (v2 & 0x1FL) << 2);
            output[outputOffset + 19] = (int)(v2 >>> 5 & 0x7FL);
            output[outputOffset + 20] = (int)(v2 >>> 12 & 0x7FL);
            output[outputOffset + 21] = (int)(v2 >>> 19 & 0x7FL);
            output[outputOffset + 22] = (int)(v2 >>> 26 & 0x7FL);
            output[outputOffset + 23] = (int)(v2 >>> 33 & 0x7FL);
            output[outputOffset + 24] = (int)(v2 >>> 40 & 0x7FL);
            output[outputOffset + 25] = (int)(v2 >>> 47 & 0x7FL);
            output[outputOffset + 26] = (int)(v2 >>> 54 & 0x7FL);
            output[outputOffset + 27] = (int)(v2 >>> 61 & 7L | (v3 & 0xFL) << 3);
            output[outputOffset + 28] = (int)(v3 >>> 4 & 0x7FL);
            output[outputOffset + 29] = (int)(v3 >>> 11 & 0x7FL);
            output[outputOffset + 30] = (int)(v3 >>> 18 & 0x7FL);
            output[outputOffset + 31] = (int)(v3 >>> 25 & 0x7FL);
            output[outputOffset + 32] = (int)(v3 >>> 32 & 0x7FL);
            output[outputOffset + 33] = (int)(v3 >>> 39 & 0x7FL);
            output[outputOffset + 34] = (int)(v3 >>> 46 & 0x7FL);
            output[outputOffset + 35] = (int)(v3 >>> 53 & 0x7FL);
            output[outputOffset + 36] = (int)(v3 >>> 60 & 0xFL | (v4 & 7L) << 4);
            output[outputOffset + 37] = (int)(v4 >>> 3 & 0x7FL);
            output[outputOffset + 38] = (int)(v4 >>> 10 & 0x7FL);
            output[outputOffset + 39] = (int)(v4 >>> 17 & 0x7FL);
            output[outputOffset + 40] = (int)(v4 >>> 24 & 0x7FL);
            output[outputOffset + 41] = (int)(v4 >>> 31 & 0x7FL);
            output[outputOffset + 42] = (int)(v4 >>> 38 & 0x7FL);
            output[outputOffset + 43] = (int)(v4 >>> 45 & 0x7FL);
            output[outputOffset + 44] = (int)(v4 >>> 52 & 0x7FL);
            output[outputOffset + 45] = (int)(v4 >>> 59 & 0x1FL | (v5 & 3L) << 5);
            output[outputOffset + 46] = (int)(v5 >>> 2 & 0x7FL);
            output[outputOffset + 47] = (int)(v5 >>> 9 & 0x7FL);
            output[outputOffset + 48] = (int)(v5 >>> 16 & 0x7FL);
            output[outputOffset + 49] = (int)(v5 >>> 23 & 0x7FL);
            output[outputOffset + 50] = (int)(v5 >>> 30 & 0x7FL);
            output[outputOffset + 51] = (int)(v5 >>> 37 & 0x7FL);
            output[outputOffset + 52] = (int)(v5 >>> 44 & 0x7FL);
            output[outputOffset + 53] = (int)(v5 >>> 51 & 0x7FL);
            output[outputOffset + 54] = (int)(v5 >>> 58 & 0x3FL | (v6 & 1L) << 6);
            output[outputOffset + 55] = (int)(v6 >>> 1 & 0x7FL);
            output[outputOffset + 56] = (int)(v6 >>> 8 & 0x7FL);
            output[outputOffset + 57] = (int)(v6 >>> 15 & 0x7FL);
            output[outputOffset + 58] = (int)(v6 >>> 22 & 0x7FL);
            output[outputOffset + 59] = (int)(v6 >>> 29 & 0x7FL);
            output[outputOffset + 60] = (int)(v6 >>> 36 & 0x7FL);
            output[outputOffset + 61] = (int)(v6 >>> 43 & 0x7FL);
            output[outputOffset + 62] = (int)(v6 >>> 50 & 0x7FL);
            output[outputOffset + 63] = (int)(v6 >>> 57 & 0x7FL);
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            int v0 = input.readInt();
            short v1 = input.readShort();
            byte v2 = input.readByte();
            output[outputOffset] = (int)((long)v0 & 0x7FL);
            output[outputOffset + 1] = (int)((long)(v0 >>> 7) & 0x7FL);
            output[outputOffset + 2] = (int)((long)(v0 >>> 14) & 0x7FL);
            output[outputOffset + 3] = (int)((long)(v0 >>> 21) & 0x7FL);
            output[outputOffset + 4] = (int)((long)(v0 >>> 28) & 0xFL | ((long)v1 & 7L) << 4);
            output[outputOffset + 5] = (int)((long)(v1 >>> 3) & 0x7FL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 10) & 0x3FL | ((long)v2 & 1L) << 6);
            output[outputOffset + 7] = (int)((long)(v2 >>> 1) & 0x7FL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 64) {
                Unpacker7.unpack64(output, outputOffset, input);
                outputOffset += 64;
                length -= 64;
            }
            switch (length) {
                case 56: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 48: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 40: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 32: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 24: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 16: {
                    Unpacker7.unpack8(output, outputOffset, input);
                    outputOffset += 8;
                }
                case 8: {
                    Unpacker7.unpack8(output, outputOffset, input);
                }
            }
        }
    }

    private static final class Unpacker8
    implements IntBitUnpacker {
        private Unpacker8() {
        }

        private static void unpack8(int[] output, int outputOffset, byte[] input, int inputOffset) {
            output[outputOffset] = input[inputOffset] & 0xFF;
            output[outputOffset + 1] = input[inputOffset + 1] & 0xFF;
            output[outputOffset + 2] = input[inputOffset + 2] & 0xFF;
            output[outputOffset + 3] = input[inputOffset + 3] & 0xFF;
            output[outputOffset + 4] = input[inputOffset + 4] & 0xFF;
            output[outputOffset + 5] = input[inputOffset + 5] & 0xFF;
            output[outputOffset + 6] = input[inputOffset + 6] & 0xFF;
            output[outputOffset + 7] = input[inputOffset + 7] & 0xFF;
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            byte[] inputArray = input.getByteArray();
            int inputOffset = input.getByteArrayOffset();
            int inputBytesRead = 0;
            while (length >= 8) {
                Unpacker8.unpack8(output, outputOffset, inputArray, inputOffset + inputBytesRead);
                outputOffset += 8;
                length -= 8;
                inputBytesRead += 8;
            }
            input.skip(inputBytesRead);
        }
    }

    private static final class Unpacker9
    implements IntBitUnpacker {
        private Unpacker9() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            byte v1 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFL);
            output[outputOffset + 1] = (int)(v0 >>> 9 & 0x1FFL);
            output[outputOffset + 2] = (int)(v0 >>> 18 & 0x1FFL);
            output[outputOffset + 3] = (int)(v0 >>> 27 & 0x1FFL);
            output[outputOffset + 4] = (int)(v0 >>> 36 & 0x1FFL);
            output[outputOffset + 5] = (int)(v0 >>> 45 & 0x1FFL);
            output[outputOffset + 6] = (int)(v0 >>> 54 & 0x1FFL);
            output[outputOffset + 7] = (int)(v0 >>> 63 & 1L | ((long)v1 & 0xFFL) << 1);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker9.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker10
    implements IntBitUnpacker {
        private Unpacker10() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            short v1 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFL);
            output[outputOffset + 1] = (int)(v0 >>> 10 & 0x3FFL);
            output[outputOffset + 2] = (int)(v0 >>> 20 & 0x3FFL);
            output[outputOffset + 3] = (int)(v0 >>> 30 & 0x3FFL);
            output[outputOffset + 4] = (int)(v0 >>> 40 & 0x3FFL);
            output[outputOffset + 5] = (int)(v0 >>> 50 & 0x3FFL);
            output[outputOffset + 6] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0x3FL) << 4);
            output[outputOffset + 7] = (int)((long)(v1 >>> 6) & 0x3FFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker10.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker11
    implements IntBitUnpacker {
        private Unpacker11() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            short v1 = input.readShort();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFL);
            output[outputOffset + 1] = (int)(v0 >>> 11 & 0x7FFL);
            output[outputOffset + 2] = (int)(v0 >>> 22 & 0x7FFL);
            output[outputOffset + 3] = (int)(v0 >>> 33 & 0x7FFL);
            output[outputOffset + 4] = (int)(v0 >>> 44 & 0x7FFL);
            output[outputOffset + 5] = (int)(v0 >>> 55 & 0x1FFL | ((long)v1 & 3L) << 9);
            output[outputOffset + 6] = (int)((long)(v1 >>> 2) & 0x7FFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 13) & 7L | ((long)v2 & 0xFFL) << 3);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker11.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker12
    implements IntBitUnpacker {
        private Unpacker12() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            output[outputOffset] = (int)(v0 & 0xFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 12 & 0xFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 24 & 0xFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 36 & 0xFFFL);
            output[outputOffset + 4] = (int)(v0 >>> 48 & 0xFFFL);
            output[outputOffset + 5] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0xFFL) << 4);
            output[outputOffset + 6] = (int)((long)(v1 >>> 8) & 0xFFFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 20) & 0xFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker12.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker13
    implements IntBitUnpacker {
        private Unpacker13() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 13 & 0x1FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 26 & 0x1FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 39 & 0x1FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 52 & 0xFFFL | ((long)v1 & 1L) << 12);
            output[outputOffset + 5] = (int)((long)(v1 >>> 1) & 0x1FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 14) & 0x1FFFL);
            output[outputOffset + 7] = (int)((long)(v1 >>> 27) & 0x1FL | ((long)v2 & 0xFFL) << 5);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker13.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker14
    implements IntBitUnpacker {
        private Unpacker14() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            short v2 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 14 & 0x3FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 28 & 0x3FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 42 & 0x3FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 56 & 0xFFL | ((long)v1 & 0x3FL) << 8);
            output[outputOffset + 5] = (int)((long)(v1 >>> 6) & 0x3FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 20) & 0xFFFL | ((long)v2 & 3L) << 12);
            output[outputOffset + 7] = (int)((long)(v2 >>> 2) & 0x3FFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker14.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker15
    implements IntBitUnpacker {
        private Unpacker15() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            int v1 = input.readInt();
            short v2 = input.readShort();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFL);
            output[outputOffset + 1] = (int)(v0 >>> 15 & 0x7FFFL);
            output[outputOffset + 2] = (int)(v0 >>> 30 & 0x7FFFL);
            output[outputOffset + 3] = (int)(v0 >>> 45 & 0x7FFFL);
            output[outputOffset + 4] = (int)(v0 >>> 60 & 0xFL | ((long)v1 & 0x7FFL) << 4);
            output[outputOffset + 5] = (int)((long)(v1 >>> 11) & 0x7FFFL);
            output[outputOffset + 6] = (int)((long)(v1 >>> 26) & 0x3FL | ((long)v2 & 0x1FFL) << 6);
            output[outputOffset + 7] = (int)((long)(v2 >>> 9) & 0x7FL | ((long)v3 & 0xFFL) << 7);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker15.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker16
    implements IntBitUnpacker {
        private Unpacker16() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            output[outputOffset] = (int)(v0 & 0xFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 16 & 0xFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 32 & 0xFFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 48 & 0xFFFFL);
            output[outputOffset + 4] = (int)(v1 & 0xFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 16 & 0xFFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 32 & 0xFFFFL);
            output[outputOffset + 7] = (int)(v1 >>> 48 & 0xFFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker16.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker17
    implements IntBitUnpacker {
        private Unpacker17() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            byte v2 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 17 & 0x1FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 34 & 0x1FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 51 & 0x1FFFL | (v1 & 0xFL) << 13);
            output[outputOffset + 4] = (int)(v1 >>> 4 & 0x1FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 21 & 0x1FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 38 & 0x1FFFFL);
            output[outputOffset + 7] = (int)(v1 >>> 55 & 0x1FFL | ((long)v2 & 0xFFL) << 9);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker17.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker18
    implements IntBitUnpacker {
        private Unpacker18() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            short v2 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 18 & 0x3FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 36 & 0x3FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 54 & 0x3FFL | (v1 & 0xFFL) << 10);
            output[outputOffset + 4] = (int)(v1 >>> 8 & 0x3FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 26 & 0x3FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 44 & 0x3FFFFL);
            output[outputOffset + 7] = (int)(v1 >>> 62 & 3L | ((long)v2 & 0xFFFFL) << 2);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker18.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker19
    implements IntBitUnpacker {
        private Unpacker19() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            short v2 = input.readShort();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 19 & 0x7FFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 38 & 0x7FFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 57 & 0x7FL | (v1 & 0xFFFL) << 7);
            output[outputOffset + 4] = (int)(v1 >>> 12 & 0x7FFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 31 & 0x7FFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 50 & 0x3FFFL | ((long)v2 & 0x1FL) << 14);
            output[outputOffset + 7] = (int)((long)(v2 >>> 5) & 0x7FFL | ((long)v3 & 0xFFL) << 11);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker19.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker20
    implements IntBitUnpacker {
        private Unpacker20() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            output[outputOffset] = (int)(v0 & 0xFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 20 & 0xFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 40 & 0xFFFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 60 & 0xFL | (v1 & 0xFFFFL) << 4);
            output[outputOffset + 4] = (int)(v1 >>> 16 & 0xFFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 36 & 0xFFFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 56 & 0xFFL | ((long)v2 & 0xFFFL) << 8);
            output[outputOffset + 7] = (int)((long)(v2 >>> 12) & 0xFFFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker20.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker21
    implements IntBitUnpacker {
        private Unpacker21() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 21 & 0x1FFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 42 & 0x1FFFFFL);
            output[outputOffset + 3] = (int)(v0 >>> 63 & 1L | (v1 & 0xFFFFFL) << 1);
            output[outputOffset + 4] = (int)(v1 >>> 20 & 0x1FFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 41 & 0x1FFFFFL);
            output[outputOffset + 6] = (int)(v1 >>> 62 & 3L | ((long)v2 & 0x7FFFFL) << 2);
            output[outputOffset + 7] = (int)((long)(v2 >>> 19) & 0x1FFFL | ((long)v3 & 0xFFL) << 13);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker21.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker22
    implements IntBitUnpacker {
        private Unpacker22() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            short v3 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 22 & 0x3FFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 44 & 0xFFFFFL | (v1 & 3L) << 20);
            output[outputOffset + 3] = (int)(v1 >>> 2 & 0x3FFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 24 & 0x3FFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 46 & 0x3FFFFL | ((long)v2 & 0xFL) << 18);
            output[outputOffset + 6] = (int)((long)(v2 >>> 4) & 0x3FFFFFL);
            output[outputOffset + 7] = (int)((long)(v2 >>> 26) & 0x3FL | ((long)v3 & 0xFFFFL) << 6);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker22.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker23
    implements IntBitUnpacker {
        private Unpacker23() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            int v2 = input.readInt();
            short v3 = input.readShort();
            byte v4 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 23 & 0x7FFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 46 & 0x3FFFFL | (v1 & 0x1FL) << 18);
            output[outputOffset + 3] = (int)(v1 >>> 5 & 0x7FFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 28 & 0x7FFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 51 & 0x1FFFL | ((long)v2 & 0x3FFL) << 13);
            output[outputOffset + 6] = (int)((long)(v2 >>> 10) & 0x3FFFFFL | ((long)v3 & 1L) << 22);
            output[outputOffset + 7] = (int)((long)(v3 >>> 1) & 0x7FFFL | ((long)v4 & 0xFFL) << 15);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker23.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker24
    implements IntBitUnpacker {
        private Unpacker24() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            output[outputOffset] = (int)(v0 & 0xFFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 24 & 0xFFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 48 & 0xFFFFL | (v1 & 0xFFL) << 16);
            output[outputOffset + 3] = (int)(v1 >>> 8 & 0xFFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 32 & 0xFFFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 56 & 0xFFL | (v2 & 0xFFFFL) << 8);
            output[outputOffset + 6] = (int)(v2 >>> 16 & 0xFFFFFFL);
            output[outputOffset + 7] = (int)(v2 >>> 40 & 0xFFFFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker24.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker25
    implements IntBitUnpacker {
        private Unpacker25() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            byte v3 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 25 & 0x1FFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 50 & 0x3FFFL | (v1 & 0x7FFL) << 14);
            output[outputOffset + 3] = (int)(v1 >>> 11 & 0x1FFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 36 & 0x1FFFFFFL);
            output[outputOffset + 5] = (int)(v1 >>> 61 & 7L | (v2 & 0x3FFFFFL) << 3);
            output[outputOffset + 6] = (int)(v2 >>> 22 & 0x1FFFFFFL);
            output[outputOffset + 7] = (int)(v2 >>> 47 & 0x1FFFFL | ((long)v3 & 0xFFL) << 17);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker25.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker26
    implements IntBitUnpacker {
        private Unpacker26() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            short v3 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 26 & 0x3FFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 52 & 0xFFFL | (v1 & 0x3FFFL) << 12);
            output[outputOffset + 3] = (int)(v1 >>> 14 & 0x3FFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 40 & 0xFFFFFFL | (v2 & 3L) << 24);
            output[outputOffset + 5] = (int)(v2 >>> 2 & 0x3FFFFFFL);
            output[outputOffset + 6] = (int)(v2 >>> 28 & 0x3FFFFFFL);
            output[outputOffset + 7] = (int)(v2 >>> 54 & 0x3FFL | ((long)v3 & 0xFFFFL) << 10);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker26.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker27
    implements IntBitUnpacker {
        private Unpacker27() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            short v3 = input.readShort();
            byte v4 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x7FFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 27 & 0x7FFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 54 & 0x3FFL | (v1 & 0x1FFFFL) << 10);
            output[outputOffset + 3] = (int)(v1 >>> 17 & 0x7FFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 44 & 0xFFFFFL | (v2 & 0x7FL) << 20);
            output[outputOffset + 5] = (int)(v2 >>> 7 & 0x7FFFFFFL);
            output[outputOffset + 6] = (int)(v2 >>> 34 & 0x7FFFFFFL);
            output[outputOffset + 7] = (int)(v2 >>> 61 & 7L | ((long)v3 & 0xFFFFL) << 3 | ((long)v4 & 0xFFL) << 19);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker27.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker28
    implements IntBitUnpacker {
        private Unpacker28() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            output[outputOffset] = (int)(v0 & 0xFFFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 28 & 0xFFFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 56 & 0xFFL | (v1 & 0xFFFFFL) << 8);
            output[outputOffset + 3] = (int)(v1 >>> 20 & 0xFFFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 48 & 0xFFFFL | (v2 & 0xFFFL) << 16);
            output[outputOffset + 5] = (int)(v2 >>> 12 & 0xFFFFFFFL);
            output[outputOffset + 6] = (int)(v2 >>> 40 & 0xFFFFFFL | ((long)v3 & 0xFL) << 24);
            output[outputOffset + 7] = (int)((long)(v3 >>> 4) & 0xFFFFFFFL);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker28.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker29
    implements IntBitUnpacker {
        private Unpacker29() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            byte v4 = input.readByte();
            output[outputOffset] = (int)(v0 & 0x1FFFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 29 & 0x1FFFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 58 & 0x3FL | (v1 & 0x7FFFFFL) << 6);
            output[outputOffset + 3] = (int)(v1 >>> 23 & 0x1FFFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 52 & 0xFFFL | (v2 & 0x1FFFFL) << 12);
            output[outputOffset + 5] = (int)(v2 >>> 17 & 0x1FFFFFFFL);
            output[outputOffset + 6] = (int)(v2 >>> 46 & 0x3FFFFL | ((long)v3 & 0x7FFL) << 18);
            output[outputOffset + 7] = (int)((long)(v3 >>> 11) & 0x1FFFFFL | ((long)v4 & 0xFFL) << 21);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker29.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker30
    implements IntBitUnpacker {
        private Unpacker30() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            short v4 = input.readShort();
            output[outputOffset] = (int)(v0 & 0x3FFFFFFFL);
            output[outputOffset + 1] = (int)(v0 >>> 30 & 0x3FFFFFFFL);
            output[outputOffset + 2] = (int)(v0 >>> 60 & 0xFL | (v1 & 0x3FFFFFFL) << 4);
            output[outputOffset + 3] = (int)(v1 >>> 26 & 0x3FFFFFFFL);
            output[outputOffset + 4] = (int)(v1 >>> 56 & 0xFFL | (v2 & 0x3FFFFFL) << 8);
            output[outputOffset + 5] = (int)(v2 >>> 22 & 0x3FFFFFFFL);
            output[outputOffset + 6] = (int)(v2 >>> 52 & 0xFFFL | ((long)v3 & 0x3FFFFL) << 12);
            output[outputOffset + 7] = (int)((long)(v3 >>> 18) & 0x3FFFL | ((long)v4 & 0xFFFFL) << 14);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker30.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker31
    implements IntBitUnpacker {
        private Unpacker31() {
        }

        private static void unpack8(int[] output, int outputOffset, SimpleSliceInputStream input) {
            long v0 = input.readLong();
            long v1 = input.readLong();
            long v2 = input.readLong();
            int v3 = input.readInt();
            short v4 = input.readShort();
            byte v5 = input.readByte();
            output[outputOffset] = (int)(v0 & Integer.MAX_VALUE);
            output[outputOffset + 1] = (int)(v0 >>> 31 & Integer.MAX_VALUE);
            output[outputOffset + 2] = (int)(v0 >>> 62 & 3L | (v1 & 0x1FFFFFFFL) << 2);
            output[outputOffset + 3] = (int)(v1 >>> 29 & Integer.MAX_VALUE);
            output[outputOffset + 4] = (int)(v1 >>> 60 & 0xFL | (v2 & 0x7FFFFFFL) << 4);
            output[outputOffset + 5] = (int)(v2 >>> 27 & Integer.MAX_VALUE);
            output[outputOffset + 6] = (int)(v2 >>> 58 & 0x3FL | ((long)v3 & 0x1FFFFFFL) << 6);
            output[outputOffset + 7] = (int)((long)(v3 >>> 25) & 0x7FL | ((long)v4 & 0xFFFFL) << 7 | ((long)v5 & 0xFFL) << 23);
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            while (length >= 8) {
                Unpacker31.unpack8(output, outputOffset, input);
                outputOffset += 8;
                length -= 8;
            }
        }
    }

    private static final class Unpacker32
    implements IntBitUnpacker {
        private Unpacker32() {
        }

        @Override
        public void unpack(int[] output, int outputOffset, SimpleSliceInputStream input, int length) {
            input.readBytes(Slices.wrappedIntArray((int[])output, (int)outputOffset, (int)length), 0, length * 4);
        }
    }
}

