/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import io.trino.parquet.reader.FilteredRowRanges;
import io.trino.parquet.reader.flat.RowRangesIterator;
import java.util.Iterator;
import java.util.Objects;
import java.util.OptionalLong;

public class FilteredRowRangesIterator
implements RowRangesIterator {
    private final Iterator<FilteredRowRanges.RowRange> rowRangeIterator;
    private FilteredRowRanges.RowRange currentRange;
    private long pageFirstRowIndex = -1L;
    private int pageValuesConsumed;

    public FilteredRowRangesIterator(FilteredRowRanges rowRanges) {
        Objects.requireNonNull(rowRanges, "rowRanges is null");
        this.rowRangeIterator = rowRanges.getRowRanges().iterator();
        Preconditions.checkArgument((boolean)this.rowRangeIterator.hasNext(), (Object)"rowRanges is empty");
        this.nextRange();
    }

    @Override
    public int getRowsLeftInCurrentRange() {
        return Math.toIntExact(this.currentRange.end() - this.pageFirstRowIndex) - this.pageValuesConsumed + 1;
    }

    @Override
    public int advanceRange(int chunkSize) {
        Preconditions.checkState((this.pageFirstRowIndex >= 0L ? 1 : 0) != 0, (String)"pageFirstRowIndex %s cannot be negative", (long)this.pageFirstRowIndex);
        long rangeEnd = this.currentRange.end();
        int rowsLeftInRange = Math.toIntExact(rangeEnd - this.pageFirstRowIndex) - this.pageValuesConsumed + 1;
        if (rowsLeftInRange > chunkSize) {
            this.pageValuesConsumed += chunkSize;
            return chunkSize;
        }
        this.pageValuesConsumed += rowsLeftInRange;
        if (this.rowRangeIterator.hasNext()) {
            this.nextRange();
        } else {
            Preconditions.checkState((rowsLeftInRange == chunkSize ? 1 : 0) != 0, (String)"Reached end of filtered rowRanges with chunkSize %s, rowsLeftInRange %s, pageFirstRowIndex %s, pageValuesConsumed %s", (Object)chunkSize, (Object)rowsLeftInRange, (Object)this.pageFirstRowIndex, (Object)this.pageValuesConsumed);
        }
        return rowsLeftInRange;
    }

    @Override
    public int seekForward(int chunkSize) {
        Preconditions.checkState((this.pageFirstRowIndex >= 0L ? 1 : 0) != 0, (String)"pageFirstRowIndex %s cannot be negative", (long)this.pageFirstRowIndex);
        long currentIndex = this.pageFirstRowIndex + (long)this.pageValuesConsumed;
        int skippedInRange = 0;
        while (chunkSize > 0) {
            int stepSize;
            if (currentIndex < this.currentRange.start()) {
                stepSize = Math.min(chunkSize, Math.toIntExact(this.currentRange.start() - currentIndex));
                currentIndex += (long)stepSize;
                this.pageValuesConsumed += stepSize;
                chunkSize -= stepSize;
                continue;
            }
            if (currentIndex <= this.currentRange.end()) {
                stepSize = Math.min(chunkSize, Math.toIntExact(this.currentRange.end() - currentIndex) + 1);
                currentIndex += (long)stepSize;
                skippedInRange += stepSize;
                this.pageValuesConsumed += stepSize;
                chunkSize -= stepSize;
                continue;
            }
            Preconditions.checkState((boolean)this.rowRangeIterator.hasNext(), (String)"Reached end of filtered rowRanges with chunkSize %s, currentIndex %s, pageFirstRowIndex %s, pageValuesConsumed %s", (Object)chunkSize, (Object)currentIndex, (Object)this.pageFirstRowIndex, (Object)this.pageValuesConsumed);
            this.nextRange();
        }
        return skippedInRange;
    }

    @Override
    public long skipToRangeStart() {
        Preconditions.checkState((this.pageFirstRowIndex >= 0L ? 1 : 0) != 0, (String)"pageFirstRowIndex %s cannot be negative", (long)this.pageFirstRowIndex);
        long rangeStart = this.currentRange.start();
        long currentIndex = this.pageFirstRowIndex + (long)this.pageValuesConsumed;
        if (rangeStart <= currentIndex) {
            return 0L;
        }
        long skipCount = rangeStart - currentIndex;
        this.pageValuesConsumed = (int)((long)this.pageValuesConsumed + skipCount);
        return skipCount;
    }

    @Override
    public void resetForNewPage(OptionalLong firstRowIndex) {
        Preconditions.checkArgument((boolean)firstRowIndex.isPresent(), (Object)"Missing firstRowIndex for selecting rowRanges");
        Preconditions.checkArgument((firstRowIndex.getAsLong() >= 0L ? 1 : 0) != 0, (String)"firstRowIndex %s cannot be negative", (long)firstRowIndex.getAsLong());
        Preconditions.checkArgument((firstRowIndex.getAsLong() >= this.pageFirstRowIndex ? 1 : 0) != 0, (String)"firstRowIndex %s cannot be less than current pageFirstRowIndex %s", (long)firstRowIndex.getAsLong(), (long)this.pageFirstRowIndex);
        this.pageFirstRowIndex = firstRowIndex.getAsLong();
        this.pageValuesConsumed = 0;
        long rangeEnd = this.currentRange.end();
        if (this.pageFirstRowIndex > rangeEnd) {
            this.nextRange();
            rangeEnd = this.currentRange.end();
        }
        Verify.verify((this.pageFirstRowIndex <= rangeEnd ? 1 : 0) != 0);
    }

    @Override
    public boolean isPageFullyConsumed(int pageValueCount) {
        return this.pageFirstRowIndex >= this.currentRange.start() && this.pageFirstRowIndex + (long)pageValueCount <= this.currentRange.end() + 1L;
    }

    private void nextRange() {
        this.currentRange = this.rowRangeIterator.next();
    }
}

