/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.memory.context.AggregatedMemoryContext;
import io.trino.memory.context.LocalMemoryContext;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.reader.ColumnReader;
import io.trino.parquet.reader.NestedColumnReader;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.decoders.ValueDecoders;
import io.trino.parquet.reader.flat.BinaryColumnAdapter;
import io.trino.parquet.reader.flat.ByteColumnAdapter;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.parquet.reader.flat.DictionaryDecoder;
import io.trino.parquet.reader.flat.Fixed12ColumnAdapter;
import io.trino.parquet.reader.flat.FlatColumnReader;
import io.trino.parquet.reader.flat.FlatDefinitionLevelDecoder;
import io.trino.parquet.reader.flat.Int128ColumnAdapter;
import io.trino.parquet.reader.flat.IntColumnAdapter;
import io.trino.parquet.reader.flat.LongColumnAdapter;
import io.trino.parquet.reader.flat.ShortColumnAdapter;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.type.AbstractIntType;
import io.trino.spi.type.AbstractLongType;
import io.trino.spi.type.AbstractVariableWidthType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.UuidType;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public final class ColumnReaderFactory {
    private final DateTimeZone timeZone;

    public ColumnReaderFactory(DateTimeZone timeZone) {
        this.timeZone = Objects.requireNonNull(timeZone, "dateTimeZone is null");
    }

    public ColumnReader create(PrimitiveField field, AggregatedMemoryContext aggregatedMemoryContext) {
        Type type;
        block81: {
            ValueDecoders valueDecoders;
            LocalMemoryContext memoryContext;
            block82: {
                VarcharType varcharType;
                DecimalType decimalType;
                TimestampWithTimeZoneType timestampWithTimeZoneType;
                TimestampType timestampType;
                LogicalTypeAnnotation annotation;
                PrimitiveType.PrimitiveTypeName primitiveType;
                block79: {
                    block80: {
                        block76: {
                            block78: {
                                block77: {
                                    type = field.getType();
                                    primitiveType = field.getDescriptor().getPrimitiveType().getPrimitiveTypeName();
                                    annotation = field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
                                    memoryContext = aggregatedMemoryContext.newLocalMemoryContext(ColumnReader.class.getSimpleName());
                                    valueDecoders = new ValueDecoders(field);
                                    if (BooleanType.BOOLEAN.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.BOOLEAN) {
                                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getBooleanDecoder, ByteColumnAdapter.BYTE_ADAPTER, memoryContext);
                                    }
                                    if (TinyintType.TINYINT.equals((Object)type) && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                                        if (ColumnReaderFactory.isZeroScaleShortDecimalAnnotation(annotation)) {
                                            return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecimalToByteDecoder, ByteColumnAdapter.BYTE_ADAPTER, memoryContext);
                                        }
                                        if (!ColumnReaderFactory.isIntegerAnnotationAndPrimitive(annotation, primitiveType)) {
                                            throw ColumnReaderFactory.unsupportedException(type, field);
                                        }
                                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getByteDecoder, ByteColumnAdapter.BYTE_ADAPTER, memoryContext);
                                    }
                                    if (SmallintType.SMALLINT.equals((Object)type) && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                                        if (ColumnReaderFactory.isZeroScaleShortDecimalAnnotation(annotation)) {
                                            return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecimalToShortDecoder, ShortColumnAdapter.SHORT_ADAPTER, memoryContext);
                                        }
                                        if (!ColumnReaderFactory.isIntegerAnnotationAndPrimitive(annotation, primitiveType)) {
                                            throw ColumnReaderFactory.unsupportedException(type, field);
                                        }
                                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecoder, ShortColumnAdapter.SHORT_ADAPTER, memoryContext);
                                    }
                                    if (!DateType.DATE.equals((Object)type) || primitiveType != PrimitiveType.PrimitiveTypeName.INT32) break block76;
                                    if (annotation == null) break block77;
                                    if (!(annotation instanceof LogicalTypeAnnotation.DateLogicalTypeAnnotation)) break block78;
                                }
                                return ColumnReaderFactory.createColumnReader(field, valueDecoders::getIntDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                            }
                            throw ColumnReaderFactory.unsupportedException(type, field);
                        }
                        if (type instanceof AbstractIntType && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                            if (ColumnReaderFactory.isZeroScaleShortDecimalAnnotation(annotation)) {
                                return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecimalToIntDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                            }
                            if (!ColumnReaderFactory.isIntegerAnnotationAndPrimitive(annotation, primitiveType)) {
                                throw ColumnReaderFactory.unsupportedException(type, field);
                            }
                            return ColumnReaderFactory.createColumnReader(field, valueDecoders::getIntDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                        }
                        if (type instanceof TimeType) {
                            if (!(annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation)) {
                                throw ColumnReaderFactory.unsupportedException(type, field);
                            }
                            LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeAnnotation = (LogicalTypeAnnotation.TimeLogicalTypeAnnotation)annotation;
                            if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64 && timeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MICROS) {
                                return ColumnReaderFactory.createColumnReader(field, valueDecoders::getTimeMicrosDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            }
                            if (primitiveType == PrimitiveType.PrimitiveTypeName.INT32 && timeAnnotation.getUnit() == LogicalTypeAnnotation.TimeUnit.MILLIS) {
                                return ColumnReaderFactory.createColumnReader(field, valueDecoders::getTimeMillisDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            }
                            throw ColumnReaderFactory.unsupportedException(type, field);
                        }
                        if (!BigintType.BIGINT.equals((Object)type) || primitiveType != PrimitiveType.PrimitiveTypeName.INT64) break block79;
                        if (annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation) break block80;
                        if (!(annotation instanceof LogicalTypeAnnotation.TimeLogicalTypeAnnotation)) break block79;
                    }
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                if (type instanceof AbstractLongType && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                    if (ColumnReaderFactory.isZeroScaleShortDecimalAnnotation(annotation)) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecimalDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    if (!ColumnReaderFactory.isIntegerAnnotationAndPrimitive(annotation, primitiveType)) {
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT32) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt32ToLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getLongDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                }
                if (RealType.REAL.equals((Object)type) && primitiveType == PrimitiveType.PrimitiveTypeName.FLOAT) {
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getRealDecoder, IntColumnAdapter.INT_ADAPTER, memoryContext);
                }
                if (DoubleType.DOUBLE.equals((Object)type)) {
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.DOUBLE) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getDoubleDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.FLOAT) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getFloatToDoubleDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                }
                if (type instanceof TimestampType) {
                    timestampType = (TimestampType)type;
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT96) {
                        if (timestampType.isShort()) {
                            return ColumnReaderFactory.createColumnReader(field, encoding -> valueDecoders.getInt96ToShortTimestampDecoder(encoding, this.timeZone), LongColumnAdapter.LONG_ADAPTER, memoryContext);
                        }
                        return ColumnReaderFactory.createColumnReader(field, encoding -> valueDecoders.getInt96ToLongTimestampDecoder(encoding, this.timeZone), Fixed12ColumnAdapter.FIXED12_ADAPTER, memoryContext);
                    }
                }
                if (type instanceof TimestampWithTimeZoneType) {
                    timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT96) {
                        if (timestampWithTimeZoneType.isShort()) {
                            return ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt96ToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                        }
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                }
                if (type instanceof TimestampType) {
                    timestampType = (TimestampType)type;
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                        if (!(annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                            throw ColumnReaderFactory.unsupportedException(type, field);
                        }
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
                        if (timestampType.isShort()) {
                            return switch (timestampAnnotation.getUnit()) {
                                default -> throw new IncompatibleClassChangeError();
                                case LogicalTypeAnnotation.TimeUnit.MILLIS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMillsToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                                case LogicalTypeAnnotation.TimeUnit.MICROS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMicrosToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                                case LogicalTypeAnnotation.TimeUnit.NANOS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampNanosToShortTimestampDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                            };
                        }
                        return switch (timestampAnnotation.getUnit()) {
                            default -> throw new IncompatibleClassChangeError();
                            case LogicalTypeAnnotation.TimeUnit.MILLIS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMillisToLongTimestampDecoder, Fixed12ColumnAdapter.FIXED12_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.MICROS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMicrosToLongTimestampDecoder, Fixed12ColumnAdapter.FIXED12_ADAPTER, memoryContext);
                            case LogicalTypeAnnotation.TimeUnit.NANOS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampNanosToLongTimestampDecoder, Fixed12ColumnAdapter.FIXED12_ADAPTER, memoryContext);
                        };
                    }
                }
                if (type instanceof TimestampWithTimeZoneType) {
                    timestampWithTimeZoneType = (TimestampWithTimeZoneType)type;
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT64) {
                        if (!(annotation instanceof LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)) {
                            throw ColumnReaderFactory.unsupportedException(type, field);
                        }
                        LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampAnnotation = (LogicalTypeAnnotation.TimestampLogicalTypeAnnotation)annotation;
                        if (timestampWithTimeZoneType.isShort()) {
                            return switch (timestampAnnotation.getUnit()) {
                                default -> throw new IncompatibleClassChangeError();
                                case LogicalTypeAnnotation.TimeUnit.MILLIS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMillsToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                                case LogicalTypeAnnotation.TimeUnit.MICROS -> ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMicrosToShortTimestampWithTimeZoneDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                                case LogicalTypeAnnotation.TimeUnit.NANOS -> throw ColumnReaderFactory.unsupportedException(type, field);
                            };
                        }
                        switch (timestampAnnotation.getUnit()) {
                            default: {
                                throw new IncompatibleClassChangeError();
                            }
                            case MILLIS: 
                            case NANOS: {
                                throw ColumnReaderFactory.unsupportedException(type, field);
                            }
                            case MICROS: 
                        }
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt64TimestampMicrosToLongTimestampWithTimeZoneDecoder, Fixed12ColumnAdapter.FIXED12_ADAPTER, memoryContext);
                    }
                }
                if (type instanceof DecimalType && (decimalType = (DecimalType)type).isShort() && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                    if (primitiveType == PrimitiveType.PrimitiveTypeName.INT32 && ColumnReaderFactory.isIntegerAnnotation(annotation)) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getInt32ToShortDecimalDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    if (!(annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation;
                    if (ColumnReaderFactory.isDecimalRescaled(decimalAnnotation, decimalType)) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getRescaledShortDecimalDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                    }
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getShortDecimalDecoder, LongColumnAdapter.LONG_ADAPTER, memoryContext);
                }
                if (type instanceof DecimalType && !(decimalType = (DecimalType)type).isShort() && ColumnReaderFactory.isIntegerOrDecimalPrimitive(primitiveType)) {
                    if (!(annotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)) {
                        throw ColumnReaderFactory.unsupportedException(type, field);
                    }
                    LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)annotation;
                    if (ColumnReaderFactory.isDecimalRescaled(decimalAnnotation, decimalType)) {
                        return ColumnReaderFactory.createColumnReader(field, valueDecoders::getRescaledLongDecimalDecoder, Int128ColumnAdapter.INT128_ADAPTER, memoryContext);
                    }
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getLongDecimalDecoder, Int128ColumnAdapter.INT128_ADAPTER, memoryContext);
                }
                if (type instanceof VarcharType && !(varcharType = (VarcharType)type).isUnbounded() && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getBoundedVarcharBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
                }
                if (type instanceof CharType && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getCharBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
                }
                if (type instanceof AbstractVariableWidthType && primitiveType == PrimitiveType.PrimitiveTypeName.BINARY) {
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
                }
                if ((VarbinaryType.VARBINARY.equals((Object)type) || VarcharType.VARCHAR.equals((Object)type)) && primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) {
                    return ColumnReaderFactory.createColumnReader(field, valueDecoders::getFixedWidthBinaryDecoder, BinaryColumnAdapter.BINARY_ADAPTER, memoryContext);
                }
                if (!UuidType.UUID.equals((Object)type) || primitiveType != PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY) break block81;
                if (annotation == null) break block82;
                if (!ColumnReaderFactory.isLogicalUuid(annotation)) break block81;
            }
            return ColumnReaderFactory.createColumnReader(field, valueDecoders::getUuidDecoder, Int128ColumnAdapter.INT128_ADAPTER, memoryContext);
        }
        throw ColumnReaderFactory.unsupportedException(type, field);
    }

    private static <T> ColumnReader createColumnReader(PrimitiveField field, ValueDecoder.ValueDecodersProvider<T> decodersProvider, ColumnAdapter<T> columnAdapter, LocalMemoryContext memoryContext) {
        DictionaryDecoder.DictionaryDecoderProvider dictionaryDecoderProvider = (dictionaryPage, isNonNull) -> DictionaryDecoder.getDictionaryDecoder(dictionaryPage, columnAdapter, decodersProvider.create(ParquetEncoding.PLAIN), isNonNull);
        if (ColumnReaderFactory.isFlatColumn(field)) {
            return new FlatColumnReader<T>(field, decodersProvider, FlatDefinitionLevelDecoder::getFlatDefinitionLevelDecoder, dictionaryDecoderProvider, columnAdapter, memoryContext);
        }
        return new NestedColumnReader<T>(field, decodersProvider, ValueDecoder::createLevelsDecoder, dictionaryDecoderProvider, columnAdapter, memoryContext);
    }

    private static boolean isFlatColumn(PrimitiveField field) {
        return field.getDescriptor().getPath().length == 1;
    }

    private static boolean isLogicalUuid(LogicalTypeAnnotation annotation) {
        return Optional.ofNullable(annotation).flatMap(logicalTypeAnnotation -> logicalTypeAnnotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
                return Optional.of(Boolean.TRUE);
            }
        })).orElse(Boolean.FALSE);
    }

    private static boolean isDecimalRescaled(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation, DecimalType trinoType) {
        return decimalAnnotation.getPrecision() != trinoType.getPrecision() || decimalAnnotation.getScale() != trinoType.getScale();
    }

    private static boolean isIntegerAnnotation(LogicalTypeAnnotation typeAnnotation) {
        return typeAnnotation == null || typeAnnotation instanceof LogicalTypeAnnotation.IntLogicalTypeAnnotation;
    }

    private static boolean isZeroScaleShortDecimalAnnotation(LogicalTypeAnnotation typeAnnotation) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
        return typeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)typeAnnotation).getScale() == 0 && decimalAnnotation.getPrecision() <= 18;
    }

    private static boolean isIntegerOrDecimalPrimitive(PrimitiveType.PrimitiveTypeName primitiveType) {
        return primitiveType == PrimitiveType.PrimitiveTypeName.INT32 || primitiveType == PrimitiveType.PrimitiveTypeName.INT64 || primitiveType == PrimitiveType.PrimitiveTypeName.BINARY || primitiveType == PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
    }

    private static boolean isIntegerAnnotationAndPrimitive(LogicalTypeAnnotation typeAnnotation, PrimitiveType.PrimitiveTypeName primitiveType) {
        return ColumnReaderFactory.isIntegerAnnotation(typeAnnotation) && (primitiveType == PrimitiveType.PrimitiveTypeName.INT32 || primitiveType == PrimitiveType.PrimitiveTypeName.INT64);
    }

    private static TrinoException unsupportedException(Type type, PrimitiveField field) {
        return new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported Trino column type (%s) for Parquet column (%s)", type, field.getDescriptor()));
    }
}

