/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.trino.parquet.Field;
import io.trino.parquet.ParquetTypeUtils;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import java.util.Optional;

public final class StructColumnReader {
    private StructColumnReader() {
    }

    public static RowBlockPositions calculateStructOffsets(Field field, int[] fieldDefinitionLevels, int[] fieldRepetitionLevels) {
        int maxDefinitionLevel = field.getDefinitionLevel();
        int maxRepetitionLevel = field.getRepetitionLevel();
        boolean required = field.isRequired();
        if (required) {
            int definedValuesCount = 0;
            for (int i = 0; i < fieldDefinitionLevels.length; ++i) {
                if (fieldRepetitionLevels[i] > maxRepetitionLevel || fieldDefinitionLevels[i] < maxDefinitionLevel) continue;
                ++definedValuesCount;
            }
            return new RowBlockPositions(Optional.empty(), definedValuesCount);
        }
        int nullValuesCount = 0;
        BooleanArrayList structIsNull = new BooleanArrayList();
        for (int i = 0; i < fieldDefinitionLevels.length; ++i) {
            if (fieldRepetitionLevels[i] > maxRepetitionLevel) continue;
            if (ParquetTypeUtils.isOptionalFieldValueNull(fieldDefinitionLevels[i], maxDefinitionLevel)) {
                structIsNull.add(true);
                ++nullValuesCount;
                continue;
            }
            if (fieldDefinitionLevels[i] < maxDefinitionLevel) continue;
            structIsNull.add(false);
        }
        if (nullValuesCount == 0) {
            return new RowBlockPositions(Optional.empty(), structIsNull.size());
        }
        return new RowBlockPositions(Optional.of(structIsNull.elements()), structIsNull.size());
    }

    public record RowBlockPositions(Optional<boolean[]> isNull, int positionsCount) {
    }
}

