/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;

class FilteredOffsetIndex
implements OffsetIndex {
    private final OffsetIndex offsetIndex;
    private final int[] indexMap;

    public static FilteredOffsetIndex filterOffsetIndex(OffsetIndex offsetIndex, RowRanges rowRanges, long totalRowCount) {
        IntArrayList indexMap = new IntArrayList();
        int n = offsetIndex.getPageCount();
        for (int i = 0; i < n; ++i) {
            long from = offsetIndex.getFirstRowIndex(i);
            if (!rowRanges.isOverlapping(from, offsetIndex.getLastRowIndex(i, totalRowCount))) continue;
            indexMap.add(i);
        }
        return new FilteredOffsetIndex(offsetIndex, indexMap.toIntArray());
    }

    private FilteredOffsetIndex(OffsetIndex offsetIndex, int[] indexMap) {
        this.offsetIndex = offsetIndex;
        this.indexMap = indexMap;
    }

    public int getPageCount() {
        return this.indexMap.length;
    }

    public long getOffset(int pageIndex) {
        return this.offsetIndex.getOffset(this.indexMap[pageIndex]);
    }

    public int getCompressedPageSize(int pageIndex) {
        return this.offsetIndex.getCompressedPageSize(this.indexMap[pageIndex]);
    }

    public long getFirstRowIndex(int pageIndex) {
        return this.offsetIndex.getFirstRowIndex(this.indexMap[pageIndex]);
    }

    public long getLastRowIndex(int pageIndex, long totalRowCount) {
        int nextIndex = this.indexMap[pageIndex] + 1;
        return (nextIndex >= this.offsetIndex.getPageCount() ? totalRowCount : this.offsetIndex.getFirstRowIndex(nextIndex)) - 1L;
    }

    public String toString() {
        try (Formatter formatter = new Formatter();){
            formatter.format("%-12s  %20s  %16s  %20s\n", "", "offset", "compressed size", "first row index");
            int n = this.offsetIndex.getPageCount();
            for (int i = 0; i < n; ++i) {
                int index = Arrays.binarySearch(this.indexMap, i);
                boolean isHidden = index < 0;
                formatter.format("%spage-%-5d  %20d  %16d  %20d\n", isHidden ? "- " : "  ", isHidden ? i : index, this.offsetIndex.getOffset(i), this.offsetIndex.getCompressedPageSize(i), this.offsetIndex.getFirstRowIndex(i));
            }
            String string = formatter.toString();
            return string;
        }
    }

    public List<OffsetRange> calculateOffsetRanges(long rowGroupOffset) {
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        int pageCount = this.getPageCount();
        if (pageCount > 0) {
            long firstPageOffset = this.offsetIndex.getOffset(0);
            if (rowGroupOffset < firstPageOffset) {
                ranges.add(new OffsetRange(rowGroupOffset, firstPageOffset - rowGroupOffset));
            }
            long currentOffset = this.getOffset(0);
            long currentLength = this.getCompressedPageSize(0);
            for (int i = 1; i < pageCount; ++i) {
                long offset = this.getOffset(i);
                int length = this.getCompressedPageSize(i);
                if (currentOffset + currentLength == offset) {
                    currentLength += (long)length;
                    continue;
                }
                ranges.add(new OffsetRange(currentOffset, currentLength));
                currentOffset = offset;
                currentLength = length;
            }
            ranges.add(new OffsetRange(currentOffset, currentLength));
        }
        return ranges;
    }

    public static class OffsetRange {
        private final long offset;
        private final long length;

        public OffsetRange(long offset, long length) {
            this.offset = offset;
            this.length = length;
        }

        long getOffset() {
            return this.offset;
        }

        long getLength() {
            return this.length;
        }
    }
}

