/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import io.trino.parquet.writer.ColumnChunk;
import io.trino.parquet.writer.ParquetDataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import org.apache.parquet.format.ColumnMetaData;

public interface ColumnWriter {
    public void writeBlock(ColumnChunk var1) throws IOException;

    public void close();

    public List<BufferData> getBuffer() throws IOException;

    public long getBufferedBytes();

    public long getRetainedBytes();

    public static class BufferData {
        private final ColumnMetaData metaData;
        private final List<ParquetDataOutput> data;
        private final OptionalInt dictionaryPageSize;

        public BufferData(List<ParquetDataOutput> data, OptionalInt dictionaryPageSize, ColumnMetaData metaData) {
            this.data = Objects.requireNonNull(data, "data is null");
            this.dictionaryPageSize = Objects.requireNonNull(dictionaryPageSize, "dictionaryPageSize is null");
            this.metaData = Objects.requireNonNull(metaData, "metaData is null");
        }

        public ColumnMetaData getMetaData() {
            return this.metaData;
        }

        public List<ParquetDataOutput> getData() {
            return this.data;
        }

        public OptionalInt getDictionaryPageSize() {
            return this.dictionaryPageSize;
        }
    }
}

