/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet;

import io.trino.parquet.metadata.IndexReference;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.BsonType;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.DateType;
import org.apache.parquet.format.DecimalType;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.EnumType;
import org.apache.parquet.format.IntType;
import org.apache.parquet.format.JsonType;
import org.apache.parquet.format.ListType;
import org.apache.parquet.format.LogicalType;
import org.apache.parquet.format.MapType;
import org.apache.parquet.format.MicroSeconds;
import org.apache.parquet.format.MilliSeconds;
import org.apache.parquet.format.NanoSeconds;
import org.apache.parquet.format.NullType;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.PageEncodingStats;
import org.apache.parquet.format.PageLocation;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.StringType;
import org.apache.parquet.format.TimeType;
import org.apache.parquet.format.TimeUnit;
import org.apache.parquet.format.TimestampType;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.UUIDType;
import org.apache.parquet.internal.column.columnindex.BinaryTruncator;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.ColumnOrder;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetMetadataConverter {
    public static final long MAX_STATS_SIZE = 4096L;

    private ParquetMetadataConverter() {
    }

    public static LogicalTypeAnnotation getLogicalTypeAnnotation(ConvertedType type, SchemaElement element) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case ConvertedType.UTF8 -> LogicalTypeAnnotation.stringType();
            case ConvertedType.MAP -> LogicalTypeAnnotation.mapType();
            case ConvertedType.MAP_KEY_VALUE -> LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance();
            case ConvertedType.LIST -> LogicalTypeAnnotation.listType();
            case ConvertedType.ENUM -> LogicalTypeAnnotation.enumType();
            case ConvertedType.DECIMAL -> {
                int scale = element == null ? 0 : element.scale;
                int precision = element == null ? 0 : element.precision;
                yield LogicalTypeAnnotation.decimalType((int)scale, (int)precision);
            }
            case ConvertedType.DATE -> LogicalTypeAnnotation.dateType();
            case ConvertedType.TIME_MILLIS -> LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            case ConvertedType.TIME_MICROS -> LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            case ConvertedType.TIMESTAMP_MILLIS -> LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS);
            case ConvertedType.TIMESTAMP_MICROS -> LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS);
            case ConvertedType.INTERVAL -> LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance();
            case ConvertedType.INT_8 -> LogicalTypeAnnotation.intType((int)8, (boolean)true);
            case ConvertedType.INT_16 -> LogicalTypeAnnotation.intType((int)16, (boolean)true);
            case ConvertedType.INT_32 -> LogicalTypeAnnotation.intType((int)32, (boolean)true);
            case ConvertedType.INT_64 -> LogicalTypeAnnotation.intType((int)64, (boolean)true);
            case ConvertedType.UINT_8 -> LogicalTypeAnnotation.intType((int)8, (boolean)false);
            case ConvertedType.UINT_16 -> LogicalTypeAnnotation.intType((int)16, (boolean)false);
            case ConvertedType.UINT_32 -> LogicalTypeAnnotation.intType((int)32, (boolean)false);
            case ConvertedType.UINT_64 -> LogicalTypeAnnotation.intType((int)64, (boolean)false);
            case ConvertedType.JSON -> LogicalTypeAnnotation.jsonType();
            case ConvertedType.BSON -> LogicalTypeAnnotation.bsonType();
        };
    }

    public static LogicalTypeAnnotation getLogicalTypeAnnotation(LogicalType type) {
        return switch ((LogicalType._Fields)type.getSetField()) {
            default -> throw new MatchException(null, null);
            case LogicalType._Fields.MAP -> LogicalTypeAnnotation.mapType();
            case LogicalType._Fields.BSON -> LogicalTypeAnnotation.bsonType();
            case LogicalType._Fields.DATE -> LogicalTypeAnnotation.dateType();
            case LogicalType._Fields.ENUM -> LogicalTypeAnnotation.enumType();
            case LogicalType._Fields.JSON -> LogicalTypeAnnotation.jsonType();
            case LogicalType._Fields.LIST -> LogicalTypeAnnotation.listType();
            case LogicalType._Fields.TIME -> {
                TimeType time = type.getTIME();
                yield LogicalTypeAnnotation.timeType((boolean)time.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)ParquetMetadataConverter.convertTimeUnit(time.unit));
            }
            case LogicalType._Fields.STRING -> LogicalTypeAnnotation.stringType();
            case LogicalType._Fields.DECIMAL -> {
                DecimalType decimal = type.getDECIMAL();
                yield LogicalTypeAnnotation.decimalType((int)decimal.scale, (int)decimal.precision);
            }
            case LogicalType._Fields.INTEGER -> {
                IntType integer = type.getINTEGER();
                yield LogicalTypeAnnotation.intType((int)integer.bitWidth, (boolean)integer.isSigned);
            }
            case LogicalType._Fields.UNKNOWN -> null;
            case LogicalType._Fields.TIMESTAMP -> {
                TimestampType timestamp = type.getTIMESTAMP();
                yield LogicalTypeAnnotation.timestampType((boolean)timestamp.isAdjustedToUTC, (LogicalTypeAnnotation.TimeUnit)ParquetMetadataConverter.convertTimeUnit(timestamp.unit));
            }
            case LogicalType._Fields.UUID -> LogicalTypeAnnotation.uuidType();
        };
    }

    public static LogicalType convertToLogicalType(LogicalTypeAnnotation annotation) {
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeConverterVisitor()).orElse(null);
    }

    public static PrimitiveType.PrimitiveTypeName getPrimitive(Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Type.BYTE_ARRAY -> PrimitiveType.PrimitiveTypeName.BINARY;
            case Type.INT64 -> PrimitiveType.PrimitiveTypeName.INT64;
            case Type.INT32 -> PrimitiveType.PrimitiveTypeName.INT32;
            case Type.BOOLEAN -> PrimitiveType.PrimitiveTypeName.BOOLEAN;
            case Type.FLOAT -> PrimitiveType.PrimitiveTypeName.FLOAT;
            case Type.DOUBLE -> PrimitiveType.PrimitiveTypeName.DOUBLE;
            case Type.INT96 -> PrimitiveType.PrimitiveTypeName.INT96;
            case Type.FIXED_LEN_BYTE_ARRAY -> PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
        };
    }

    public static Encoding getEncoding(org.apache.parquet.column.Encoding encoding) {
        return Encoding.valueOf((String)encoding.name());
    }

    public static org.apache.parquet.column.Encoding getEncoding(Encoding encoding) {
        return org.apache.parquet.column.Encoding.valueOf((String)encoding.name());
    }

    public static EncodingStats convertEncodingStats(List<PageEncodingStats> stats) {
        if (stats == null) {
            return null;
        }
        EncodingStats.Builder builder = new EncodingStats.Builder();
        for (PageEncodingStats stat : stats) {
            switch (stat.getPage_type()) {
                case DATA_PAGE_V2: {
                    builder.withV2Pages();
                }
                case DATA_PAGE: {
                    builder.addDataEncoding(ParquetMetadataConverter.getEncoding(stat.getEncoding()), stat.getCount());
                    break;
                }
                case DICTIONARY_PAGE: {
                    builder.addDictEncoding(ParquetMetadataConverter.getEncoding(stat.getEncoding()), stat.getCount());
                    break;
                }
            }
        }
        return builder.build();
    }

    public static org.apache.parquet.internal.column.columnindex.ColumnIndex fromParquetColumnIndex(PrimitiveType type, ColumnIndex parquetColumnIndex) {
        if (!ParquetMetadataConverter.isMinMaxStatsSupported(type)) {
            return null;
        }
        return ColumnIndexBuilder.build((PrimitiveType)type, (BoundaryOrder)ParquetMetadataConverter.fromParquetBoundaryOrder(parquetColumnIndex.getBoundary_order()), (List)parquetColumnIndex.getNull_pages(), (List)parquetColumnIndex.getNull_counts(), (List)parquetColumnIndex.getMin_values(), (List)parquetColumnIndex.getMax_values());
    }

    public static org.apache.parquet.internal.column.columnindex.OffsetIndex fromParquetOffsetIndex(OffsetIndex parquetOffsetIndex) {
        OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
        for (PageLocation pageLocation : parquetOffsetIndex.getPage_locations()) {
            builder.add(pageLocation.getOffset(), pageLocation.getCompressed_page_size(), pageLocation.getFirst_row_index());
        }
        return builder.build();
    }

    public static boolean isMinMaxStatsSupported(PrimitiveType type) {
        return type.columnOrder().getColumnOrderName() == ColumnOrder.ColumnOrderName.TYPE_DEFINED_ORDER;
    }

    public static org.apache.parquet.format.Statistics toParquetStatistics(Statistics<?> stats) {
        return ParquetMetadataConverter.toParquetStatistics(stats, Integer.MAX_VALUE);
    }

    public static org.apache.parquet.format.Statistics toParquetStatistics(Statistics<?> stats, int truncateLength) {
        org.apache.parquet.format.Statistics formatStats = new org.apache.parquet.format.Statistics();
        if (!stats.isEmpty() && ParquetMetadataConverter.withinLimit(stats, truncateLength)) {
            formatStats.setNull_count(stats.getNumNulls());
            if (stats.hasNonNullValue()) {
                byte[] max;
                byte[] min;
                if (stats instanceof BinaryStatistics && truncateLength != Integer.MAX_VALUE) {
                    BinaryTruncator truncator = BinaryTruncator.getTruncator((PrimitiveType)stats.type());
                    min = ParquetMetadataConverter.tuncateMin(truncator, truncateLength, stats.getMinBytes());
                    max = ParquetMetadataConverter.tuncateMax(truncator, truncateLength, stats.getMaxBytes());
                } else {
                    min = stats.getMinBytes();
                    max = stats.getMaxBytes();
                }
                if (ParquetMetadataConverter.sortOrder(stats.type()) == SortOrder.SIGNED || Arrays.equals(min, max)) {
                    formatStats.setMin(min);
                    formatStats.setMax(max);
                }
                if (ParquetMetadataConverter.isMinMaxStatsSupported(stats.type()) || Arrays.equals(min, max)) {
                    formatStats.setMin_value(min);
                    formatStats.setMax_value(max);
                }
            }
        }
        return formatStats;
    }

    public static Statistics<?> fromParquetStatistics(String createdBy, org.apache.parquet.format.Statistics statistics, PrimitiveType type) {
        Statistics.Builder statsBuilder = Statistics.getBuilderForReading((PrimitiveType)type);
        if (statistics != null) {
            if (statistics.isSetMin_value() && statistics.isSetMax_value()) {
                byte[] min = statistics.min_value.array();
                byte[] max = statistics.max_value.array();
                if (ParquetMetadataConverter.isMinMaxStatsSupported(type) || Arrays.equals(min, max)) {
                    statsBuilder.withMin(min);
                    statsBuilder.withMax(max);
                }
            } else {
                boolean sortOrdersMatch;
                boolean isSet = statistics.isSetMax() && statistics.isSetMin();
                boolean maxEqualsMin = isSet && Arrays.equals(statistics.getMin(), statistics.getMax());
                boolean bl = sortOrdersMatch = SortOrder.SIGNED == ParquetMetadataConverter.sortOrder(type);
                if (isSet && !CorruptStatistics.shouldIgnoreStatistics((String)createdBy, (PrimitiveType.PrimitiveTypeName)type.getPrimitiveTypeName()) && (sortOrdersMatch || maxEqualsMin)) {
                    statsBuilder.withMin(statistics.min.array());
                    statsBuilder.withMax(statistics.max.array());
                }
            }
            if (statistics.isSetNull_count()) {
                statsBuilder.withNumNulls(statistics.null_count);
            }
        }
        return statsBuilder.build();
    }

    public static IndexReference toColumnIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetColumn_index_offset() && columnChunk.isSetColumn_index_length()) {
            return new IndexReference(columnChunk.getColumn_index_offset(), columnChunk.getColumn_index_length());
        }
        return null;
    }

    public static IndexReference toOffsetIndexReference(ColumnChunk columnChunk) {
        if (columnChunk.isSetOffset_index_offset() && columnChunk.isSetOffset_index_length()) {
            return new IndexReference(columnChunk.getOffset_index_offset(), columnChunk.getOffset_index_length());
        }
        return null;
    }

    private static SortOrder sortOrder(PrimitiveType primitive) {
        LogicalTypeAnnotation annotation = primitive.getLogicalTypeAnnotation();
        if (annotation == null) {
            return ParquetMetadataConverter.defaultSortOrder(primitive.getPrimitiveTypeName());
        }
        return annotation.accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new SortOrderVisitor()).orElse(ParquetMetadataConverter.defaultSortOrder(primitive.getPrimitiveTypeName()));
    }

    private static SortOrder defaultSortOrder(PrimitiveType.PrimitiveTypeName primitive) {
        return switch (primitive) {
            case PrimitiveType.PrimitiveTypeName.BOOLEAN, PrimitiveType.PrimitiveTypeName.INT32, PrimitiveType.PrimitiveTypeName.INT64, PrimitiveType.PrimitiveTypeName.FLOAT, PrimitiveType.PrimitiveTypeName.DOUBLE -> SortOrder.SIGNED;
            case PrimitiveType.PrimitiveTypeName.BINARY, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> SortOrder.UNSIGNED;
            default -> SortOrder.UNKNOWN;
        };
    }

    private static LogicalTypeAnnotation.TimeUnit convertTimeUnit(TimeUnit unit) {
        return switch ((TimeUnit._Fields)unit.getSetField()) {
            default -> throw new MatchException(null, null);
            case TimeUnit._Fields.MICROS -> LogicalTypeAnnotation.TimeUnit.MICROS;
            case TimeUnit._Fields.MILLIS -> LogicalTypeAnnotation.TimeUnit.MILLIS;
            case TimeUnit._Fields.NANOS -> LogicalTypeAnnotation.TimeUnit.NANOS;
        };
    }

    private static BoundaryOrder fromParquetBoundaryOrder(org.apache.parquet.format.BoundaryOrder boundaryOrder) {
        return switch (boundaryOrder) {
            default -> throw new MatchException(null, null);
            case org.apache.parquet.format.BoundaryOrder.ASCENDING -> BoundaryOrder.ASCENDING;
            case org.apache.parquet.format.BoundaryOrder.DESCENDING -> BoundaryOrder.DESCENDING;
            case org.apache.parquet.format.BoundaryOrder.UNORDERED -> BoundaryOrder.UNORDERED;
        };
    }

    private static boolean withinLimit(Statistics<?> stats, int truncateLength) {
        BinaryStatistics binaryStats;
        if (stats.isSmallerThan(4096L)) {
            return true;
        }
        return stats instanceof BinaryStatistics && (binaryStats = (BinaryStatistics)stats).isSmallerThanWithTruncation(4096L, truncateLength);
    }

    private static byte[] tuncateMin(BinaryTruncator truncator, int truncateLength, byte[] input) {
        return truncator.truncateMin(Binary.fromConstantByteArray((byte[])input), truncateLength).getBytes();
    }

    private static byte[] tuncateMax(BinaryTruncator truncator, int truncateLength, byte[] input) {
        return truncator.truncateMax(Binary.fromConstantByteArray((byte[])input), truncateLength).getBytes();
    }

    private static class LogicalTypeConverterVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<LogicalType> {
        private LogicalTypeConverterVisitor() {
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.STRING((StringType)new StringType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.MAP((MapType)new MapType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.LIST((ListType)new ListType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.ENUM((EnumType)new EnumType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.DECIMAL((DecimalType)new DecimalType(type.getScale(), type.getPrecision())));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.DATE((DateType)new DateType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.TIME((TimeType)new TimeType(type.isAdjustedToUTC(), LogicalTypeConverterVisitor.convertUnit(type.getUnit()))));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.TIMESTAMP((TimestampType)new TimestampType(type.isAdjustedToUTC(), LogicalTypeConverterVisitor.convertUnit(type.getUnit()))));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.INTEGER((IntType)new IntType((byte)type.getBitWidth(), type.isSigned())));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.JSON((JsonType)new JsonType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.BSON((BsonType)new BsonType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.UUID((UUIDType)new UUIDType()));
        }

        public Optional<LogicalType> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation type) {
            return Optional.of(LogicalType.UNKNOWN((NullType)new NullType()));
        }

        static TimeUnit convertUnit(LogicalTypeAnnotation.TimeUnit unit) {
            return switch (unit) {
                default -> throw new MatchException(null, null);
                case LogicalTypeAnnotation.TimeUnit.MICROS -> TimeUnit.MICROS((MicroSeconds)new MicroSeconds());
                case LogicalTypeAnnotation.TimeUnit.MILLIS -> TimeUnit.MILLIS((MilliSeconds)new MilliSeconds());
                case LogicalTypeAnnotation.TimeUnit.NANOS -> TimeUnit.NANOS((NanoSeconds)new NanoSeconds());
            };
        }
    }

    public static enum SortOrder {
        SIGNED,
        UNSIGNED,
        UNKNOWN;

    }

    private static class SortOrderVisitor
    implements LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<SortOrder> {
        private SortOrderVisitor() {
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.IntLogicalTypeAnnotation intLogicalType) {
            return Optional.of(intLogicalType.isSigned() ? SortOrder.SIGNED : SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation intervalLogicalType) {
            return Optional.of(SortOrder.UNKNOWN);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.DateLogicalTypeAnnotation dateLogicalType) {
            return Optional.of(SortOrder.SIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.EnumLogicalTypeAnnotation enumLogicalType) {
            return Optional.of(SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.BsonLogicalTypeAnnotation bsonLogicalType) {
            return Optional.of(SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.UUIDLogicalTypeAnnotation uuidLogicalType) {
            return Optional.of(SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.JsonLogicalTypeAnnotation jsonLogicalType) {
            return Optional.of(SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
            return Optional.of(SortOrder.UNSIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalLogicalType) {
            return Optional.of(SortOrder.UNKNOWN);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.MapKeyValueTypeAnnotation mapKeyValueLogicalType) {
            return Optional.of(SortOrder.UNKNOWN);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.MapLogicalTypeAnnotation mapLogicalType) {
            return Optional.of(SortOrder.UNKNOWN);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.ListLogicalTypeAnnotation listLogicalType) {
            return Optional.of(SortOrder.UNKNOWN);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.TimeLogicalTypeAnnotation timeLogicalType) {
            return Optional.of(SortOrder.SIGNED);
        }

        public Optional<SortOrder> visit(LogicalTypeAnnotation.TimestampLogicalTypeAnnotation timestampLogicalType) {
            return Optional.of(SortOrder.SIGNED);
        }
    }
}

