/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import io.trino.parquet.metadata.ColumnChunkMetadata;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BlockMetadata {
    private final List<ColumnChunkMetadata> columns = new ArrayList<ColumnChunkMetadata>();
    private long rowCount;
    private long totalByteSize;
    private String path;
    private int ordinal;
    private long rowIndexOffset = -1L;

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public void setRowCount(long rowCount) {
        this.rowCount = rowCount;
    }

    public long getRowIndexOffset() {
        return this.rowIndexOffset;
    }

    public void setRowIndexOffset(long rowIndexOffset) {
        this.rowIndexOffset = rowIndexOffset;
    }

    public long getTotalByteSize() {
        return this.totalByteSize;
    }

    public void setTotalByteSize(long totalByteSize) {
        this.totalByteSize = totalByteSize;
    }

    public void addColumn(ColumnChunkMetadata column) {
        this.columns.add(column);
    }

    public List<ColumnChunkMetadata> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public long getStartingPos() {
        return this.getColumns().getFirst().getStartingPos();
    }

    public String toString() {
        Object rowIndexOffsetString = "";
        if (this.rowIndexOffset != -1L) {
            rowIndexOffsetString = ", rowIndexOffset = " + this.rowIndexOffset;
        }
        return "BlockMetaData{" + this.rowCount + ", " + this.totalByteSize + (String)rowIndexOffsetString + " " + String.valueOf(this.columns) + "}";
    }

    public long getCompressedSize() {
        long totalSize = 0L;
        for (ColumnChunkMetadata col : this.getColumns()) {
            totalSize += col.getTotalSize();
        }
        return totalSize;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public void setOrdinal(int ordinal) {
        this.ordinal = ordinal;
    }
}

