/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import io.airlift.log.Logger;
import io.airlift.slice.BasicSliceInput;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSource;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetMetadataConverter;
import io.trino.parquet.ParquetValidationUtils;
import io.trino.parquet.ParquetWriteValidation;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.metadata.FileMetadata;
import io.trino.parquet.metadata.ParquetMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.apache.parquet.CorruptStatistics;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.KeyValue;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;

public final class MetadataReader {
    private static final Logger log = Logger.get(MetadataReader.class);
    private static final Slice MAGIC = Slices.utf8Slice((String)"PAR1");
    private static final int POST_SCRIPT_SIZE = 4 + MAGIC.length();
    private static final int EXPECTED_FOOTER_SIZE = 49152;

    private MetadataReader() {
    }

    public static ParquetMetadata readFooter(ParquetDataSource dataSource, Optional<ParquetWriteValidation> parquetWriteValidation) throws IOException {
        ParquetValidationUtils.validateParquet(dataSource.getEstimatedSize() >= (long)(MAGIC.length() + POST_SCRIPT_SIZE), dataSource.getId(), "%s is not a valid Parquet File", dataSource.getId());
        long estimatedFileSize = dataSource.getEstimatedSize();
        long expectedReadSize = Math.min(estimatedFileSize, 49152L);
        Slice buffer = dataSource.readTail(Math.toIntExact(expectedReadSize));
        Slice magic = buffer.slice(buffer.length() - MAGIC.length(), MAGIC.length());
        ParquetValidationUtils.validateParquet(MAGIC.equals((Object)magic), dataSource.getId(), "Expected magic number: %s got: %s", MAGIC.toStringUtf8(), magic.toStringUtf8());
        int metadataLength = buffer.getInt(buffer.length() - POST_SCRIPT_SIZE);
        long metadataIndex = estimatedFileSize - (long)POST_SCRIPT_SIZE - (long)metadataLength;
        ParquetValidationUtils.validateParquet(metadataIndex >= (long)MAGIC.length() && metadataIndex < estimatedFileSize - (long)POST_SCRIPT_SIZE, dataSource.getId(), "Metadata index: %s out of range", metadataIndex);
        int completeFooterSize = metadataLength + POST_SCRIPT_SIZE;
        if (completeFooterSize > buffer.length()) {
            buffer = dataSource.readTail(completeFooterSize);
        }
        BasicSliceInput metadataStream = buffer.slice(buffer.length() - completeFooterSize, metadataLength).getInput();
        FileMetaData fileMetaData = Util.readFileMetaData((InputStream)metadataStream);
        ParquetMetadata parquetMetadata = MetadataReader.createParquetMetadata(fileMetaData, dataSource.getId());
        MetadataReader.validateFileMetadata(dataSource.getId(), parquetMetadata.getFileMetaData(), parquetWriteValidation);
        return parquetMetadata;
    }

    public static ParquetMetadata createParquetMetadata(FileMetaData fileMetaData, ParquetDataSourceId dataSourceId) throws ParquetCorruptionException {
        List schema = fileMetaData.getSchema();
        ParquetValidationUtils.validateParquet(!schema.isEmpty(), dataSourceId, "Schema is empty", new Object[0]);
        MessageType messageType = MetadataReader.readParquetSchema(schema);
        ArrayList<BlockMetadata> blocks = new ArrayList<BlockMetadata>();
        List rowGroups = fileMetaData.getRow_groups();
        if (rowGroups != null) {
            for (RowGroup rowGroup : rowGroups) {
                BlockMetadata blockMetaData = new BlockMetadata();
                blockMetaData.setRowCount(rowGroup.getNum_rows());
                blockMetaData.setTotalByteSize(rowGroup.getTotal_byte_size());
                List columns = rowGroup.getColumns();
                ParquetValidationUtils.validateParquet(!columns.isEmpty(), dataSourceId, "No columns in row group: %s", rowGroup);
                String filePath = ((ColumnChunk)columns.get(0)).getFile_path();
                for (ColumnChunk columnChunk : columns) {
                    ParquetValidationUtils.validateParquet(filePath == null && columnChunk.getFile_path() == null || filePath != null && filePath.equals(columnChunk.getFile_path()), dataSourceId, "all column chunks of the same row group must be in the same file", new Object[0]);
                    ColumnMetaData metaData = columnChunk.meta_data;
                    String[] path = (String[])metaData.path_in_schema.stream().map(value -> value.toLowerCase(Locale.ENGLISH)).toArray(String[]::new);
                    ColumnPath columnPath = ColumnPath.get((String[])path);
                    PrimitiveType primitiveType = messageType.getType(columnPath.toArray()).asPrimitiveType();
                    ColumnChunkMetadata column = ColumnChunkMetadata.get(columnPath, primitiveType, CompressionCodecName.fromParquet((CompressionCodec)metaData.codec), ParquetMetadataConverter.convertEncodingStats(metaData.encoding_stats), MetadataReader.readEncodings(metaData.encodings), MetadataReader.readStats(Optional.ofNullable(fileMetaData.getCreated_by()), Optional.ofNullable(metaData.statistics), primitiveType), metaData.data_page_offset, metaData.dictionary_page_offset, metaData.num_values, metaData.total_compressed_size, metaData.total_uncompressed_size);
                    column.setColumnIndexReference(ParquetMetadataConverter.toColumnIndexReference(columnChunk));
                    column.setOffsetIndexReference(ParquetMetadataConverter.toOffsetIndexReference(columnChunk));
                    column.setBloomFilterOffset(metaData.bloom_filter_offset);
                    blockMetaData.addColumn(column);
                }
                blockMetaData.setPath(filePath);
                blocks.add(blockMetaData);
            }
        }
        HashMap<String, String> keyValueMetaData = new HashMap<String, String>();
        List keyValueList = fileMetaData.getKey_value_metadata();
        if (keyValueList != null) {
            for (KeyValue keyValue : keyValueList) {
                keyValueMetaData.put(keyValue.key, keyValue.value);
            }
        }
        FileMetadata parquetFileMetadata = new FileMetadata(messageType, keyValueMetaData, fileMetaData.getCreated_by());
        return new ParquetMetadata(parquetFileMetadata, blocks);
    }

    private static MessageType readParquetSchema(List<SchemaElement> schema) {
        Iterator<SchemaElement> schemaIterator = schema.iterator();
        SchemaElement rootSchema = schemaIterator.next();
        Types.MessageTypeBuilder builder = Types.buildMessage();
        MetadataReader.readTypeSchema(builder, schemaIterator, rootSchema.getNum_children());
        return builder.named(rootSchema.name);
    }

    private static void readTypeSchema(Types.GroupBuilder<?> builder, Iterator<SchemaElement> schemaIterator, int typeCount) {
        for (int i = 0; i < typeCount; ++i) {
            Types.GroupBuilder typeBuilder;
            SchemaElement element = schemaIterator.next();
            if (element.type == null) {
                typeBuilder = builder.group(Type.Repetition.valueOf((String)element.repetition_type.name()));
                MetadataReader.readTypeSchema(typeBuilder, schemaIterator, element.num_children);
            } else {
                Types.PrimitiveBuilder primitiveBuilder = builder.primitive(MetadataReader.getTypeName(element.type), Type.Repetition.valueOf((String)element.repetition_type.name()));
                if (element.isSetType_length()) {
                    primitiveBuilder.length(element.type_length);
                }
                if (element.isSetPrecision()) {
                    primitiveBuilder.precision(element.precision);
                }
                if (element.isSetScale()) {
                    primitiveBuilder.scale(element.scale);
                }
                typeBuilder = primitiveBuilder;
            }
            LogicalTypeAnnotation annotationFromLogicalType = null;
            if (element.isSetLogicalType()) {
                annotationFromLogicalType = ParquetMetadataConverter.getLogicalTypeAnnotation(element.logicalType);
                typeBuilder.as(annotationFromLogicalType);
            }
            if (element.isSetConverted_type()) {
                LogicalTypeAnnotation annotationFromConvertedType = ParquetMetadataConverter.getLogicalTypeAnnotation(element.converted_type, element);
                if (annotationFromLogicalType != null) {
                    if (annotationFromLogicalType.toOriginalType() != annotationFromConvertedType.toOriginalType()) {
                        log.warn("Converted type and logical type metadata map to different OriginalType (convertedType: %s, logical type: %s). Using value in converted type.", new Object[]{element.converted_type, element.logicalType});
                        typeBuilder.as(annotationFromConvertedType);
                    }
                } else {
                    typeBuilder.as(annotationFromConvertedType);
                }
            }
            if (element.isSetField_id()) {
                typeBuilder.id(element.field_id);
            }
            typeBuilder.named(element.name.toLowerCase(Locale.ENGLISH));
        }
    }

    public static Statistics<?> readStats(Optional<String> fileCreatedBy, Optional<org.apache.parquet.format.Statistics> statisticsFromFile, PrimitiveType type) {
        org.apache.parquet.format.Statistics statistics = statisticsFromFile.orElse(null);
        Statistics<?> columnStatistics = ParquetMetadataConverter.fromParquetStatistics(fileCreatedBy.orElse(null), statistics, type);
        if (MetadataReader.isStringType(type) && statistics != null && !statistics.isSetMin_value() && !statistics.isSetMax_value() && statistics.isSetMin() && statistics.isSetMax() && columnStatistics.genericGetMin() == null && columnStatistics.genericGetMax() == null && !CorruptStatistics.shouldIgnoreStatistics((String)fileCreatedBy.orElse(null), (PrimitiveType.PrimitiveTypeName)type.getPrimitiveTypeName())) {
            MetadataReader.tryReadOldUtf8Stats(statistics, (BinaryStatistics)columnStatistics);
        }
        return columnStatistics;
    }

    private static boolean isStringType(PrimitiveType type) {
        if (type.getLogicalTypeAnnotation() == null) {
            return false;
        }
        return type.getLogicalTypeAnnotation().accept((LogicalTypeAnnotation.LogicalTypeAnnotationVisitor)new LogicalTypeAnnotation.LogicalTypeAnnotationVisitor<Boolean>(){

            public Optional<Boolean> visit(LogicalTypeAnnotation.StringLogicalTypeAnnotation stringLogicalType) {
                return Optional.of(Boolean.TRUE);
            }
        }).orElse(Boolean.FALSE);
    }

    private static void tryReadOldUtf8Stats(org.apache.parquet.format.Statistics statistics, BinaryStatistics columnStatistics) {
        byte[] max;
        byte[] min = statistics.getMin();
        if (Arrays.equals(min, max = statistics.getMax())) {
            min = (byte[])min.clone();
            max = min;
        } else {
            int commonPrefix;
            int minGoodLength;
            for (minGoodLength = commonPrefix = MetadataReader.commonPrefix(min, max); minGoodLength < min.length && MetadataReader.isAscii(min[minGoodLength]); ++minGoodLength) {
            }
            int maxGoodLength = commonPrefix;
            if (maxGoodLength < max.length && maxGoodLength < min.length && MetadataReader.isAscii(min[maxGoodLength]) && MetadataReader.isAscii(max[maxGoodLength])) {
                ++maxGoodLength;
            }
            while (!(maxGoodLength <= 0 || max[maxGoodLength - 1] != 127 && MetadataReader.isAscii(max[maxGoodLength - 1]))) {
                --maxGoodLength;
            }
            if (maxGoodLength == 0) {
                return;
            }
            min = Arrays.copyOf(min, minGoodLength);
            max = Arrays.copyOf(max, maxGoodLength);
            int n = maxGoodLength - 1;
            max[n] = (byte)(max[n] + 1);
        }
        columnStatistics.setMinMaxFromBytes(min, max);
        if (!columnStatistics.isNumNullsSet() && statistics.isSetNull_count()) {
            columnStatistics.setNumNulls(statistics.getNull_count());
        }
    }

    private static boolean isAscii(byte b) {
        return 0 <= b;
    }

    private static int commonPrefix(byte[] a, byte[] b) {
        int commonPrefixLength;
        for (commonPrefixLength = 0; commonPrefixLength < a.length && commonPrefixLength < b.length && a[commonPrefixLength] == b[commonPrefixLength]; ++commonPrefixLength) {
        }
        return commonPrefixLength;
    }

    private static Set<org.apache.parquet.column.Encoding> readEncodings(List<Encoding> encodings) {
        HashSet<org.apache.parquet.column.Encoding> columnEncodings = new HashSet<org.apache.parquet.column.Encoding>();
        for (Encoding encoding : encodings) {
            columnEncodings.add(ParquetMetadataConverter.getEncoding(encoding));
        }
        return Collections.unmodifiableSet(columnEncodings);
    }

    private static PrimitiveType.PrimitiveTypeName getTypeName(Type type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case Type.BYTE_ARRAY -> PrimitiveType.PrimitiveTypeName.BINARY;
            case Type.INT64 -> PrimitiveType.PrimitiveTypeName.INT64;
            case Type.INT32 -> PrimitiveType.PrimitiveTypeName.INT32;
            case Type.BOOLEAN -> PrimitiveType.PrimitiveTypeName.BOOLEAN;
            case Type.FLOAT -> PrimitiveType.PrimitiveTypeName.FLOAT;
            case Type.DOUBLE -> PrimitiveType.PrimitiveTypeName.DOUBLE;
            case Type.INT96 -> PrimitiveType.PrimitiveTypeName.INT96;
            case Type.FIXED_LEN_BYTE_ARRAY -> PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY;
        };
    }

    private static void validateFileMetadata(ParquetDataSourceId dataSourceId, FileMetadata fileMetaData, Optional<ParquetWriteValidation> parquetWriteValidation) throws ParquetCorruptionException {
        if (parquetWriteValidation.isEmpty()) {
            return;
        }
        ParquetWriteValidation writeValidation = parquetWriteValidation.get();
        writeValidation.validateTimeZone(dataSourceId, Optional.ofNullable(fileMetaData.getKeyValueMetaData().get("writer.time.zone")));
        writeValidation.validateColumns(dataSourceId, fileMetaData.getSchema());
    }
}

