/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.reader.flat.NullsDecoder;
import io.trino.parquet.reader.flat.ZeroDefinitionLevelDecoder;

public interface FlatDefinitionLevelDecoder {
    public void init(Slice var1);

    public int readNext(boolean[] var1, int var2, int var3);

    public int skip(int var1);

    public static FlatDefinitionLevelDecoder getFlatDefinitionLevelDecoder(int maxDefinitionLevel) {
        Preconditions.checkArgument((maxDefinitionLevel >= 0 && maxDefinitionLevel <= 1 ? 1 : 0) != 0, (String)"Invalid max definition level: %s", (int)maxDefinitionLevel);
        if (maxDefinitionLevel == 0) {
            return new ZeroDefinitionLevelDecoder();
        }
        return new NullsDecoder();
    }

    public static interface DefinitionLevelDecoderProvider {
        public FlatDefinitionLevelDecoder create(int var1);
    }
}

