/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import io.trino.parquet.writer.valuewriter.BloomFilterValuesWriter;
import io.trino.parquet.writer.valuewriter.DictionaryFallbackValuesWriter;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.column.values.dictionary.DictionaryValuesWriter;
import org.apache.parquet.column.values.plain.BooleanPlainValuesWriter;
import org.apache.parquet.column.values.plain.FixedLenByteArrayPlainValuesWriter;
import org.apache.parquet.column.values.plain.PlainValuesWriter;
import org.apache.parquet.schema.PrimitiveType;

public class TrinoValuesWriterFactory {
    private final ParquetProperties parquetProperties;

    public TrinoValuesWriterFactory(ParquetProperties properties) {
        this.parquetProperties = properties;
    }

    public ValuesWriter newValuesWriter(ColumnDescriptor descriptor, Optional<BloomFilter> bloomFilter) {
        return switch (descriptor.getPrimitiveType().getPrimitiveTypeName()) {
            default -> throw new MatchException(null, null);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> new BooleanPlainValuesWriter();
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> this.getFixedLenByteArrayValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.BINARY -> this.getBinaryValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getInt64ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.INT96 -> this.getInt96ValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> this.getDoubleValuesWriter(descriptor, bloomFilter);
            case PrimitiveType.PrimitiveTypeName.FLOAT -> this.getFloatValuesWriter(descriptor, bloomFilter);
        };
    }

    private ValuesWriter getFixedLenByteArrayValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        return BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new FixedLenByteArrayPlainValuesWriter(path.getTypeLength(), this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
    }

    private ValuesWriter getBinaryValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt32ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt64ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getInt96ValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new FixedLenByteArrayPlainValuesWriter(12, this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getDoubleValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private ValuesWriter getFloatValuesWriter(ColumnDescriptor path, Optional<BloomFilter> bloomFilter) {
        ValuesWriter fallbackWriter = BloomFilterValuesWriter.createBloomFilterValuesWriter((ValuesWriter)new PlainValuesWriter(this.parquetProperties.getInitialSlabSize(), this.parquetProperties.getPageSizeThreshold(), this.parquetProperties.getAllocator()), bloomFilter);
        return TrinoValuesWriterFactory.dictWriterWithFallBack(path, this.parquetProperties, TrinoValuesWriterFactory.getEncodingForDictionaryPage(), TrinoValuesWriterFactory.getEncodingForDataPage(), fallbackWriter);
    }

    private static Encoding getEncodingForDataPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    private static Encoding getEncodingForDictionaryPage() {
        return Encoding.PLAIN_DICTIONARY;
    }

    private static DictionaryValuesWriter dictionaryWriter(ColumnDescriptor path, ParquetProperties properties, Encoding dictPageEncoding, Encoding dataPageEncoding) {
        return switch (path.getPrimitiveType().getPrimitiveTypeName()) {
            default -> throw new MatchException(null, null);
            case PrimitiveType.PrimitiveTypeName.BOOLEAN -> throw new IllegalArgumentException("no dictionary encoding for BOOLEAN");
            case PrimitiveType.PrimitiveTypeName.BINARY -> new DictionaryValuesWriter.PlainBinaryDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.INT32 -> new DictionaryValuesWriter.PlainIntegerDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.INT64 -> new DictionaryValuesWriter.PlainLongDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.INT96 -> new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), 12, dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.DOUBLE -> new DictionaryValuesWriter.PlainDoubleDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.FLOAT -> new DictionaryValuesWriter.PlainFloatDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> new DictionaryValuesWriter.PlainFixedLenArrayDictionaryValuesWriter(properties.getDictionaryPageSizeThreshold(), path.getTypeLength(), dataPageEncoding, dictPageEncoding, properties.getAllocator());
        };
    }

    private static ValuesWriter dictWriterWithFallBack(ColumnDescriptor path, ParquetProperties parquetProperties, Encoding dictPageEncoding, Encoding dataPageEncoding, ValuesWriter writerToFallBackTo) {
        return new DictionaryFallbackValuesWriter(TrinoValuesWriterFactory.dictionaryWriter(path, parquetProperties, dictPageEncoding, dataPageEncoding), writerToFallBackTo);
    }
}

