/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import com.google.common.base.Preconditions;
import io.airlift.slice.Slice;
import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.ParquetTypeUtils;
import io.trino.parquet.PrimitiveField;
import io.trino.parquet.ValuesType;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ApacheParquetValueDecoders;
import io.trino.parquet.reader.decoders.BooleanPlainValueDecoders;
import io.trino.parquet.reader.decoders.DeltaBinaryPackedDecoders;
import io.trino.parquet.reader.decoders.DeltaByteArrayDecoders;
import io.trino.parquet.reader.decoders.DeltaLengthByteArrayDecoders;
import io.trino.parquet.reader.decoders.PlainByteArrayDecoders;
import io.trino.parquet.reader.decoders.PlainValueDecoders;
import io.trino.parquet.reader.decoders.RleBitPackingHybridBooleanDecoder;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BinaryBuffer;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Fixed12Block;
import io.trino.spi.type.CharType;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DecimalConversions;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Decimals;
import io.trino.spi.type.Int128;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Timestamps;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.util.Objects;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.joda.time.DateTimeZone;

public final class ValueDecoders {
    private final PrimitiveField field;
    private final boolean vectorizedDecodingEnabled;

    public ValueDecoders(PrimitiveField field) {
        this(field, false);
    }

    public ValueDecoders(PrimitiveField field, boolean vectorizedDecodingEnabled) {
        this.field = Objects.requireNonNull(field, "field is null");
        this.vectorizedDecodingEnabled = vectorizedDecodingEnabled;
    }

    public ValueDecoder<long[]> getDoubleDecoder(ParquetEncoding encoding) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.LongPlainValueDecoder();
        }
        if (ParquetEncoding.BYTE_STREAM_SPLIT.equals((Object)encoding)) {
            return new ApacheParquetValueDecoders.DoubleApacheParquetValueDecoder(this.getApacheParquetReader(encoding));
        }
        throw this.wrongEncoding(encoding);
    }

    public ValueDecoder<int[]> getRealDecoder(ParquetEncoding encoding) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.IntPlainValueDecoder();
        }
        if (ParquetEncoding.BYTE_STREAM_SPLIT.equals((Object)encoding)) {
            return new ApacheParquetValueDecoders.FloatApacheParquetValueDecoder(this.getApacheParquetReader(encoding));
        }
        throw this.wrongEncoding(encoding);
    }

    public ValueDecoder<long[]> getShortDecimalDecoder(ParquetEncoding encoding) {
        PrimitiveType primitiveType = this.field.getDescriptor().getPrimitiveType();
        Preconditions.checkArgument((boolean)(primitiveType.getLogicalTypeAnnotation() instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation), (String)"Column %s is not annotated as a decimal", (Object)this.field);
        return switch (primitiveType.getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getLongDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32ToLongDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> this.getFixedWidthShortDecimalDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.BINARY -> this.getBinaryShortDecimalDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<long[]> getLongDecimalDecoder(ParquetEncoding encoding) {
        return switch (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY -> this.getFixedWidthLongDecimalDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.BINARY -> this.getBinaryLongDecimalDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<long[]> getUuidDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.UuidPlainValueDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY -> this.getDeltaUuidDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<long[]> getLongDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedLongDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<int[]> getIntDecoder(ParquetEncoding encoding) {
        return switch (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getInt64ToIntDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32Decoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<short[]> getShortDecoder(ParquetEncoding encoding) {
        return switch (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getInt64ToShortDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32ToShortDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<byte[]> getByteDecoder(ParquetEncoding encoding) {
        return switch (this.field.getDescriptor().getPrimitiveType().getPrimitiveTypeName()) {
            case PrimitiveType.PrimitiveTypeName.INT64 -> this.getInt64ToByteDecoder(encoding);
            case PrimitiveType.PrimitiveTypeName.INT32 -> this.getInt32ToByteDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<byte[]> getBooleanDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> BooleanPlainValueDecoders.createBooleanPlainValueDecoder(this.vectorizedDecodingEnabled);
            case ParquetEncoding.RLE -> new RleBitPackingHybridBooleanDecoder(this.vectorizedDecodingEnabled);
            case ParquetEncoding.BIT_PACKED -> new ApacheParquetValueDecoders.BooleanApacheParquetValueDecoder(this.getApacheParquetReader(encoding));
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<int[]> getInt96TimestampDecoder(ParquetEncoding encoding) {
        if (ParquetEncoding.PLAIN.equals((Object)encoding)) {
            return new PlainValueDecoders.Int96TimestampPlainValueDecoder();
        }
        throw this.wrongEncoding(encoding);
    }

    public ValueDecoder<long[]> getFixedWidthShortDecimalDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.ShortDecimalFixedLengthByteArrayDecoder(this.field.getDescriptor());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> this.getDeltaFixedWidthShortDecimalDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<long[]> getFixedWidthLongDecimalDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.LongDecimalPlainValueDecoder(this.field.getDescriptor().getPrimitiveType().getTypeLength());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> this.getDeltaFixedWidthLongDecimalDecoder(encoding);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<BinaryBuffer> getFixedWidthBinaryDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.FixedLengthPlainValueDecoder(this.field.getDescriptor().getPrimitiveType().getTypeLength());
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<BinaryBuffer> getBoundedVarcharBinaryDecoder(ParquetEncoding encoding) {
        VarcharType varcharType;
        Type trinoType = this.field.getType();
        Preconditions.checkArgument((trinoType instanceof VarcharType && !(varcharType = (VarcharType)trinoType).isUnbounded() ? 1 : 0) != 0, (String)"Trino type %s is not a bounded varchar", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BoundedVarcharPlainValueDecoder((VarcharType)trinoType);
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.BoundedVarcharDeltaLengthDecoder((VarcharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BoundedVarcharDeltaByteArrayDecoder((VarcharType)trinoType);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<BinaryBuffer> getCharBinaryDecoder(ParquetEncoding encoding) {
        Type trinoType = this.field.getType();
        Preconditions.checkArgument((boolean)(trinoType instanceof CharType), (String)"Trino type %s is not a char", (Object)trinoType);
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.CharPlainValueDecoder((CharType)trinoType);
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.CharDeltaLengthDecoder((CharType)trinoType);
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.CharDeltaByteArrayDecoder((CharType)trinoType);
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<BinaryBuffer> getBinaryDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainByteArrayDecoders.BinaryPlainValueDecoder();
            case ParquetEncoding.DELTA_LENGTH_BYTE_ARRAY -> new DeltaLengthByteArrayDecoders.BinaryDeltaLengthDecoder();
            case ParquetEncoding.DELTA_BYTE_ARRAY -> new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<int[]> getInt32Decoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedIntDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    private ValueDecoder<short[]> getInt32ToShortDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToShortPlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedShortDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    private ValueDecoder<byte[]> getInt32ToByteDecoder(ParquetEncoding encoding) {
        return switch (encoding) {
            case ParquetEncoding.PLAIN -> new PlainValueDecoders.IntToBytePlainValueDecoder();
            case ParquetEncoding.DELTA_BINARY_PACKED -> new DeltaBinaryPackedDecoders.DeltaBinaryPackedByteDecoder();
            default -> throw this.wrongEncoding(encoding);
        };
    }

    public ValueDecoder<long[]> getTimeMicrosDecoder(ParquetEncoding encoding) {
        return new InlineTransformDecoder<long[]>(this.getLongDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000000L;
            }
        });
    }

    public ValueDecoder<long[]> getTimeMillisDecoder(ParquetEncoding encoding) {
        int precision = ((TimeType)this.field.getType()).getPrecision();
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(this.getInt32ToLongDecoder(encoding), (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = Timestamps.round((long)values[i], (int)(3 - precision)) * 1000000000L % 86400000000000000L;
                }
            });
        }
        return new InlineTransformDecoder<long[]>(this.getInt32ToLongDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = values[i] * 1000000000L;
            }
        });
    }

    public ValueDecoder<long[]> getInt96ToShortTimestampDecoder(ParquetEncoding encoding, final DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        final int precision = ((TimestampType)this.field.getType()).getPrecision();
        final ValueDecoder<int[]> delegate = this.getInt96TimestampDecoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] int96Buffer = new int[length * 3];
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = Fixed12Block.decodeFixed12First((int[])int96Buffer, (int)i);
                    long epochMicros = timeZone == DateTimeZone.UTC ? epochSeconds * 1000000L : timeZone.convertUTCToLocal(epochSeconds * 1000L) * 1000L;
                    int nanosOfSecond = (int)Timestamps.round((long)Fixed12Block.decodeFixed12Second((int[])int96Buffer, (int)i), (int)(9 - precision));
                    values[offset + i] = epochMicros + (long)(nanosOfSecond / 1000);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt96ToLongTimestampDecoder(ParquetEncoding encoding, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && !(timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a long timestamp", (Object)this.field.getType());
        int precision = ((TimestampType)this.field.getType()).getPrecision();
        return new InlineTransformDecoder<int[]>(this.getInt96TimestampDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochSeconds = Fixed12Block.decodeFixed12First((int[])values, (int)i);
                int nanosOfSecond = Fixed12Block.decodeFixed12Second((int[])values, (int)i);
                if (timeZone != DateTimeZone.UTC) {
                    epochSeconds = timeZone.convertUTCToLocal(epochSeconds * 1000L) / 1000L;
                }
                if (precision < 9) {
                    nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
                }
                Fixed12Block.encodeFixed12((long)(epochSeconds * 1000000L + (long)(nanosOfSecond / 1000)), (int)(nanosOfSecond % 1000 * 1000), (int[])values, (int)i);
            }
        });
    }

    public ValueDecoder<long[]> getInt96ToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp with timezone", (Object)this.field.getType());
        final ValueDecoder<int[]> delegate = this.getInt96TimestampDecoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] int96Buffer = new int[length * 3];
                delegate.read(int96Buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochSeconds = Fixed12Block.decodeFixed12First((int[])int96Buffer, (int)i);
                    int nanosOfSecond = Fixed12Block.decodeFixed12Second((int[])int96Buffer, (int)i);
                    long utcMillis = epochSeconds * 1000L + (long)(nanosOfSecond / 1000000);
                    values[offset + i] = DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt96ToLongTimestampWithTimeZoneDecoder(ParquetEncoding encoding) {
        TimestampWithTimeZoneType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && !(timestampType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a long timestamp", (Object)this.field.getType());
        int precision = ((TimestampWithTimeZoneType)this.field.getType()).getPrecision();
        return new InlineTransformDecoder<int[]>(this.getInt96TimestampDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochSeconds = Fixed12Block.decodeFixed12First((int[])values, (int)i);
                int nanosOfSecond = Fixed12Block.decodeFixed12Second((int[])values, (int)i);
                if (precision < 9) {
                    nanosOfSecond = (int)Timestamps.round((long)nanosOfSecond, (int)(9 - precision));
                }
                long utcMillis = epochSeconds * 1000L + (long)(nanosOfSecond / 1000000);
                Fixed12Block.encodeFixed12((long)DateTimeEncoding.packDateTimeWithZone((long)utcMillis, (TimeZoneKey)TimeZoneKey.UTC_KEY), (int)(nanosOfSecond % 1000000 * 1000), (int[])values, (int)i);
            }
        });
    }

    public ValueDecoder<long[]> getInt64TimestampMillisToShortTimestampDecoder(ParquetEncoding encoding, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        int precision = ((TimestampType)this.field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = this.getLongDecoder(encoding);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    long epochMillis = Timestamps.round((long)values[i], (int)(3 - precision));
                    values[i] = timeZone == DateTimeZone.UTC ? epochMillis * 1000L : timeZone.convertUTCToLocal(epochMillis) * 1000L;
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = timeZone == DateTimeZone.UTC ? values[i] * 1000L : timeZone.convertUTCToLocal(values[i]) * 1000L;
            }
        });
    }

    public ValueDecoder<long[]> getInt64TimestampMillsToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        int precision = ((TimestampWithTimeZoneType)this.field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = this.getLongDecoder(encoding);
        if (precision < 3) {
            return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = DateTimeEncoding.packDateTimeWithZone((long)Timestamps.round((long)values[i], (int)(3 - precision)), (TimeZoneKey)TimeZoneKey.UTC_KEY);
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)values[i], (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampDecoder(ParquetEncoding encoding, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        int precision = ((TimestampType)this.field.getType()).getPrecision();
        ValueDecoder<long[]> valueDecoder = this.getLongDecoder(encoding);
        if (precision == 6) {
            if (timeZone == DateTimeZone.UTC) {
                return valueDecoder;
            }
            new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    long epochMicros = values[i];
                    long localMillis = timeZone.convertUTCToLocal(Math.floorDiv(epochMicros, 1000));
                    values[i] = localMillis * 1000L + (long)Math.floorMod(epochMicros, 1000);
                }
            });
        }
        return new InlineTransformDecoder<long[]>(valueDecoder, (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochMicros = Timestamps.round((long)values[i], (int)(6 - precision));
                if (timeZone == DateTimeZone.UTC) {
                    values[i] = epochMicros;
                    continue;
                }
                long localMillis = timeZone.convertUTCToLocal(Math.floorDiv(epochMicros, 1000));
                values[i] = localMillis * 1000L + (long)Math.floorMod(epochMicros, 1000);
            }
        });
    }

    public ValueDecoder<long[]> getInt64TimestampMicrosToShortTimestampWithTimeZoneDecoder(ParquetEncoding encoding) {
        TimestampWithTimeZoneType timestampWithTimeZoneType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampWithTimeZoneType && (timestampWithTimeZoneType = (TimestampWithTimeZoneType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        int precision = ((TimestampWithTimeZoneType)this.field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(this.getLongDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                values[i] = DateTimeEncoding.packDateTimeWithZone((long)(Timestamps.round((long)values[i], (int)(6 - precision)) / 1000L), (TimeZoneKey)TimeZoneKey.UTC_KEY);
            }
        });
    }

    public ValueDecoder<long[]> getInt64TimestampNanosToShortTimestampDecoder(ParquetEncoding encoding, DateTimeZone timeZone) {
        TimestampType timestampType;
        Type type = this.field.getType();
        Preconditions.checkArgument((type instanceof TimestampType && (timestampType = (TimestampType)type).isShort() ? 1 : 0) != 0, (String)"Trino type %s is not a short timestamp", (Object)this.field.getType());
        int precision = ((TimestampType)this.field.getType()).getPrecision();
        return new InlineTransformDecoder<long[]>(this.getLongDecoder(encoding), (values, offset, length) -> {
            for (int i = offset; i < offset + length; ++i) {
                long epochNanos = Timestamps.round((long)values[i], (int)(9 - precision));
                if (timeZone == DateTimeZone.UTC) {
                    values[i] = epochNanos / 1000L;
                    continue;
                }
                long localMillis = timeZone.convertUTCToLocal(Math.floorDiv(epochNanos, 1000000));
                values[i] = localMillis * 1000L + (long)Math.floorDiv(Math.floorMod(epochNanos, 1000000), 1000);
            }
        });
    }

    public ValueDecoder<int[]> getInt64TimestampMillisToLongTimestampDecoder(ParquetEncoding encoding, final DateTimeZone timeZone) {
        final ValueDecoder<long[]> delegate = this.getLongDecoder(encoding);
        return new ValueDecoder<int[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(int[] values, int offset, int length) {
                long[] buffer = new long[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    if (timeZone == DateTimeZone.UTC) {
                        Fixed12Block.encodeFixed12((long)(buffer[i] * 1000L), (int)0, (int[])values, (int)(i + offset));
                        continue;
                    }
                    Fixed12Block.encodeFixed12((long)(timeZone.convertUTCToLocal(buffer[i]) * 1000L), (int)0, (int[])values, (int)(i + offset));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt64TimestampMicrosToLongTimestampDecoder(ParquetEncoding encoding, final DateTimeZone timeZone) {
        final ValueDecoder<long[]> delegate = this.getLongDecoder(encoding);
        return new ValueDecoder<int[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(int[] values, int offset, int length) {
                long[] buffer = new long[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochMicros = buffer[i];
                    if (timeZone == DateTimeZone.UTC) {
                        Fixed12Block.encodeFixed12((long)epochMicros, (int)0, (int[])values, (int)(i + offset));
                        continue;
                    }
                    long localMillis = timeZone.convertUTCToLocal(Math.floorDiv(epochMicros, 1000));
                    Fixed12Block.encodeFixed12((long)(localMillis * 1000L + (long)Math.floorMod(epochMicros, 1000)), (int)0, (int[])values, (int)(i + offset));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt64TimestampMicrosToLongTimestampWithTimeZoneDecoder(ParquetEncoding encoding) {
        final ValueDecoder<long[]> delegate = this.getLongDecoder(encoding);
        return new ValueDecoder<int[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(int[] values, int offset, int length) {
                long[] buffer = new long[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochMicros = buffer[i];
                    Fixed12Block.encodeFixed12((long)DateTimeEncoding.packDateTimeWithZone((long)Math.floorDiv(epochMicros, 1000), (TimeZoneKey)TimeZoneKey.UTC_KEY), (int)(Math.floorMod(epochMicros, 1000) * 1000000), (int[])values, (int)(i + offset));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt64TimestampNanosToLongTimestampDecoder(ParquetEncoding encoding, final DateTimeZone timeZone) {
        final ValueDecoder<long[]> delegate = this.getLongDecoder(encoding);
        return new ValueDecoder<int[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(int[] values, int offset, int length) {
                long[] buffer = new long[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    long epochNanos = buffer[i];
                    int picosOfNanos = Math.floorMod(epochNanos, 1000) * 1000;
                    if (timeZone == DateTimeZone.UTC) {
                        Fixed12Block.encodeFixed12((long)Math.floorDiv(epochNanos, 1000), (int)picosOfNanos, (int[])values, (int)(i + offset));
                        continue;
                    }
                    long localMillis = timeZone.convertUTCToLocal(Math.floorDiv(epochNanos, 1000000));
                    long microsFromNanos = Math.floorMod(epochNanos, 1000000) / 1000;
                    Fixed12Block.encodeFixed12((long)(localMillis * 1000L + microsFromNanos), (int)picosOfNanos, (int[])values, (int)(i + offset));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getFloatToDoubleDecoder(ParquetEncoding encoding) {
        final ValueDecoder<int[]> delegate = this.getRealDecoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[offset + i] = Double.doubleToLongBits(Float.intBitsToFloat(buffer[i]));
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getBinaryLongDecimalDecoder(ParquetEncoding encoding) {
        return new BinaryToLongDecimalTransformDecoder(this.getBinaryDecoder(encoding));
    }

    public ValueDecoder<long[]> getDeltaFixedWidthLongDecimalDecoder(ParquetEncoding encoding) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        ColumnDescriptor descriptor = this.field.getDescriptor();
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getPrecision() > 18 ? 1 : 0) != 0, (String)"Column %s is not a long decimal", (Object)descriptor);
        return new BinaryToLongDecimalTransformDecoder(new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder());
    }

    public ValueDecoder<long[]> getBinaryShortDecimalDecoder(ParquetEncoding encoding) {
        final ValueDecoder<BinaryBuffer> delegate = this.getBinaryDecoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                delegate.read(buffer, 0, length);
                int[] offsets = buffer.getOffsets();
                byte[] inputBytes = buffer.asSlice().byteArray();
                for (int i = 0; i < length; ++i) {
                    int positionOffset = offsets[i];
                    int positionLength = offsets[i + 1] - positionOffset;
                    if (positionLength > 8) {
                        throw new ParquetDecodingException("Unable to read BINARY type decimal of size " + positionLength + " as a short decimal");
                    }
                    values[offset + i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, positionOffset, positionLength);
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getDeltaFixedWidthShortDecimalDecoder(ParquetEncoding encoding) {
        LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation;
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        final ColumnDescriptor descriptor = this.field.getDescriptor();
        LogicalTypeAnnotation logicalTypeAnnotation = descriptor.getPrimitiveType().getLogicalTypeAnnotation();
        Preconditions.checkArgument((logicalTypeAnnotation instanceof LogicalTypeAnnotation.DecimalLogicalTypeAnnotation && (decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)logicalTypeAnnotation).getPrecision() <= 18 ? 1 : 0) != 0, (String)"Column %s is not a short decimal", (Object)descriptor);
        final int typeLength = descriptor.getPrimitiveType().getTypeLength();
        Preconditions.checkArgument((typeLength > 0 && typeLength <= 16 ? 1 : 0) != 0, (String)"Expected column %s to have type length in range (1-16)", (Object)descriptor);
        return new ValueDecoder<long[]>(this){
            private final ValueDecoder<BinaryBuffer> delegate = new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();

            @Override
            public void init(SimpleSliceInputStream input) {
                this.delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                this.delegate.read(buffer, 0, length);
                int bytesOffset = 0;
                int bytesLength = typeLength;
                if (typeLength > 8) {
                    bytesOffset = typeLength - 8;
                    bytesLength = 8;
                }
                byte[] inputBytes = buffer.asSlice().byteArray();
                int[] offsets = buffer.getOffsets();
                for (int i = 0; i < length; ++i) {
                    int inputOffset = offsets[i];
                    ParquetTypeUtils.checkBytesFitInShortDecimal(inputBytes, inputOffset, bytesOffset, descriptor);
                    values[offset + i] = ParquetTypeUtils.getShortDecimalValue(inputBytes, inputOffset + bytesOffset, bytesLength);
                }
            }

            @Override
            public void skip(int n) {
                this.delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getRescaledLongDecimalDecoder(ParquetEncoding encoding) {
        final DecimalType decimalType = (DecimalType)this.field.getType();
        final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (decimalAnnotation.getPrecision() <= 18) {
            final ValueDecoder<long[]> delegate = this.getShortDecimalDecoder(encoding);
            return new ValueDecoder<long[]>(this){

                @Override
                public void init(SimpleSliceInputStream input) {
                    delegate.init(input);
                }

                @Override
                public void read(long[] values, int offset, int length) {
                    long[] buffer = new long[length];
                    delegate.read(buffer, 0, length);
                    for (int i = 0; i < length; ++i) {
                        Int128 rescaled = DecimalConversions.shortToLongCast((long)buffer[i], (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                        values[2 * (offset + i)] = rescaled.getHigh();
                        values[2 * (offset + i) + 1] = rescaled.getLow();
                    }
                }

                @Override
                public void skip(int n) {
                    delegate.skip(n);
                }
            };
        }
        return new InlineTransformDecoder<long[]>(this.getLongDecimalDecoder(encoding), (values, offset, length) -> {
            int endOffset = (offset + length) * 2;
            for (int currentOffset = offset * 2; currentOffset < endOffset; currentOffset += 2) {
                Int128 rescaled = DecimalConversions.longToLongCast((Int128)Int128.valueOf((long)values[currentOffset], (long)values[currentOffset + 1]), (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                values[currentOffset] = rescaled.getHigh();
                values[currentOffset + 1] = rescaled.getLow();
            }
        });
    }

    public ValueDecoder<long[]> getRescaledShortDecimalDecoder(ParquetEncoding encoding) {
        final DecimalType decimalType = (DecimalType)this.field.getType();
        final LogicalTypeAnnotation.DecimalLogicalTypeAnnotation decimalAnnotation = (LogicalTypeAnnotation.DecimalLogicalTypeAnnotation)this.field.getDescriptor().getPrimitiveType().getLogicalTypeAnnotation();
        if (decimalAnnotation.getPrecision() <= 18) {
            long rescale = Decimals.longTenToNth((int)Math.abs(decimalType.getScale() - decimalAnnotation.getScale()));
            return new InlineTransformDecoder<long[]>(this.getShortDecimalDecoder(encoding), (values, offset, length) -> {
                for (int i = offset; i < offset + length; ++i) {
                    values[i] = DecimalConversions.shortToShortCast((long)values[i], (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale(), (long)rescale, (long)(rescale / 2L));
                }
            });
        }
        final ValueDecoder<long[]> delegate = this.getLongDecimalDecoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                long[] buffer = new long[2 * length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[offset + i] = DecimalConversions.longToShortCast((Int128)Int128.valueOf((long)buffer[2 * i], (long)buffer[2 * i + 1]), (long)decimalAnnotation.getPrecision(), (long)decimalAnnotation.getScale(), (long)decimalType.getPrecision(), (long)decimalType.getScale());
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getInt32ToShortDecimalDecoder(ParquetEncoding encoding) {
        final DecimalType decimalType = (DecimalType)this.field.getType();
        final ValueDecoder<int[]> delegate = this.getInt32Decoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    if (Decimals.overflows((long)buffer[i], (int)decimalType.getPrecision())) {
                        throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, String.format("Cannot read parquet INT32 value '%s' as DECIMAL(%s, %s)", buffer[i], decimalType.getPrecision(), decimalType.getScale()));
                    }
                    values[i + offset] = Decimals.rescale((long)buffer[i], (int)0, (int)decimalType.getScale());
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<long[]> getInt32ToLongDecoder(ParquetEncoding encoding) {
        final ValueDecoder<int[]> delegate = this.getInt32Decoder(encoding);
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                int[] buffer = new int[length];
                delegate.read(buffer, 0, length);
                for (int i = 0; i < length; ++i) {
                    values[i + offset] = buffer[i];
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    public ValueDecoder<int[]> getInt64ToIntDecoder(ParquetEncoding encoding) {
        return new LongToIntTransformDecoder(this.getLongDecoder(encoding));
    }

    public ValueDecoder<int[]> getShortDecimalToIntDecoder(ParquetEncoding encoding) {
        return new LongToIntTransformDecoder(this.getShortDecimalDecoder(encoding));
    }

    public ValueDecoder<short[]> getInt64ToShortDecoder(ParquetEncoding encoding) {
        return new LongToShortTransformDecoder(this.getLongDecoder(encoding));
    }

    public ValueDecoder<short[]> getShortDecimalToShortDecoder(ParquetEncoding encoding) {
        return new LongToShortTransformDecoder(this.getShortDecimalDecoder(encoding));
    }

    public ValueDecoder<byte[]> getInt64ToByteDecoder(ParquetEncoding encoding) {
        return new LongToByteTransformDecoder(this.getLongDecoder(encoding));
    }

    public ValueDecoder<byte[]> getShortDecimalToByteDecoder(ParquetEncoding encoding) {
        return new LongToByteTransformDecoder(this.getShortDecimalDecoder(encoding));
    }

    public ValueDecoder<long[]> getDeltaUuidDecoder(ParquetEncoding encoding) {
        Preconditions.checkArgument((boolean)encoding.equals((Object)ParquetEncoding.DELTA_BYTE_ARRAY), (String)"encoding %s is not DELTA_BYTE_ARRAY", (Object)((Object)encoding));
        final DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder delegate = new DeltaByteArrayDecoders.BinaryDeltaByteArrayDecoder();
        return new ValueDecoder<long[]>(this){

            @Override
            public void init(SimpleSliceInputStream input) {
                delegate.init(input);
            }

            @Override
            public void read(long[] values, int offset, int length) {
                BinaryBuffer buffer = new BinaryBuffer(length);
                delegate.read(buffer, 0, length);
                SimpleSliceInputStream binaryInput = new SimpleSliceInputStream(buffer.asSlice());
                int endOffset = (offset + length) * 2;
                for (int outputOffset = offset * 2; outputOffset < endOffset; outputOffset += 2) {
                    values[outputOffset] = binaryInput.readLong();
                    values[outputOffset + 1] = binaryInput.readLong();
                }
            }

            @Override
            public void skip(int n) {
                delegate.skip(n);
            }
        };
    }

    private ValuesReader getApacheParquetReader(ParquetEncoding encoding) {
        return encoding.getValuesReader(this.field.getDescriptor(), ValuesType.VALUES);
    }

    private IllegalArgumentException wrongEncoding(ParquetEncoding encoding) {
        return new IllegalArgumentException("Wrong encoding " + String.valueOf((Object)encoding) + " for column " + String.valueOf(this.field.getDescriptor()));
    }

    private static class InlineTransformDecoder<T>
    implements ValueDecoder<T> {
        private final ValueDecoder<T> valueDecoder;
        private final TypeTransform<T> typeTransform;

        private InlineTransformDecoder(ValueDecoder<T> valueDecoder, TypeTransform<T> typeTransform) {
            this.valueDecoder = Objects.requireNonNull(valueDecoder, "valueDecoder is null");
            this.typeTransform = Objects.requireNonNull(typeTransform, "typeTransform is null");
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.valueDecoder.init(input);
        }

        @Override
        public void read(T values, int offset, int length) {
            this.valueDecoder.read(values, offset, length);
            this.typeTransform.process(values, offset, length);
        }

        @Override
        public void skip(int n) {
            this.valueDecoder.skip(n);
        }
    }

    private static interface TypeTransform<T> {
        public void process(T var1, int var2, int var3);
    }

    private static class BinaryToLongDecimalTransformDecoder
    implements ValueDecoder<long[]> {
        private final ValueDecoder<BinaryBuffer> delegate;

        private BinaryToLongDecimalTransformDecoder(ValueDecoder<BinaryBuffer> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(long[] values, int offset, int length) {
            BinaryBuffer buffer = new BinaryBuffer(length);
            this.delegate.read(buffer, 0, length);
            int[] offsets = buffer.getOffsets();
            Slice binaryInput = buffer.asSlice();
            for (int i = 0; i < length; ++i) {
                int positionOffset = offsets[i];
                int positionLength = offsets[i + 1] - positionOffset;
                Int128 value = Int128.fromBigEndian((byte[])binaryInput.getBytes(positionOffset, positionLength));
                values[2 * (offset + i)] = value.getHigh();
                values[2 * (offset + i) + 1] = value.getLow();
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToIntTransformDecoder
    implements ValueDecoder<int[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToIntTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(int[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = Math.toIntExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToShortTransformDecoder
    implements ValueDecoder<short[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToShortTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(short[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = ParquetReaderUtils.toShortExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }

    private static class LongToByteTransformDecoder
    implements ValueDecoder<byte[]> {
        private final ValueDecoder<long[]> delegate;

        private LongToByteTransformDecoder(ValueDecoder<long[]> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.delegate.init(input);
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            long[] buffer = new long[length];
            this.delegate.read(buffer, 0, length);
            for (int i = 0; i < length; ++i) {
                values[offset + i] = ParquetReaderUtils.toByteExact(buffer[i]);
            }
        }

        @Override
        public void skip(int n) {
            this.delegate.skip(n);
        }
    }
}

