/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import io.trino.parquet.metadata.ColumnChunkProperties;
import io.trino.parquet.metadata.IndexReference;
import io.trino.parquet.metadata.IntColumnChunkMetadata;
import io.trino.parquet.metadata.LongColumnChunkMetadata;
import java.util.Set;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.PrimitiveType;

public abstract class ColumnChunkMetadata {
    protected int rowGroupOrdinal = -1;
    EncodingStats encodingStats;
    ColumnChunkProperties properties;
    private IndexReference columnIndexReference;
    private IndexReference offsetIndexReference;
    private long bloomFilterOffset = -1L;

    public static ColumnChunkMetadata get(ColumnPath path, PrimitiveType type, CompressionCodecName codec, EncodingStats encodingStats, Set<Encoding> encodings, Statistics<?> statistics, long firstDataPage, long dictionaryPageOffset, long valueCount, long totalSize, long totalUncompressedSize) {
        if (ColumnChunkMetadata.positiveLongFitsInAnInt(firstDataPage) && ColumnChunkMetadata.positiveLongFitsInAnInt(dictionaryPageOffset) && ColumnChunkMetadata.positiveLongFitsInAnInt(valueCount) && ColumnChunkMetadata.positiveLongFitsInAnInt(totalSize) && ColumnChunkMetadata.positiveLongFitsInAnInt(totalUncompressedSize)) {
            return new IntColumnChunkMetadata(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
        }
        return new LongColumnChunkMetadata(path, type, codec, encodingStats, encodings, statistics, firstDataPage, dictionaryPageOffset, valueCount, totalSize, totalUncompressedSize);
    }

    public void setRowGroupOrdinal(int rowGroupOrdinal) {
        this.rowGroupOrdinal = rowGroupOrdinal;
    }

    public int getRowGroupOrdinal() {
        return this.rowGroupOrdinal;
    }

    public long getStartingPos() {
        this.decryptIfNeeded();
        long dictionaryPageOffset = this.getDictionaryPageOffset();
        long firstDataPageOffset = this.getFirstDataPageOffset();
        if (dictionaryPageOffset > 0L && dictionaryPageOffset < firstDataPageOffset) {
            return dictionaryPageOffset;
        }
        return firstDataPageOffset;
    }

    protected static boolean positiveLongFitsInAnInt(long value) {
        return value >= 0L && value + Integer.MIN_VALUE <= Integer.MAX_VALUE;
    }

    protected ColumnChunkMetadata(ColumnChunkProperties columnChunkProperties) {
        this(null, columnChunkProperties);
    }

    protected ColumnChunkMetadata(EncodingStats encodingStats, ColumnChunkProperties columnChunkProperties) {
        this.encodingStats = encodingStats;
        this.properties = columnChunkProperties;
    }

    protected void decryptIfNeeded() {
    }

    public CompressionCodecName getCodec() {
        this.decryptIfNeeded();
        return this.properties.codec();
    }

    public ColumnPath getPath() {
        return this.properties.path();
    }

    public PrimitiveType.PrimitiveTypeName getType() {
        this.decryptIfNeeded();
        return this.properties.type().getPrimitiveTypeName();
    }

    public PrimitiveType getPrimitiveType() {
        this.decryptIfNeeded();
        return this.properties.type();
    }

    public abstract long getFirstDataPageOffset();

    public abstract long getDictionaryPageOffset();

    public abstract long getValueCount();

    public abstract long getTotalUncompressedSize();

    public abstract long getTotalSize();

    public abstract Statistics<?> getStatistics();

    public IndexReference getColumnIndexReference() {
        this.decryptIfNeeded();
        return this.columnIndexReference;
    }

    public void setColumnIndexReference(IndexReference indexReference) {
        this.columnIndexReference = indexReference;
    }

    public IndexReference getOffsetIndexReference() {
        this.decryptIfNeeded();
        return this.offsetIndexReference;
    }

    public void setOffsetIndexReference(IndexReference offsetIndexReference) {
        this.offsetIndexReference = offsetIndexReference;
    }

    public void setBloomFilterOffset(long bloomFilterOffset) {
        this.bloomFilterOffset = bloomFilterOffset;
    }

    public long getBloomFilterOffset() {
        this.decryptIfNeeded();
        return this.bloomFilterOffset;
    }

    public Set<Encoding> getEncodings() {
        this.decryptIfNeeded();
        return this.properties.encodings();
    }

    public EncodingStats getEncodingStats() {
        this.decryptIfNeeded();
        return this.encodingStats;
    }

    public String toString() {
        this.decryptIfNeeded();
        return "ColumnMetaData{" + this.properties.toString() + ", " + this.getFirstDataPageOffset() + "}";
    }
}

