/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.ParquetEncoding;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.RleBitPackingHybridDecoder;
import org.apache.parquet.bytes.BytesUtils;

public interface ValueDecoder<T> {
    public void init(SimpleSliceInputStream var1);

    public void read(T var1, int var2, int var3);

    public void skip(int var1);

    public static ValueDecoder<int[]> createLevelsDecoder(int maxLevel, boolean vectorizedDecodingEnabled) {
        if (maxLevel == 0) {
            return new EmptyValueDecoder<int[]>();
        }
        return new RleBitPackingHybridDecoder(BytesUtils.getWidthFromMaxInt((int)maxLevel), vectorizedDecodingEnabled);
    }

    public static class EmptyValueDecoder<T>
    implements ValueDecoder<T> {
        @Override
        public void init(SimpleSliceInputStream input) {
        }

        @Override
        public void read(T values, int offset, int length) {
        }

        @Override
        public void skip(int n) {
        }
    }

    public static interface LevelsDecoderProvider {
        public ValueDecoder<int[]> create(int var1);
    }

    public static interface ValueDecodersProvider<T> {
        public ValueDecoder<T> create(ParquetEncoding var1);
    }
}

