/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.trino.parquet.ParquetReaderUtils;

public class BitPackingUtils {
    private BitPackingUtils() {
    }

    public static int unpack(boolean[] values, int offset, byte packedByte, int startBit, int endBit) {
        int nonNullCount = 0;
        for (int i = 0; i < endBit - startBit; ++i) {
            boolean value = (packedByte >>> startBit + i & 1) == 1;
            nonNullCount += ParquetReaderUtils.castToByteNegate(value);
            values[offset + i] = value;
        }
        return nonNullCount;
    }

    public static int unpack(boolean[] values, int offset, byte packedByte) {
        values[offset] = (packedByte & 1) == 1;
        values[offset + 1] = (packedByte >>> 1 & 1) == 1;
        values[offset + 2] = (packedByte >>> 2 & 1) == 1;
        values[offset + 3] = (packedByte >>> 3 & 1) == 1;
        values[offset + 4] = (packedByte >>> 4 & 1) == 1;
        values[offset + 5] = (packedByte >>> 5 & 1) == 1;
        values[offset + 6] = (packedByte >>> 6 & 1) == 1;
        values[offset + 7] = (packedByte >>> 7 & 1) == 1;
        return 8 - BitPackingUtils.bitCount(packedByte);
    }

    public static void unpack(byte[] values, int offset, byte packedByte, int startBit, int endBit) {
        for (int i = 0; i < endBit - startBit; ++i) {
            values[offset + i] = (byte)(packedByte >>> startBit + i & 1);
        }
    }

    public static void unpack8FromByte(byte[] values, int offset, byte packedByte) {
        values[offset] = (byte)(packedByte & 1);
        values[offset + 1] = (byte)(packedByte >>> 1 & 1);
        values[offset + 2] = (byte)(packedByte >>> 2 & 1);
        values[offset + 3] = (byte)(packedByte >>> 3 & 1);
        values[offset + 4] = (byte)(packedByte >>> 4 & 1);
        values[offset + 5] = (byte)(packedByte >>> 5 & 1);
        values[offset + 6] = (byte)(packedByte >>> 6 & 1);
        values[offset + 7] = (byte)(packedByte >>> 7 & 1);
    }

    public static int bitCount(byte value) {
        return Integer.bitCount(value & 0xFF);
    }
}

