/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Ints;
import io.airlift.units.DataSize;
import java.util.Set;

public class ParquetWriterOptions {
    private static final DataSize DEFAULT_MAX_ROW_GROUP_SIZE = DataSize.of((long)128L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private static final DataSize DEFAULT_MAX_PAGE_SIZE = DataSize.ofBytes((long)0x100000L);
    public static final int DEFAULT_MAX_PAGE_VALUE_COUNT = 60000;
    public static final int DEFAULT_BATCH_SIZE = 10000;
    public static final DataSize DEFAULT_MAX_BLOOM_FILTER_SIZE = DataSize.of((long)1L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    public static final double DEFAULT_BLOOM_FILTER_FPP = 0.05;
    private final int maxRowGroupSize;
    private final int maxPageSize;
    private final int maxPageValueCount;
    private final int batchSize;
    private final int maxBloomFilterSize;
    private final double bloomFilterFpp;
    private final Set<String> bloomFilterColumns;

    public static Builder builder() {
        return new Builder();
    }

    private ParquetWriterOptions(DataSize maxBlockSize, DataSize maxPageSize, int maxPageValueCount, int batchSize, DataSize maxBloomFilterSize, double bloomFilterFpp, Set<String> bloomFilterColumns) {
        this.maxRowGroupSize = Ints.saturatedCast((long)maxBlockSize.toBytes());
        this.maxPageSize = Ints.saturatedCast((long)maxPageSize.toBytes());
        this.maxPageValueCount = maxPageValueCount;
        this.batchSize = batchSize;
        this.maxBloomFilterSize = Ints.saturatedCast((long)maxBloomFilterSize.toBytes());
        this.bloomFilterFpp = bloomFilterFpp;
        this.bloomFilterColumns = ImmutableSet.copyOf(bloomFilterColumns);
        Preconditions.checkArgument((this.bloomFilterFpp > 0.0 && this.bloomFilterFpp < 1.0 ? 1 : 0) != 0, (Object)"bloomFilterFpp should be > 0.0 & < 1.0");
    }

    public int getMaxRowGroupSize() {
        return this.maxRowGroupSize;
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public int getMaxPageValueCount() {
        return this.maxPageValueCount;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public int getMaxBloomFilterSize() {
        return this.maxBloomFilterSize;
    }

    public Set<String> getBloomFilterColumns() {
        return this.bloomFilterColumns;
    }

    public double getBLoomFilterFpp() {
        return this.bloomFilterFpp;
    }

    public static class Builder {
        private DataSize maxBlockSize = DEFAULT_MAX_ROW_GROUP_SIZE;
        private DataSize maxPageSize = DEFAULT_MAX_PAGE_SIZE;
        private int maxPageValueCount = 60000;
        private int batchSize = 10000;
        private DataSize maxBloomFilterSize = DEFAULT_MAX_BLOOM_FILTER_SIZE;
        private Set<String> bloomFilterColumns = ImmutableSet.of();
        private double bloomFilterFpp = 0.05;

        public Builder setMaxBlockSize(DataSize maxBlockSize) {
            this.maxBlockSize = maxBlockSize;
            return this;
        }

        public Builder setMaxPageSize(DataSize maxPageSize) {
            this.maxPageSize = maxPageSize;
            return this;
        }

        public Builder setMaxPageValueCount(int maxPageValueCount) {
            this.maxPageValueCount = maxPageValueCount;
            return this;
        }

        public Builder setBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder setMaxBloomFilterSize(DataSize maxBloomFilterSize) {
            this.maxBloomFilterSize = maxBloomFilterSize;
            return this;
        }

        public Builder setBloomFilterFpp(double bloomFilterFpp) {
            this.bloomFilterFpp = bloomFilterFpp;
            return this;
        }

        public Builder setBloomFilterColumns(Set<String> columns) {
            this.bloomFilterColumns = columns;
            return this;
        }

        public ParquetWriterOptions build() {
            return new ParquetWriterOptions(this.maxBlockSize, this.maxPageSize, this.maxPageValueCount, this.batchSize, this.maxBloomFilterSize, this.bloomFilterFpp, this.bloomFilterColumns);
        }
    }
}

