/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.dictionary;

import com.google.common.base.MoreObjects;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.dictionary.Dictionary;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.PlainValueDecoders;

public class DoubleDictionary
implements Dictionary {
    private final double[] content;

    public DoubleDictionary(DictionaryPage dictionaryPage) {
        int length = dictionaryPage.getDictionarySize();
        long[] buffer = new long[length];
        PlainValueDecoders.LongPlainValueDecoder doubleReader = new PlainValueDecoders.LongPlainValueDecoder();
        doubleReader.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        doubleReader.read(buffer, 0, length);
        this.content = new double[length];
        for (int i = 0; i < length; ++i) {
            this.content[i] = Double.longBitsToDouble(buffer[i]);
        }
    }

    @Override
    public double decodeToDouble(int id) {
        return this.content[id];
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("content", (Object)this.content).toString();
    }
}

