/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.metadata;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.trino.parquet.ParquetCorruptionException;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.metadata.BlockMetadata;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.parquet.column.ColumnDescriptor;

public final class PrunedBlockMetadata {
    private final long rowCount;
    private final ParquetDataSourceId dataSourceId;
    private final Map<List<String>, ColumnChunkMetadata> columnMetadataByPath;

    public static PrunedBlockMetadata createPrunedColumnsMetadata(BlockMetadata blockMetadata, ParquetDataSourceId dataSourceId, Map<List<String>, ColumnDescriptor> descriptorsByPath) throws ParquetCorruptionException {
        Set<List<String>> requiredPaths = descriptorsByPath.keySet();
        Map columnMetadataByPath = (Map)blockMetadata.columns().stream().collect(ImmutableMap.toImmutableMap(column -> Arrays.asList(column.getPath().toArray()), Function.identity(), (oldValue, columnChunkMetadata) -> oldValue));
        ImmutableMap.Builder columnMetadataByPathBuilder = ImmutableMap.builderWithExpectedSize((int)requiredPaths.size());
        for (Map.Entry<List<String>, ColumnDescriptor> entry : descriptorsByPath.entrySet()) {
            List<String> requiredPath = entry.getKey();
            ColumnDescriptor columnDescriptor = entry.getValue();
            ColumnChunkMetadata columnChunkMetadata2 = (ColumnChunkMetadata)columnMetadataByPath.get(requiredPath);
            if (columnChunkMetadata2 == null) {
                throw new ParquetCorruptionException(dataSourceId, "Metadata is missing for column: %s", columnDescriptor);
            }
            columnMetadataByPathBuilder.put(requiredPath, (Object)columnChunkMetadata2);
        }
        return new PrunedBlockMetadata(blockMetadata.rowCount(), dataSourceId, (Map<List<String>, ColumnChunkMetadata>)columnMetadataByPathBuilder.buildOrThrow());
    }

    private PrunedBlockMetadata(long rowCount, ParquetDataSourceId dataSourceId, Map<List<String>, ColumnChunkMetadata> columnMetadataByPath) {
        this.rowCount = rowCount;
        this.dataSourceId = dataSourceId;
        this.columnMetadataByPath = columnMetadataByPath;
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public List<ColumnChunkMetadata> getColumns() {
        return ImmutableList.copyOf(this.columnMetadataByPath.values());
    }

    public ColumnChunkMetadata getColumnChunkMetaData(ColumnDescriptor columnDescriptor) throws ParquetCorruptionException {
        ColumnChunkMetadata columnChunkMetadata = this.columnMetadataByPath.get(Arrays.asList(columnDescriptor.getPath()));
        if (columnChunkMetadata == null) {
            throw new ParquetCorruptionException(this.dataSourceId, "Metadata is missing for column: %s", columnDescriptor);
        }
        return columnChunkMetadata;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("rowCount", this.rowCount).add("columnMetadataByPath", this.columnMetadataByPath).toString();
    }
}

