/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import io.trino.parquet.DataPage;
import io.trino.parquet.DataPageV1;
import io.trino.parquet.DataPageV2;
import io.trino.parquet.DictionaryPage;
import io.trino.parquet.Page;
import io.trino.parquet.ParquetCompressionUtils;
import io.trino.parquet.ParquetDataSourceId;
import io.trino.parquet.ParquetReaderUtils;
import io.trino.parquet.metadata.ColumnChunkMetadata;
import io.trino.parquet.reader.ChunkedInputStream;
import io.trino.parquet.reader.ParquetColumnChunkIterator;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;

public final class PageReader {
    private final ParquetDataSourceId dataSourceId;
    private final CompressionCodec codec;
    private final boolean hasOnlyDictionaryEncodedPages;
    private final boolean hasNoNulls;
    private final PeekingIterator<Page> compressedPages;
    private boolean dictionaryAlreadyRead;
    private int dataPageReadCount;

    public static PageReader createPageReader(ParquetDataSourceId dataSourceId, ChunkedInputStream columnChunk, ColumnChunkMetadata metadata, ColumnDescriptor columnDescriptor, @Nullable OffsetIndex offsetIndex, Optional<String> fileCreatedBy) {
        Statistics<?> columnStatistics = metadata.getStatistics();
        boolean hasNoNulls = columnStatistics != null && columnStatistics.getNumNulls() == 0L;
        boolean hasOnlyDictionaryEncodedPages = ParquetReaderUtils.isOnlyDictionaryEncodingPages(metadata);
        ParquetColumnChunkIterator compressedPages = new ParquetColumnChunkIterator(dataSourceId, fileCreatedBy, columnDescriptor, metadata, columnChunk, offsetIndex);
        return new PageReader(dataSourceId, metadata.getCodec().getParquetCompressionCodec(), compressedPages, hasOnlyDictionaryEncodedPages, hasNoNulls);
    }

    @VisibleForTesting
    public PageReader(ParquetDataSourceId dataSourceId, CompressionCodec codec, Iterator<? extends Page> compressedPages, boolean hasOnlyDictionaryEncodedPages, boolean hasNoNulls) {
        this.dataSourceId = Objects.requireNonNull(dataSourceId, "dataSourceId is null");
        this.codec = codec;
        this.compressedPages = Iterators.peekingIterator(compressedPages);
        this.hasOnlyDictionaryEncodedPages = hasOnlyDictionaryEncodedPages;
        this.hasNoNulls = hasNoNulls;
    }

    public boolean hasNoNulls() {
        return this.hasNoNulls;
    }

    public boolean hasOnlyDictionaryEncodedPages() {
        return this.hasOnlyDictionaryEncodedPages;
    }

    public DataPage readPage() {
        if (!this.compressedPages.hasNext()) {
            return null;
        }
        Page compressedPage = (Page)this.compressedPages.next();
        Preconditions.checkState((boolean)(compressedPage instanceof DataPage), (String)"Found page %s instead of a DataPage", (Object)compressedPage);
        ++this.dataPageReadCount;
        try {
            if (compressedPage instanceof DataPageV1) {
                DataPageV1 dataPageV1 = (DataPageV1)compressedPage;
                if (!this.arePagesCompressed()) {
                    return dataPageV1;
                }
                return new DataPageV1(ParquetCompressionUtils.decompress(this.dataSourceId, this.codec, dataPageV1.getSlice(), dataPageV1.getUncompressedSize()), dataPageV1.getValueCount(), dataPageV1.getUncompressedSize(), dataPageV1.getFirstRowIndex(), dataPageV1.getRepetitionLevelEncoding(), dataPageV1.getDefinitionLevelEncoding(), dataPageV1.getValueEncoding());
            }
            DataPageV2 dataPageV2 = (DataPageV2)compressedPage;
            if (!dataPageV2.isCompressed()) {
                return dataPageV2;
            }
            int uncompressedSize = dataPageV2.getUncompressedSize() - dataPageV2.getDefinitionLevels().length() - dataPageV2.getRepetitionLevels().length();
            return new DataPageV2(dataPageV2.getRowCount(), dataPageV2.getNullCount(), dataPageV2.getValueCount(), dataPageV2.getRepetitionLevels(), dataPageV2.getDefinitionLevels(), dataPageV2.getDataEncoding(), ParquetCompressionUtils.decompress(this.dataSourceId, this.codec, dataPageV2.getSlice(), uncompressedSize), dataPageV2.getUncompressedSize(), dataPageV2.getFirstRowIndex(), dataPageV2.getStatistics(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not decompress page", e);
        }
    }

    public DictionaryPage readDictionaryPage() {
        Preconditions.checkState((!this.dictionaryAlreadyRead ? 1 : 0) != 0, (Object)"Dictionary was already read");
        Preconditions.checkState((this.dataPageReadCount == 0 ? 1 : 0) != 0, (Object)("Dictionary has to be read first but " + this.dataPageReadCount + " was read already"));
        this.dictionaryAlreadyRead = true;
        if (!(this.compressedPages.peek() instanceof DictionaryPage)) {
            return null;
        }
        try {
            DictionaryPage compressedDictionaryPage = (DictionaryPage)this.compressedPages.next();
            return new DictionaryPage(ParquetCompressionUtils.decompress(this.dataSourceId, this.codec, compressedDictionaryPage.getSlice(), compressedDictionaryPage.getUncompressedSize()), compressedDictionaryPage.getDictionarySize(), compressedDictionaryPage.getEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading dictionary page", e);
        }
    }

    public boolean hasNext() {
        return this.compressedPages.hasNext();
    }

    public DataPage getNextPage() {
        this.verifyDictionaryPageRead();
        return (DataPage)this.compressedPages.peek();
    }

    public void skipNextPage() {
        this.verifyDictionaryPageRead();
        this.compressedPages.next();
    }

    public boolean arePagesCompressed() {
        return this.codec != CompressionCodec.UNCOMPRESSED;
    }

    private void verifyDictionaryPageRead() {
        Preconditions.checkArgument((boolean)this.dictionaryAlreadyRead, (Object)"Dictionary has to be read first");
    }
}

