/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.decoders;

import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.BitPackingUtils;
import io.trino.parquet.reader.flat.VectorBitPackingUtils;
import java.util.Objects;

public class BooleanPlainValueDecoders {
    private BooleanPlainValueDecoders() {
    }

    public static ValueDecoder<byte[]> createBooleanPlainValueDecoder(boolean vectorizedDecodingEnabled) {
        return vectorizedDecodingEnabled ? new VectorBooleanPlainValueDecoder() : new BooleanPlainValueDecoder();
    }

    private static final class VectorBooleanPlainValueDecoder
    extends AbstractBooleanPlainValueDecoder {
        private VectorBooleanPlainValueDecoder() {
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            int inputBytesRead;
            if (this.alreadyReadBits != 0) {
                int bitsRemaining = 8 - this.alreadyReadBits;
                int chunkSize = Math.min(bitsRemaining, length);
                BitPackingUtils.unpack(values, offset, this.partiallyReadByte, this.alreadyReadBits, this.alreadyReadBits + chunkSize);
                this.alreadyReadBits = (this.alreadyReadBits + chunkSize) % 8;
                if (length == chunkSize) {
                    return;
                }
                offset += chunkSize;
                length -= chunkSize;
            }
            int bytesToRead = length / 8;
            byte[] inputArray = this.input.getByteArray();
            int inputOffset = this.input.getByteArrayOffset();
            for (inputBytesRead = 0; inputBytesRead < bytesToRead; ++inputBytesRead) {
                VectorBitPackingUtils.vectorUnpack8FromByte(values, offset, inputArray[inputOffset + inputBytesRead]);
                offset += 8;
            }
            this.input.skip(inputBytesRead);
            this.alreadyReadBits = length % 8;
            if (this.alreadyReadBits != 0) {
                this.partiallyReadByte = this.input.readByte();
                BitPackingUtils.unpack(values, offset, this.partiallyReadByte, 0, this.alreadyReadBits);
            }
        }
    }

    private static final class BooleanPlainValueDecoder
    extends AbstractBooleanPlainValueDecoder {
        private BooleanPlainValueDecoder() {
        }

        @Override
        public void read(byte[] values, int offset, int length) {
            if (this.alreadyReadBits != 0) {
                int bitsRemaining = 8 - this.alreadyReadBits;
                int chunkSize = Math.min(bitsRemaining, length);
                BitPackingUtils.unpack(values, offset, this.partiallyReadByte, this.alreadyReadBits, this.alreadyReadBits + chunkSize);
                this.alreadyReadBits = (this.alreadyReadBits + chunkSize) % 8;
                if (length == chunkSize) {
                    return;
                }
                offset += chunkSize;
                length -= chunkSize;
            }
            int bytesToRead = length / 8;
            while (bytesToRead > 0) {
                byte packedByte = this.input.readByte();
                BitPackingUtils.unpack8FromByte(values, offset, packedByte);
                --bytesToRead;
                offset += 8;
            }
            this.alreadyReadBits = length % 8;
            if (this.alreadyReadBits != 0) {
                this.partiallyReadByte = this.input.readByte();
                BitPackingUtils.unpack(values, offset, this.partiallyReadByte, 0, this.alreadyReadBits);
            }
        }
    }

    private static abstract class AbstractBooleanPlainValueDecoder
    implements ValueDecoder<byte[]> {
        protected SimpleSliceInputStream input;
        protected int alreadyReadBits;
        protected byte partiallyReadByte;

        private AbstractBooleanPlainValueDecoder() {
        }

        @Override
        public void init(SimpleSliceInputStream input) {
            this.input = Objects.requireNonNull(input, "input is null");
            this.alreadyReadBits = 0;
        }

        @Override
        public void skip(int n) {
            if (this.alreadyReadBits != 0) {
                int chunkSize = Math.min(8 - this.alreadyReadBits, n);
                n -= chunkSize;
                this.alreadyReadBits = (this.alreadyReadBits + chunkSize) % 8;
            }
            this.input.skip(n / 8);
            if (n % 8 != 0) {
                this.alreadyReadBits = n % 8;
                this.partiallyReadByte = this.input.readByte();
            }
        }
    }
}

