/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.trino.parquet.ParquetReaderUtils;
import io.trino.spi.block.Block;
import java.util.List;

public interface ColumnAdapter<BufferType> {
    default public BufferType createTemporaryBuffer(int currentOffset, int size, BufferType buffer) {
        return this.createBuffer(size);
    }

    public BufferType createBuffer(int var1);

    public void copyValue(BufferType var1, int var2, BufferType var3, int var4);

    public Block createNullableBlock(boolean[] var1, BufferType var2);

    default public Block createNullableDictionaryBlock(BufferType dictionary, int nonNullsCount) {
        boolean[] nulls = new boolean[nonNullsCount + 1];
        nulls[nonNullsCount] = true;
        return this.createNullableBlock(nulls, dictionary);
    }

    public Block createNonNullBlock(BufferType var1);

    default public void unpackNullValues(BufferType source, BufferType destination, boolean[] isNull, int destOffset, int nonNullCount, int totalValuesCount) {
        int srcOffset = 0;
        while (srcOffset < nonNullCount) {
            this.copyValue(source, srcOffset, destination, destOffset);
            srcOffset += ParquetReaderUtils.castToByteNegate(isNull[destOffset]);
            ++destOffset;
        }
    }

    public void decodeDictionaryIds(BufferType var1, int var2, int var3, int[] var4, BufferType var5);

    public long getSizeInBytes(BufferType var1);

    public BufferType merge(List<BufferType> var1);
}

