/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.writer.valuewriter;

import com.google.common.base.Preconditions;
import io.trino.parquet.writer.valuewriter.PrimitiveValueWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Type;
import java.util.Objects;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.PrimitiveType;

public class FixedLenByteArrayShortDecimalValueWriter
extends PrimitiveValueWriter {
    private final DecimalType decimalType;

    public FixedLenByteArrayShortDecimalValueWriter(ValuesWriter valuesWriter, Type type, PrimitiveType parquetType) {
        super(parquetType, valuesWriter);
        this.decimalType = (DecimalType)Objects.requireNonNull(type, "type is null");
        Preconditions.checkArgument((boolean)this.decimalType.isShort(), (Object)"type is not a short decimal");
        Preconditions.checkArgument((parquetType.getTypeLength() > 0 && parquetType.getTypeLength() <= 8 ? 1 : 0) != 0, (String)"Type length %s must be in range 1-%s", (int)parquetType.getTypeLength(), (int)8);
    }

    @Override
    public void write(Block block) {
        ValuesWriter valuesWriter = Objects.requireNonNull(this.getValuesWriter(), "valuesWriter is null");
        Statistics<?> statistics = Objects.requireNonNull(this.getStatistics(), "statistics is null");
        boolean mayHaveNull = block.mayHaveNull();
        byte[] buffer = new byte[this.getTypeLength()];
        Binary reusedBinary = Binary.fromReusedByteArray((byte[])buffer);
        for (int i = 0; i < block.getPositionCount(); ++i) {
            if (mayHaveNull && block.isNull(i)) continue;
            long value = this.decimalType.getLong(block, i);
            FixedLenByteArrayShortDecimalValueWriter.storeLongIntoBuffer(value, buffer);
            valuesWriter.writeBytes(reusedBinary);
            statistics.updateStats(reusedBinary);
        }
    }

    private static void storeLongIntoBuffer(long unscaledValue, byte[] buffer) {
        switch (buffer.length) {
            case 1: {
                buffer[0] = (byte)unscaledValue;
                break;
            }
            case 2: {
                buffer[0] = (byte)(unscaledValue >> 8);
                buffer[1] = (byte)unscaledValue;
                break;
            }
            case 3: {
                buffer[0] = (byte)(unscaledValue >> 16);
                buffer[1] = (byte)(unscaledValue >> 8);
                buffer[2] = (byte)unscaledValue;
                break;
            }
            case 4: {
                buffer[0] = (byte)(unscaledValue >> 24);
                buffer[1] = (byte)(unscaledValue >> 16);
                buffer[2] = (byte)(unscaledValue >> 8);
                buffer[3] = (byte)unscaledValue;
                break;
            }
            case 5: {
                buffer[0] = (byte)(unscaledValue >> 32);
                buffer[1] = (byte)(unscaledValue >> 24);
                buffer[2] = (byte)(unscaledValue >> 16);
                buffer[3] = (byte)(unscaledValue >> 8);
                buffer[4] = (byte)unscaledValue;
                break;
            }
            case 6: {
                buffer[0] = (byte)(unscaledValue >> 40);
                buffer[1] = (byte)(unscaledValue >> 32);
                buffer[2] = (byte)(unscaledValue >> 24);
                buffer[3] = (byte)(unscaledValue >> 16);
                buffer[4] = (byte)(unscaledValue >> 8);
                buffer[5] = (byte)unscaledValue;
                break;
            }
            case 7: {
                buffer[0] = (byte)(unscaledValue >> 48);
                buffer[1] = (byte)(unscaledValue >> 40);
                buffer[2] = (byte)(unscaledValue >> 32);
                buffer[3] = (byte)(unscaledValue >> 24);
                buffer[4] = (byte)(unscaledValue >> 16);
                buffer[5] = (byte)(unscaledValue >> 8);
                buffer[6] = (byte)unscaledValue;
                break;
            }
            case 8: {
                buffer[0] = (byte)(unscaledValue >> 56);
                buffer[1] = (byte)(unscaledValue >> 48);
                buffer[2] = (byte)(unscaledValue >> 40);
                buffer[3] = (byte)(unscaledValue >> 32);
                buffer[4] = (byte)(unscaledValue >> 24);
                buffer[5] = (byte)(unscaledValue >> 16);
                buffer[6] = (byte)(unscaledValue >> 8);
                buffer[7] = (byte)unscaledValue;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number of bytes: " + buffer.length);
            }
        }
    }
}

